//------------------------------------------------------------
// Circle Routines - Barny Mercer 3/8/95 @ 11:45pm
//------------------------------------------------------------

#include "vgafunc.h"
#include <memory.h>
#include <math.h>
#include <conio.h>

// this is the same as the 'vga' variable in vgafunc.cpp
// but is renamed for this function only

unsigned char *screen= (unsigned char *)0xA0000000;

//------------------------------------------------------------
// DrawCircle -  Pretty useless routine which illustrates the
//		 fundamentals of circle drawing
//------------------------------------------------------------

void DrawCircle( int X, int Y, int Radius, unsigned char Colour )
{
    float xt, yt;
    float rt;

    // begin with offset = 0 degrees

    for (float Tmp=0; Tmp<6.3; Tmp += 0.01)
    {
	xt = (float)Radius * cos(Tmp) + X;
	yt = (float)Radius * sin(Tmp) + Y;

	PutPixel( (int)xt, (int)yt, Colour );
    }

}
//------------------------------------------------------------
// ImpDrawCircle - A much better routine which is based on the
//		   above function but uses a couple of methods
//		   to increase the speed & accuracy.
//------------------------------------------------------------

void ImpDrawCircle( int X, int Y, int Radius, unsigned char Colour )
{
    float xt, yt;
    float rt, increment;

    int NewX, NewY;

    int NewX1, NewY1;
    int NewX2, NewY2;
    int NewX3, NewY3;
    int NewX4, NewY4;

    if (Radius <= 0)
	Radius = 1;

    increment = 1/(float)Radius;

    // calculate X, Y change for each segment based on radius

    for (float Tmp=0; Tmp<1.6; Tmp += increment)
    {
	// positioning no longer happens here
	xt = (float)Radius * (float)cos(Tmp);
	yt = (float)Radius * (float)sin(Tmp);

	if ( abs( (long)(xt - (int)xt)) < 0.5 )
	{
	    if (xt > 0)
		NewX = (int)(xt+0.5);
	    else
		NewX = (int)(xt-0.5);
	}
	else
	    NewX = (int)(xt);

	if ( abs( (long)(yt - (int)yt)) < 0.5 )
	{
	    if (yt > 0)
		NewY = (int)(yt+0.5);
	    else
		NewY = (int)(yt-0.5);
	}
	else
	    NewY = (int)(yt);

	NewX1 = NewX + X;
	NewY1 = NewY + Y;

	NewX2 = (NewX * -1) + X;
	NewY2 = (NewY * -1) + Y;

	NewX3 = (NewX * -1) + X;
	NewY3 =  NewY + Y;

	NewX4 =  NewX + X;
	NewY4 = (NewY * -1) + Y;

	screen[( (NewY1<<8) + (NewY1<<6)+NewX1 )] = Colour;
	screen[( (NewY2<<8) + (NewY2<<6)+NewX2 )] = Colour;
	screen[( (NewY3<<8) + (NewY3<<6)+NewX3 )] = Colour;
	screen[( (NewY4<<8) + (NewY4<<6)+NewX4 )] = Colour;
    }

}
