//-----------------------------------------------
// VGA Circles - A program to demonstrate drawing
//		 circles.  Barny Mercer  - 3/8/95
//-----------------------------------------------

#include "vgafunc.h"
#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/timeb.h>

void SmallPoorCircle( void );
void SmallImprCircle( void );
void PoorCocen( void );
void ImprCocen( void );
void PoorRandCirc( void );
void ImprRandCirc( void );

void Intro(void);
void Outro(void);

void main(void)
{
    int Tmp=0;

    Intro();

    // VGA mode
    VidMode(VID_320x200);

    // draw small circles to display accuracy
    SmallPoorCircle();
    SmallImprCircle();

    // draw cocentric circles to demonstrate speed and accuracy
    PoorCocen();
    ImprCocen();

    // draw random circles because I've done this with everything else <grin>
    PoorRandCirc();
    ImprRandCirc();

    // return us to text mode
    VidMode(VID_TEXT);

    Outro();

}
//-----------------------------------------------------------
void SmallPoorCircle(void)
{
    printf( "Small circle - Poor algortihm" );
    DrawCircle( 160, 100, 2, 15);

    getch();
    VidMode(VID_320x200);   // clear screen and reset text position
}
//-----------------------------------------------------------
void SmallImprCircle(void)
{
    printf( "Small circle - Improved algorithm" );
    ImpDrawCircle( 160, 100, 2, 15);

    getch();
    VidMode(VID_320x200);   // clear screen and reset text position
}
//-----------------------------------------------------------
void PoorCocen(void)
{
    printf( "Cocentric circles - Poor algorithm" );

    for (int Tmp=1; Tmp<100; Tmp += 3)
	DrawCircle( 160, 100, Tmp, Tmp );

    getch();

    VidMode(VID_320x200);
}
//-----------------------------------------------------------
void ImprCocen(void)
{
    printf( "Cocentric circles - Improved algorithm" );

    for (int Tmp=1; Tmp<100; Tmp += 3)
	ImpDrawCircle( 160, 100, Tmp, Tmp );

    getch();

    VidMode(VID_320x200);
}
//-----------------------------------------------------------
void PoorRandCirc(void)
{
    printf( "Yet another random routine...... hehe" );

    getch();

    for (int Tmp=0; Tmp<100; Tmp++)
	DrawCircle( (rand()%320), (rand()%200), (rand()%100), (rand()%256) );

    getch();

    VidMode(VID_320x200);
}
//-----------------------------------------------------------
void ImprRandCirc(void)
{
    printf( "Surprised?  <grin>" );

    getch();

    for (int Tmp=0; Tmp<100; Tmp++)
	ImpDrawCircle( (rand()%320), (rand()%200), (rand()%100), (rand()%256) );

    getch();

    VidMode(VID_320x200);
}
//-----------------------------------------------------------
void Intro(void)
{
    VidMode( VID_TEXT );    // make sure that we are in text mode

    printf( "Hi there & welcome to the second part of this VGA tutorial.\n\n" );
    printf( "This program concerns it's self with circles and looks at two functions\n");
    printf( "for drawing them....\n\n");
    printf( "1.   This routine is slow & inacurate but forms the basis of the second\n" );
    printf( "     routine.\n");
    printf( "2.   Much better.  Faster & more accurate.\n\n" );
    printf( "Take a look....." );

    getch();

    // clear screen by re-selecting text mode
    VidMode(VID_TEXT);
}
//-----------------------------------------------------------
void Outro(void)
{
    printf( "Good.  Now we have a semi-decent circle routine to add to our library.\n\n");
    printf( "I hope you've enjoyed this tutorial and that you'll find it useful.\n\n");
    printf( "Many thanks to Richard Griffiths who's been porting this code to Pascal\n");
    printf( "for me.\nAs yet, this tutorial is still not available by FTP but I'm working\n");
    printf( "on it.\n\nBye for now......  \n\n" );
    printf( "Barny Mercer      : barny.mercer@zetnet.co.uk \n" );
    printf( "                  : http://www.zetnet.co.uk/users/bmercer/ \n\n");
    printf( "Richard Griffiths : richard.griffiths@zetnet.co.uk \n" );
    printf( "                  : http://www.zetnet.co.uk/users/rgriff/\n");

    getch();

}
