//////////////////////////////////
// VGA Functions - Barny Mercer //
//				//
// Created : 1/8/95 @ 6:45pm	//
//////////////////////////////////

#include "vgafunc.h"
#include <memory.h>
#include <math.h>
#include <conio.h>

unsigned char *vga= (unsigned char *)0xA0000000;

//-------------------------------------------------
// Clear entire video screen to specified colour
//-------------------------------------------------

void Cls( unsigned char Colour ) { memset( vga, Colour, 64000 ); }

//---------------------------------
// Change to specified video mode
//---------------------------------

void VidMode( int Mode )
{
    _asm
    {
	mov ax, [Mode]
	int 10h
    }
}

//------------------------------------------------------
// PutPixel - Uses assembly code to place a pixel
//	      at X, Y directly to memory
//------------------------------------------------------

void PutPixel( int X, int Y, unsigned char Colour )
{
      _asm
      {
	  mov ax, 0xA000   ; point AX to video memory
	  mov es, ax	   ; move segment pointer to ES
			   ; (actual pointer)
	  mov bx, [Y]
	  mov dx, bx	   ; register to register is faster by 1 clock

	  mov dh, dl	   ; dx=y*256 + y
	  xor dl, dl	   ; clear lower byte of DX

	  shl bx, 6	   ; bx=y*64
	  add bx, dx	   ; bx=y*320

	  add bx, [X]	   ; bx=(y*320)+x
	  mov di, bx	   ; move video pointer to correct place

	  mov al, [Colour]
	  mov es:[di], al  ; move colour to memory
      }
}

//---------------------------------------------------
// DrawLine - Draw a line from (X1, Y1)-(X2, Y2) in
//	      specified colour.
//---------------------------------------------------

void FloatDrawLine( int X1, int Y1, int X2, int Y2, unsigned char Colour )
{
    float Slope, YPos, XPos;

    // swap values if necessary
    if (X2<X1)
    {
	int Tmp = X2;
	X2 = X1;
	X1 = Tmp;

	Tmp = Y2;
	Y2 = Y1;
	Y1 = Tmp;
    }

    if ( (Y2 != Y1) &&
	 (X2 != X1)
       )
    {
	Slope = (float)(Y2-Y1)/(X2-X1); // gradient of line

	if (Slope<1)
	{
	    YPos = Y1;

	    for (int Temp=X1; Temp<=X2; Temp++)
	    {
		PutPixel( Temp, (int)YPos, Colour );
		YPos += Slope;
	    }
	}
	else
	{
	    XPos = X1;

	    for (int Temp=Y1; Temp<=Y2; Temp++)
	    {
		PutPixel( (int)XPos, Temp, Colour );
		XPos += (1/Slope);
	    }
	}
    }
    else   // must be horizonal or verticle
    {
	if (X1 == X2)	// verticle
	{
	    for (int Temp=Y1; Temp<=Y2; Temp++)
		PutPixel( X1, Temp, Colour );
	}
	else	// horizontal
	{
	    for (int Temp=X1; Temp<=X2; Temp++)
		PutPixel( Temp, Y1, Colour );
	}
    }

}

//------------------------------------------------------------
// BresDrawLine - Draw a line from (X1, Y1)-(X2, Y2) in
//		  specified colour using Bresenham's Algorithm
//		  Note : we also use a different pixel method
//			 here to make things easier.
//------------------------------------------------------------

void BresDrawLine( int X1, int Y1, int X2, int Y2, unsigned char Colour )
{
    int XScope, YScope;
    int XDir = 1;
    int YDir = 320;

    int LinearDeviance = 0; // deviance of pixel line from mathematical line

    unsigned int Offset = 0;	 // must be unsigned for range

    int Length = 0;

    XScope = (X2 - X1);
    YScope = (Y2 - Y1);

    if (XScope < 0)
    {
	XScope =- XScope;   // get absolute value of X term
	XDir = -1;
    }

    if (YScope < 0)
    {
	YScope =- YScope;   // get absoulte value of Y term
	YDir = -320;
    }

    Offset = X1 + (Y1*320); // video offset of first point
    LinearDeviance = 0;

    if (XScope > YScope)   // then begin incrementing on X
    {
	Length = XScope+1;

	for (int Tmp=0; Tmp <= Length; Tmp++)
	{
	    vga[Offset] = Colour;	// put pixel

	    LinearDeviance += YScope;

	    if (LinearDeviance >= XScope)    // error threshold has been exceeded
	    {
		LinearDeviance -= XScope;
		Offset += YDir;
	    }

	    Offset += XDir;
	}
    }
    else	    // begin incrementing on Y
    {
	Length = YScope+1;

	for (int Tmp=0; Tmp <= Length; Tmp++)
	{
	    vga[Offset] = Colour;	// put pixel

	    LinearDeviance += XScope;

	    if (LinearDeviance >= YScope)    // error threshold has been exceeded
	    {
		LinearDeviance -= YScope;
		Offset += XDir;
	    }

	    Offset += YDir;
	}
    }
}

//------------------------------------------------------------
// Round - Rounds a value of type float to the nearest integer
//------------------------------------------------------------

int Round( float Value )
{
    if ( abs( (long)(Value - (int)Value)) < 0.5 )
	if (Value > 0)
	    return ( (int)(Value+0.5) );
	else
	    return ( (int)(Value-0.5) );

    return ( (int)Value );
}
