////////////////////////////////////////
// VGA Lines           - Barny Mercer //
//                                    //
// Created : 1/8/95 @ 6:45pm          //
////////////////////////////////////////

#include <conio.h>
#include "vgafunc.h"
#include <stdlib.h>
#include <stdio.h>
#include <sys/timeb.h>

void Intro(void);
void Outro(void);
void TestFloatLine(void);
void TestBresLine(void);
void ScrollFloatLine(void);
void ScrollBresLine(void);

void main(void)
{
    // make sure that we are in text mode
    VidMode( VID_TEXT );

    Intro();

    TestFloatLine();
    ScrollFloatLine();
    TestBresLine();
    ScrollBresLine();

    Outro();
}

void Intro(void)
{
    printf( "Hi there & welcome to the second installment of my VGA tutorial.\n\n" );
    printf( "This program concerns it's self with lines and looks at two functions\n");
    printf( "for drawing them....\n\n");
    printf( "1.  This routine uses the PutPixel function that we developed in part I\n");
    printf( "    As you will see, it's pretty fast, but let's get faster.....\n\n");
    printf( "2.  Ta da!  By restricting this function to integer math and making no\n");
    printf( "    function calls we have increased the speed tremendously.\n\n");
    printf( "Each function is put through the following tests : \n\n");
    printf( "   5000 lines of random length, colour & orientation are drawn. \n");
    printf( "   25 screens of 200 lines are drawn to create a scrolling effect. \n");

    getch();

    // clear screen by re-selecting text mode
    VidMode(VID_TEXT);
}

void Outro(void)
{
    printf( "Well...  there you have it.  A nice fast DrawLine routine.\n\n");
    printf( "I hope you've enjoyed this tutorial and that you'll find it useful.\n\n");
    printf( "Many thanks to Richard Griffiths who's been porting this code to Pascal\n");
    printf( "for me.\nAs yet, this tutorial is still not available by FTP but I'm working\n");
    printf( "on it.\n\nBye for now......  \n\n" );
    printf( "Barny Mercer      : barny.mercer@zetnet.co.uk \n" );
    printf( "                  : http://www.zetnet.co.uk/users/bmercer/ \n\n");
    printf( "Richard Griffiths : richard.griffiths@zetnet.co.uk \n" );
    printf( "                  : http://www.zetnet.co.uk/users/rgriff/\n");

    getch();

}

void TestFloatLine(void)
{
    printf( "Floating Point line drawing.....\n" );
    getch();

    VidMode(VID_320x200);

    for (int Tmp=0; Tmp<5000; Tmp++)
    {
	FloatDrawLine( (rand()%319),(rand()%199),(rand()%319),(rand()%199),(rand()%255) );
    }

    getch();

    VidMode(VID_TEXT);
}

void ScrollFloatLine(void)
{
    printf( "Floating point scroller.....\n" );
    getch();
    VidMode(VID_320x200);

    for (int Tmp=0; Tmp<25; Tmp++)
    {
	for (int YLoops=0; YLoops<200; YLoops++)
	{
	    FloatDrawLine( 0, YLoops, 319, YLoops, YLoops+Tmp);
	}
    }

    getch();

    VidMode(VID_TEXT);
}

void TestBresLine(void)
{
    printf( "Optimised (Bresenham's Algorithm) line drawing..\n" );
    getch();
    VidMode(VID_320x200);

    for (int Tmp=0; Tmp<5000; Tmp++)
    {
	BresDrawLine( (rand()%319),(rand()%199),(rand()%319),(rand()%199),(rand()%255) );
    }

    getch();

    VidMode(VID_TEXT);
}

void ScrollBresLine(void)
{
    printf( "Bressenham scroller.....\n" );
    getch();
    VidMode(VID_320x200);

    for (int Tmp=0; Tmp<25; Tmp++)
    {
	for (int YLoops=0; YLoops<200; YLoops++)
	{
	    BresDrawLine( 0, YLoops, 319, YLoops, YLoops+Tmp);
	}
    }

    getch();

    VidMode(VID_TEXT);
}
