{$X+}
{$G+}


program lines(input, output);

Uses Crt;

Const VGA = $A000;

{------------------------------------------------------------------------}

procedure Set_Vid_mode_to_320x200;

Begin
    asm
       mov ax, 13h      {store 13h in AX}
       int 10h          {call interrupt }
    end;
end;

{------------------------------------------------------------------------}

Procedure Cls (Colour : Byte);
   { This clears the screen to the specified color }
BEGIN
  Fillchar (Mem [$a000:0],64000,colour);
END;
{------------------------------------------------------------------------}

procedure Print_ASM_Pixel (X, Y : Integer; Colour : Byte);

{This is our super fast Pixel algorithum}

begin
    asm
      mov ax, 0a000h   { point AX to video memory   }
      mov es, ax       { move segment pointer to ES }
                       { (actual pointer)           }
      mov bx, [Y]
      mov ax, bx       { register to register is faster by 1 clock}

      mov ah, al       { ax=y*256 + y}
      mov al,  0       { ax=y*256    }

      shl bx, 6        { bx=y*64     }
      add bx, ax       { bx=y*320    }

      add bx, [X]      { ax=(y*320)+x}
      mov di, bx       { move video pointer to correct place}

      mov al, [Colour]
      mov es:[di], al  { move colour to memory }
   end;
end;



{------------------------------------------------------------------------}

procedure Return_Vid_Mode_To_Text;

begin
   asm
    mov ax, 03h      {store 03h in AX}
    int 10h          {call interrupt }
   end;
end;



{------------------------------------------------------------------------}


procedure FloatDrawLine( x1, y1, x2, y2 : integer; Colour : byte);

var Temp,
    Slope,
    YPos,
    XPos : real;
    Temp1,
    Temp2,
    Counter,
    Pixel_X,
    Pixel_Y,
    TempS : integer;

begin


     {Do the test, and swap if need be}

     if (x2<x1) then  BEGIN

         Temp1 := x2;
         x2 := x1;
         x1 := Temp1;

         Temp1 := y2;
         y2 := y1;
         y1 := Temp1;

     END;


    if (y2 <> y1) and (x2 <> x1) then BEGIN

        Slope := (y2-y1)/(x2-x1); {Find the gradient}

              if (Slope < 1) then BEGIN
                 Ypos := y1;

                 Temp := int(Ypos);
                 Temp := Pixel_Y;

                 Temp := int(Slope);
                 Temp := TempS;

                      for counter := x1 to x2 do
                          Print_ASM_Pixel (counter, Pixel_Y, Colour);
                      Pixel_Y := Pixel_Y + TempS;
              END
           else
              BEGIN

                       XPos := x1;

                       Temp := int(XPos);
                       Temp := Pixel_X;


                       for counter := y1 to y2 do;
                        Print_ASM_Pixel( Pixel_X, counter, colour);
                       Pixel_X := Round(1/Slope);
              END;
     end

   else {must be horizontal or verticle}

     begin

                if (x1 = x2) then begin  {it's vertical}

                  Temp := int(y1);
                  Temp := Temp1;

                  Temp := int(y2);
                  Temp := Temp2;

                       for counter:= Temp1 to Temp2 do
                           Print_ASM_Pixel( x1, counter, colour);

                end
               else  {it must be horizontal}
                begin

                Temp := int(x1);
                Temp := Temp1;

                Temp := int(x2);
                Temp := Temp2;

                     for counter := Temp1 to Temp2 do
                         Print_ASM_Pixel( Counter, y1, colour);
                end;

     end;

end;
{------------------------------------------------------------------------}
{Here we ditch our Print_ASM_Pixel for even more speed}

procedure  BresDrawLine( x1, y1, x2, y2 : integer; colour : byte);

var XScope,
    YScope,
    XDir,
    YDir,
    LinearDeviance,
    Length,
    Counter : integer;
    VGA_Offset : Byte;


begin
    XDir := 1;
    YDir := 320;

    LinearDeviance := 0;

    VGA_Offset := 0;

    Length := 0;

    XScope := (x2 - x1);
    YScope := (y2 - y1);

   if (XScope < 0) then
   BEGIN
        XScope := abs(XScope);
        XDir := -1;
   END;

   if (YScope < 0) then
   BEGIN
        YScope := abs(YScope);
        YDir := -320;
   END;

      VGA_Offset := x1 + (y1*320);
      LinearDeviance := 0;

       if (XScope > YScope) then
       BEGIN {to increment X}

           Length := XScope + 1;


               for  counter := 0 to length do BEGIN

                   Mem [VGA:VGA_Offset] := Colour;
                   LinearDeviance := (LinearDeviance + YScope);     {here's one}

                      if (LinearDeviance >= XScope) then
                      BEGIN
                           LinearDeviance := (LinearDeviance - XScope);              {-}
                           VGA_Offset := VGA_Offset + YDir;                    {+}
                      END;


                  VGA_Offset := (VGA_Offset + XDir);  {+}

               END;
       END
   else          {increment Y instead}
       BEGIN

            Length := YScope + 1;

                  for counter:= 0 to length do BEGIN

                       Mem [VGA:VGA_Offset] := Colour;

                       LinearDeviance := (LinearDeviance + XScope);            {+}

                       if (LinearDeviance >= YScope) then BEGIN {to big?}

                           LinearDeviance := (LinearDeviance - YScope); {-}

                           VGA_Offset := (VGA_Offset + XDir);                         {+}
                       END;

                    VGA_Offset := (VGA_Offset + YDir);                         {+}

                  END;
   END;

end;

{------------------------------------------------------------------------}

procedure draw_random_slow_lines;

var counter : integer;

begin
     Set_Vid_mode_to_320x200;
      Randomize;
       for counter := 1 to 5000 do BEGIN
        FloatDrawLine (random(318) + 1, random( 198) + 1, random(318) + 1, random(198) + 1, random(256));
       END;
     Return_Vid_Mode_To_Text;
end;

{------------------------------------------------------------------------}

procedure scroll_slow_lines;

var counter,
    YLoops : integer;

begin
    Set_Vid_mode_to_320x200;
     for counter := 1 to 25 do BEGIN
       for YLoops := 1 to 200 do BEGIN
        FloatDrawLine ( 0, YLoops, 319, YLoops, YLoops+counter);
       END;
     END;
   Return_Vid_Mode_To_Text;
end;


{------------------------------------------------------------------------}

procedure draw_random_fast_lines;

var counter : integer;

begin

    Set_Vid_mode_to_320x200;

    Randomize;
       for counter := 1 to 5000 do BEGIN
           BresDrawLine (random(319), random(199), random(319), random(199), random(256));
       END;
   Return_Vid_Mode_To_Text;
end;

{------------------------------------------------------------------------}

procedure scroll_fast_lines;

var counter,
    YLoops : integer;

begin
    Set_Vid_mode_to_320x200;
     for counter := 1 to 25 do BEGIN
      for YLoops := 1 to 200 do BEGIN
       BresDrawLine ( 0, YLoops, 319, YLoops, YLoops+counter);
      END;
     END;
    Return_Vid_Mode_To_Text;
end;

{------------------------------------------------------------------------}

procedure Intro;

begin

    ClrScr;

    WriteLn('Hi there & welcome to the second installment of my VGA tutorial.');
    WriteLn;
    WriteLn('This program concerns its self with lines and looks at two functions');
    WriteLn('for drawing them....');
    WriteLn;
    WriteLn('1.  This routine uses the PutPixel function that we developed in part I');
    WriteLn('    As you will see, its pretty fast, but lets get faster.....');
    WriteLn;
    WriteLn('2.  Ta da!  By restricting this function to integer math and making no');
    WriteLn('    function calls we have increased the speed tremendously.');
    WriteLn;
    WriteLn('Each function is put through the following tests : ');
    WriteLn;
    WriteLn('   5000 lines of random length, colour & orientation are drawn. ');
    WriteLn('   25 screens of 200 lines are drawn to create a scrolling effect. ');

    ReadKey;

end;

{------------------------------------------------------------------------}

procedure Outro;

begin

    WriteLn('Well...  there you have it.  A nice fast DrawLine routine.');
    WriteLn;
    WriteLn('I hope youve enjoyed this tutorial and that youll find it useful.');
    WriteLn;
    WriteLn('Many thanks to Richard Griffiths whos been porting this code to Pascal');
    WriteLn('for me.As yet, this tutorial is still not available by FTP but Im working');
    WriteLn('on it.Bye for now......  ');
    WriteLn;
    WriteLn('Barny Mercer      : barny.mercer@zetnet.co.uk ');
    WriteLn('                  : http://www.zetnet.co.uk/users/bmercer/ ');
    WriteLn;
    WriteLn('Richard Griffiths : richard.griffiths@zetnet.co.uk ');
    WriteLn('                  : http://www.zetnet.co.uk/users/rgriff/');

    ReadKey;

end;

{------------------------------------------------------------------------}

begin {the main program}
    Randomize;
    Intro;
    ReadKey;

    Draw_random_slow_lines;

    ReadKey;
    Scroll_slow_lines;

    ReadKey;
    draw_random_fast_lines;

    ReadKey;
    scroll_fast_lines;

    ReadKey;

    Outro;
end.
