#ifndef EXTKEYSH
#define EXTKEYSH

/*
Keyboard events in Xview-PC
By Antonio Carlos Moreirao de Queiroz - acmq@coe.ufrj.br
Version 1.0 - 13/03/94

This file can be included in files that use these events.
The event code for extended keys is 2000+<2nd code>.
*/

enum {KNUL=2003,KSHIFTTAB=2015};
enum {KALTQ=2016,KALTW,KALTE,KALTR,KALTT,KALTY,KALTU,KALTI,KALTO,KALTP};
enum {KALTA=2030,KALTS,KALTD,KALTF,KALTG,KALTH,KALTJ,KALTK,KALTL};
enum {KALTZ=2044,KALTX,KALTC,KALTV,KALTB,KALTN,KALTM};
enum {KF1=2059,KF2,KF3,KF4,KF5,KF6,KF7,KF8,KF9,KF10};
enum {KHOME=2071,KUPARROW,KPGUP,KLEFTARROW=2075,KRIGHTARROW=2077};
enum {KEND=2079,KDOWNARROW,KPGDN,KINS,KDEL};
enum {KSHIFTF1=2084,KSHIFTF2,KSHIFTF3,KSHIFTF4,KSHIFTF5,
      KSHIFTF6,KSHIFTF7,KSHIFTF8,KSHIFTF9,KSHIFTF10};
enum {KCTRLF1=2094,KCTRLF2,KCTRLF3,KCTRLF4,KCTRLF5,
      KCTRLF6,KCTRLF7,KCTRLF8,KCTRLF9,KCTRLF10};
enum {KALTF1=2104,KALTF2,KALTF3,KALTF4,KALTF5,KALTF6,KALTF7,KALTF8,KALTF9,KALTF10,
      KCTRLPRTSC,KCTRLLEFTARROW,KCTRLRIGHTARROW,KCTRLEND,KCTRLPGDN,KCTRLHOME,
      KALT1,KALT2,KALT3,KALT4,KALT5,KALT6,KALT7,KALT8,KALT9,KALT0,
      KALTMINUS,KALTEQUAL,KCTRLPGUP,KF11,KF12,
      KSHIFTF11,KSHIFTF12,KCTRLF11,KCTRLF12,KALTF11,KALTF12};
enum {KCTRLA=1,KCTRLB,KCTRLC,KCTRLD,KCTRLE,KCTRLF,KCTRLG,KCTRLH,KCTRLI,KCTRLJ,
      KCTRLK,KCTRLL,KCTRLM,KCTRLN,KCTRLO,KCTRLP,KCTRLQ,KCTRLR,KCTRLS,KCTRLT,
      KCTRLU,KCTRLV,KCTRLW,KCTRLX,KCTRLY,KCTRLZ,KESC};
enum {KBS=8,KTAB,KCR=13};

#ifdef READ_KBD

/*
Function for reading directly the keyboard 
Define the value "READ_KBD" to include 
Use not recommended: Contrary to the philosophy of the interface
*/

#include <conio.h>

int get_kbd_event(void)
{
  int r;

  r=getch();
  if (r==0) return(2000+getch());
  else return(r);
}

#endif

#endif
