PROGRAM Tile;
{
XView-PC demonstration: Non-usual window manipulation example
By Antonio Carlos Moreirao de Queiroz - acmq@coe.ufrj.br
}

USES Crt,Graph,Xview;

CONST max=49;

VAR
  window,but:ARRAY[1..max] OF Xv_opaque;
  control,Number,bok,bQuit: Xv_opaque;
  i:INTEGER;

{$F+}

PROCEDURE InitTile(obj:Xv_opaque);
BEGIN
  open_window(control)
END;

PROCEDURE DoTile(obj:Xv_opaque);
VAR
  n,kx,ky,nx,ny:INTEGER;
BEGIN
  close_window(control);
  n:=1;
  WHILE active_w^.under<>active_w DO BEGIN
    Inc(n);
    close_window(active_w)
  END;
  close_window(active_w);
  xv_end:=FALSE;
  nx:=Round(Sqrt(n)+0.4999);
  WHILE (1.0*(n div nx) <> 1.0*n/nx) DO Inc(nx);
  ny:=n div nx;
  kx:=(GetMaxX+1) div nx;
  ky:=(GetMaxY+1) div ny;
  FOR i:=1 TO n DO BEGIN
    window[i]^.dx:=kx-1;
    window[i]^.dy:=ky-1;
    window[i]^.y:=((i-1) div nx)*ky;
    window[i]^.x:=((i-1) mod nx)*kx;
    open_window(window[i])
  END
END;

PROCEDURE LimitNumber(obj:Xv_opaque);
BEGIN
  WHILE active_w^.under<>active_w DO close_window(active_w);
  close_window(active_w);
  xv_end:=FALSE;
  FOR i:=1 TO Number^.panel_int DO open_window(window[i])
END;

PROCEDURE Quit(obj:Xv_opaque);
BEGIN
  xv_end:=TRUE
END;

{$F-}

BEGIN
  xv_init(0,0);
  FOR i:=1 TO max DO BEGIN
    window[i]:=xv_create(frame);
    WITH window[i]^ DO BEGIN
      x:=Random(GetMaxX-200);
      y:=Random(GetMaxX-200);
      dx:=200;
      dy:=200;
      dxmin:=27;
      dymin:=27;
      Str(i,window[i]^.xv_label)
    END;
    but[i]:=xv_create(button);
    WITH but[i]^ DO BEGIN
      xv_label:=' ';
      notify_handler:=InitTile
    END
  END;
  control:=xv_create(frame);
  WITH control^ DO BEGIN
    xv_label:='Control';
    dx:=150; dymin:=70; dy:=70;
  END;
  Number:=xv_create(textfield);
  WITH Number^ DO BEGIN
    field_type:=int_field;
    min_value:=1;
    max_value:=max;
    panel_int:=9;
    value_length:=5;
    xv_label:='Windows';
    notify_handler:=LimitNumber;
  END;
  bok:=xv_create(button);
  WITH bok^ DO BEGIN
    xv_label:='"Tile"';
    y:=15;
    notify_handler:=DoTile;
    owner^.mouse_obj:=bok;
  END;
  bQuit:=xv_create(button);
  WITH bQuit^ DO BEGIN
    xv_label:='Quit';
    y:=30;
    notify_handler:=Quit
  END;
  FOR i:=1 TO 5 DO open_window(window[i]);
  xv_main_loop(window[6]);
  TextMode(80);
END.
