Unit LZH;

{$Q-,A+,B-,E-,F-,I+,N-,O-,R-,S-,V-}

Interface

Type
	IOFunc			= Function(Var C : Byte) : Boolean;
	IOFuncPtr		= Pointer;

Const
	Header			: Array[1..5] Of Byte = ($4C,$5A,$57,$01,$00);

Function Pack(
	Get			: IOFuncPtr;	GetLocal	: Boolean;
	Put			: IOFuncPtr;	PutLocal	: Boolean) : LongInt;

Function UnPack(
	DataSize	: LongInt;
	Get			: IOFuncPtr;	GetLocal	: Boolean;
	Put			: IOFuncPtr;	PutLocal	: Boolean) : LongInt;

Function IsPacked(
	Get			: IOFuncPtr;	GetLocal	: Boolean) : Boolean;

Function PackS(S : String) : String;
Function UnPackS(S : String) : String;

Function PackF(SourceName,DestName : String; CacheSize : Word) : Boolean;
Function UnPackF(SourceName,DestName : String; CacheSize : Word) : Boolean;

Implementation

Const
	BufSize			= 4096;
	LookAheadSize	= 60;
	Threshold		= 2;
	NUL				= BufSize;

	N_Char			= 256-Threshold+LookAheadSize;

	TabSize			= N_Char*2-1;
	RootPos			= TabSize-1;

	MAX_FREQ		= $8000;

	P_LEN	: Array[0..63] Of Byte =
		($03,$04,$04,$04,$05,$05,$05,$05,$05,$05,$05,$05,$06,$06,$06,$06,
		 $06,$06,$06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$07,
		 $07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,
		 $08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08);

	P_CODE	: Array[0..63] Of Byte =
		($00,$20,$30,$40,$50,$58,$60,$68,$70,$78,$80,$88,$90,$94,$98,$9C,
		 $A0,$A4,$A8,$AC,$B0,$B4,$B8,$BC,$C0,$C2,$C4,$C6,$C8,$CA,$CC,$CE,
		 $D0,$D2,$D4,$D6,$D8,$DA,$DC,$DE,$E0,$E2,$E4,$E6,$E8,$EA,$EC,$EE,
		 $F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF);

	D_CODE	: Array[0..255] Of Byte =
		($00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
		 $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
		 $01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,
		 $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,
		 $03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,
		 $04,$04,$04,$04,$04,$04,$04,$04,$05,$05,$05,$05,$05,$05,$05,$05,
		 $06,$06,$06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$07,
		 $08,$08,$08,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$09,$09,$09,
		 $0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,
		 $0C,$0C,$0C,$0C,$0D,$0D,$0D,$0D,$0E,$0E,$0E,$0E,$0F,$0F,$0F,$0F,
		 $10,$10,$10,$10,$11,$11,$11,$11,$12,$12,$12,$12,$13,$13,$13,$13,
		 $14,$14,$14,$14,$15,$15,$15,$15,$16,$16,$16,$16,$17,$17,$17,$17,
		 $18,$18,$19,$19,$1A,$1A,$1B,$1B,$1C,$1C,$1D,$1D,$1E,$1E,$1F,$1F,
		 $20,$20,$21,$21,$22,$22,$23,$23,$24,$24,$25,$25,$26,$26,$27,$27,
		 $28,$28,$29,$29,$2A,$2A,$2B,$2B,$2C,$2C,$2D,$2D,$2E,$2E,$2F,$2F,
		 $30,$31,$32,$33,$34,$35,$36,$37,$38,$39,$3A,$3B,$3C,$3D,$3E,$3F);

	D_LEN	: Array[0..255] Of Byte =
		($03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,
		 $03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,
		 $04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,
		 $04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,
		 $04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,
		 $05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,
		 $05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,
		 $05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,
		 $05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,
		 $06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,
		 $06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,
		 $06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,
		 $07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,
		 $07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,
		 $07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,
		 $08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08);

	GetBuf	: Word	= 0;
	GetLen	: Byte	= 0;
	PutBuf	: Word	= 0;
	PutLen	: Word	= 0;
	TextSize	: LongInt	= 0;
	CodeSize	: LongInt	= 0;
	MatchPos	: Integer	= 0;
	MatchLen	: Integer	= 0;

Type
	TFreq		= Array[0..TabSize] Of Word;
	PFreq		= ^TFreq;
	TParent		= Array[0..pred(TabSize+N_Char)] Of Integer;
	PParent		= ^TParent;
	TSon		= Array[0..pred(TabSize)] Of Integer;
	PSon		= ^TSon;
	TTextBuf	= Array[0..BufSize+LookAheadSize-2] Of Byte;
	PTextBuf	= ^TTextBuf;
	AWord		= Array[0..BufSize] Of Integer;
	PAWord		= ^AWord;
	BWord		= Array[0..BufSize+256] Of Integer;
	PBWord		= ^BWord;

Var
	TextBuf		: PTextBuf;
	LeftSon		: PAWord;
	Dad			: PAWord;
	RightSon	: PBWord;
	Freq		: PFreq;

	Parent		: PParent;
	Son			: PSon;

Procedure InitTree;
Var
	I	: Integer;
Begin
	For I:=BufSize+1 To BufSize+256 Do
		RightSon^[I]:=NUL;
	For I:=0 To BufSize Do
		Dad^[I]:=NUL;
End;

Procedure InsertNode(RootPos : Integer);
Var
	Tmp,I,P,Cmp	: Integer;
	Key			: PTextBuf;
	C			: Word;
Begin
	Cmp:=1;
	Key:=@TextBuf^[RootPos];
	P:=Succ(BufSize)+Key^[0];
	RightSon^[RootPos]:=NUL;
	LeftSon^[RootPos]:=NUL;
	MatchLen:=0;
	While MatchLen<LookAheadSize Do Begin
		If (Cmp>=0) Then Begin
			If RightSon^[P]<>NUL Then
				P:=RightSon^[P]
			Else Begin
				RightSon^[P]:=RootPos;
				Dad^[RootPos]:=P;
				Exit;
			End;
		End Else Begin
			If LeftSon^[P]<>NUL Then
				P:=LeftSon^[P]
			Else Begin
				LeftSon^[P]:=RootPos;
				Dad^[RootPos]:=P;
				Exit;
			End;
		End;
		I:=0;
		Cmp:=0;
		While (I<LookAheadSize) And (Cmp=0) Do Begin
			Inc(I);
			Cmp:=Key^[I]-TextBuf^[P+I];
		End;
		If I>Threshold Then Begin
			Tmp:=Pred((RootPos-P) And Pred(BufSize));
			If I>MatchLen Then Begin
				MatchPos:=Tmp;
				MatchLen:=I;
			End;
			If (MatchLen<LookAheadSize) And (I=MatchLen) Then Begin
				C:=Tmp;
				If C<MatchPos Then
					MatchPos:=C;
			End;
		End;
	End;
	Dad^[RootPos]:=Dad^[P];
	LeftSon^[RootPos]:=LeftSon^[P];
	RightSon^[RootPos]:=RightSon^[P];
	Dad^[LeftSon^[P]]:=RootPos;
	Dad^[RightSon^[P]]:=RootPos;
	If RightSon^[Dad^[P]]=P Then
		RightSon^[Dad^[P]]:=RootPos
	Else
		LeftSon^[Dad^[P]]:=RootPos;
	Dad^[P]:=NUL;
End;

Procedure DeleteNode(P : Integer);
Var
	Q	: Integer;
Begin
	If Dad^[P]=NUL Then
		Exit;
	If RightSon^[P]=NUL Then
		Q:=LeftSon^[P]
	Else If LeftSon^[P]=NUL Then
		Q:=RightSon^[P]
	ELse Begin
		Q:=LeftSon^[P];
		If RightSon^[Q]<>NUL Then Begin
			Repeat
				Q:=RightSon^[Q];
			Until RightSon^[Q]=NUL;
			RightSon^[Dad^[Q]]:=LeftSon^[Q];
			Dad^[LeftSon^[Q]]:=Dad^[Q];
			LeftSon^[Q]:=LeftSon^[P];
			Dad^[LeftSon^[P]]:=Q;
		End;
		RightSon^[Q]:=RightSon^[P];
		Dad^[RightSon^[P]]:=Q;
	End;
	Dad^[Q]:=Dad^[P];
	If RightSon^[Dad^[P]]=P Then
		RightSon^[Dad^[P]]:=Q
	Else
		LeftSon^[Dad^[P]]:=Q;
	Dad^[P]:=NUL;

End;

Function GetBit(Get : IOFuncPtr; GetLocal : Boolean; LocalBP : Word) : Integer;
Var
	I		: Byte;
	I2		: Integer;
	Result	: Boolean;
Begin
	While GetLen<=8 Do Begin
		If GetLocal Then Asm
			LEA		DI,[I]
			PUSH	SS
			PUSH	DI
			PUSH	LocalBP
			CALL	DWORD PTR [Get]
			MOV		Result,AL
		End Else
			Result:=IOFunc(Get)(I);
		If Result Then
			I2:=I
		Else
			I2:=0;
		GetBuf:=GetBuf Or (I2 Shl (8-GetLen));
		Inc(GetLen,8);
	End;
	I2:=GetBuf;
	GetBuf:=GetBuf Shl 1;
	Dec(GetLen);
	GetBit:=Integer((I2<0));
End;

Function GetByte(Get : IOFuncPtr; GetLocal : Boolean; LocalBP : Word) : Integer;
Var
	J		: Byte;
	I		: Word;
	Result	: Boolean;
Begin
	While GetLen<=8 Do Begin
		If GetLocal Then Asm
			LEA		DI,[J]
			PUSH	SS
			PUSH	DI
			PUSH	LocalBP
			CALL	DWORD PTR [Get]
			MOV		Result,AL
		End Else
			Result:=IOFunc(Get)(J);
		If Result Then
			I:=J
		Else
			I:=0;
		GetBuf:=GetBuf Or (I Shl (8-GetLen));
		Inc(GetLen,8);
	End;
	I:=GetBuf;
	GetBuf:=GetBuf Shl 8;
	Dec(GetLen,8);
	GetByte:=Integer(I Shr 8);
End;

Procedure PutCode(L : Integer; C : Word; Put : IOFuncPtr; PutLocal : Boolean; LocalBP : Word);
Var
	Temp	: Byte;
Begin
	PutBuf:=PutBuf Or (C Shr PutLen);
	Inc(PutLen,L);
	If PutLen>=8 Then Begin
		Temp:=PutBuf Shr 8;
		If PutLocal Then Asm
			LEA		DI,[Temp]
			PUSH	SS
			PUSH	DI
			PUSH	LocalBP
			CALL	DWORD PTR [Put]
		End Else
			IOFunc(Put)(Temp);
		Dec(PutLen,8);
		If PutLen>=8 Then Begin
			Temp:=Lo(PutBuf);
			If PutLocal Then Asm
				LEA		DI,[Temp]
				PUSH	SS
				PUSH	DI
				PUSH	LocalBP
				CALL	DWORD PTR [Put]
			End Else
				IOFunc(Put)(Temp);
			Inc(CodeSize,2);
			Dec(PutLen,8);
			PutBuf:=C Shl (L-PutLen);
		End Else Begin
			PutBuf:=PutBuf Shl 8;
			Inc(CodeSize);
		End;
	End;
End;

Procedure StartHuff;
Var
	I,J	: Integer;
Begin
	For I:=0 To Pred(N_Char) Do Begin
		Freq^[I]:=1;
		Son^[I]:=I+TabSize;
		Parent^[I+TabSize]:=I;
	End;
	I:=0;
	J:=N_Char;
	While J<=RootPos Do Begin
		Freq^[J]:=Freq^[I]+Freq^[I+1];
		Son^[J]:=I;
		Parent^[I]:=J;
		Parent^[I+1]:=J;
		Inc(I,2);
		Inc(J);
	End;
	Freq^[TabSize]:=$FFFF;
	Parent^[RootPos]:=0;
End;

Procedure ReConst;
Var
	I,J,K,Tmp	: Integer;
	F,L			: Word;
Begin
	J:=0;
	For I:=0 To Pred(TabSize) Do Begin
		If Son^[I]>=TabSize Then Begin
			Freq^[J]:=Succ(Freq^[I]) Div 2;
			Son^[J]:=Son^[I];
			Inc(J);
		End;
	End;
	I:=0;
	J:=N_Char;
	While J<TabSize Do Begin
		K:=Succ(I);
		F:=Freq^[I]+Freq^[K];
		Freq^[J]:=F;
		K:=Pred(J);
		While F<Freq^[K] Do
			Dec(K);
		Inc(K);
		L:=(J-K) Shl 1;
		Tmp:=Succ(K);
		Move(Freq^[K],Freq^[Tmp],L);
		Freq^[K]:=F;
		Move(Son^[K],Son^[Tmp],L);
		Son^[K]:=I;
		Inc(I,2);
		Inc(J);
	End;
	For I:=0 To Pred(TabSize) Do Begin
		K:=Son^[I];
		If K>=TabSize Then
			Parent^[K]:=I
		Else Begin
			Parent^[K]:=I;
			Parent^[Succ(K)]:=I;
		End;
	End;
End;

Procedure UpDate(C : Integer);
Var
	I,J,K,L	: Integer;
Begin
	If Freq^[RootPos]=MAX_FREQ Then
		ReConst;
	C:=Parent^[C+TabSize];
	Repeat
		Inc(Freq^[C]);
		K:=Freq^[C];
		L:=Succ(C);
		If K>Freq^[L] Then Begin
			While K>Freq^[L] Do
				Inc(L);
			Dec(L);
			Freq^[C]:=Freq^[L];
			Freq^[L]:=K;
			I:=Son^[C];
			Parent^[I]:=L;
			If I<TabSize Then
				Parent^[Succ(I)]:=L;
			J:=Son^[L];
			Son^[L]:=I;
			Parent^[J]:=C;
			If J<TabSize Then
				Parent^[Succ(J)]:=C;
			Son^[C]:=J;
			C:=L;
		End;
		C:=Parent^[C];
	Until C=0;
End;

Var
	Code,Len	: Word;

Procedure EnCodeChar(C : Word; Put : IOFuncPtr; PutLocal : Boolean; LocalBP : Word);
Var
	I	: Word;
	J,K	: Integer;
Begin
	I:=0;
	J:=0;
	K:=Parent^[C+TabSize];
	Repeat
		I:=I Shr 1;
		If Boolean(K And 1) Then
			Inc(I,$8000);
		Inc(J);
		K:=Parent^[K];
	Until K=RootPos;
	PutCode(J,I,Put,PutLocal,LocalBP);
	Code:=I;
	Len:=J;
	UpDate(C);
End;


Procedure EnCodePosition(C : Word; Put : IOFuncPtr; PutLocal : Boolean; LocalBP : Word);
Var
	I,J	: Word;
Begin
	I:=C Shr 6;
	J:=P_CODE[I];
	PutCode(P_LEN[I],J Shl 8,Put,PutLocal,LocalBP);
	PutCode(6,(C And $3F) Shl 10,Put,PutLocal,LocalBP);
End;

Procedure EnCodeEnd(Put : IOFuncPtr; PutLocal : Boolean; LocalBP : Word);
Var
	Temp	: Byte;
Begin
	If Boolean(PutLen) Then Begin
		EnCodeChar(TabSize+1,Put,PutLocal,LocalBP);
		Temp:=Lo(PutBuf Shr 8);
		If PutLocal Then Asm
			LEA		DI,[Temp]
			PUSH	SS
			PUSH	DI
			PUSH	LocalBP
			CALL	DWORD PTR [Put]
		End Else
			IOFunc(Put)(Temp);
		Inc(CodeSize);
	End;
End;

Function DeCodeChar(Get : IOFuncPtr; GetLocal : Boolean; LocalBP : Word) : Integer;
Var
	C	: Word;
Begin
	C:=Son^[RootPos];
	While C<TabSize Do Begin
		C:=C+GetBit(Get,GetLocal,LocalBP);
		C:=Son^[C];
	End;
	C:=C-TabSize;
	UpDate(C);
	DeCodeChar:=Integer(C);
End;

Function DeCodePosition(Get : IOFuncPtr; GetLocal : Boolean; LocalBP : Word) : Word;
Var
	I,J,C	: Word;
Begin
	I:=GetByte(Get,GetLocal,LocalBP);
	C:=Word(D_CODE[I] Shl 6);
	J:=D_LEN[I];
	Dec(J,2);
	While J<>0 Do Begin
		I:=(I Shl 1)+GetBit(Get,GetLocal,LocalBP);
		Dec(J);
	End;
	DeCodePosition:=C Or (I And $3F);
End;

Procedure InitLZH;
Begin
	GetBuf:=0;
	GetLen:=0;
	PutLen:=0;
	PutBuf:=0;
	TextSize:=0;
	CodeSize:=0;
	MatchPos:=0;
	MatchLen:=0;
	New(LeftSon);
	New(Dad);
	New(RightSon);
	New(TextBuf);
	New(Freq);
	New(Parent);
	New(Son);
End;

Procedure EndLZH;
Begin
	Dispose(Son);
	Dispose(Parent);
	Dispose(Freq);
	Dispose(TextBuf);
	Dispose(RightSon);
	Dispose(Dad);
	Dispose(LeftSon);
End;

Function Pack(Get : IOFuncPtr; GetLocal : Boolean;
	Put : IOFuncPtr; PutLocal : Boolean) : LongInt;
Var
	Ct						: Byte;
	I,Len,R,S,LastMatchLen	: Integer;
	Count					: LongInt;
	LocalBP					: Word;
	Result					: Boolean;
Begin
	Asm
		MOV		AX,WORD PTR [BP]
		MOV		LocalBP,AX
	End;
	Pack:=0;
	For I:=1 To SizeOf(Header) Do Begin
		Ct:=Header[I];
		If GetLocal Then Asm
			LEA		DI,[Ct]
			PUSH	SS
			PUSH	DI
			PUSH	LocalBP
			CALL	DWORD PTR [Put]
			MOV		Result,AL
		End Else
			Result:=IOFunc(Put)(Ct);
		If Not Result Then
			Exit;
	End;
	InitLZH;
	TextSize:=0;
	StartHuff;
	InitTree;
	S:=0;
	R:=BufSize-LookAheadSize;
	FillChar(TextBuf^[0],R,#32);
	Len:=0;
	Count:=0;
	While (Len<LookAheadSize) Do Begin

		If GetLocal Then Asm
			LEA		DI,[Ct]
			PUSH	SS
			PUSH	DI
			PUSH	LocalBP
			CALL	DWORD PTR [Get]
			MOV		Result,AL
		End Else
			Result:=IOFunc(Get)(Ct);
		If Result Then Begin
			Inc(Count);
			TextBuf^[R+Len]:=Ct;
			Inc(Len);
		End Else
			Break;
	End;
	TextSize:=Len;
	For I:=1 To LookAheadSize Do
		InsertNode(R-I);
	InsertNode(R);
	Repeat
		If MatchLen>Len Then
			MatchLen:=Len;
		If MatchLen<=Threshold Then Begin
			MatchLen:=1;
			EnCodeChar(TextBuf^[R],Put,PutLocal,LocalBP);
		End Else Begin
			EnCodeChar(255-Threshold+MatchLen,Put,PutLocal,LocalBP);
			EnCodePosition(MatchPos,Put,PutLocal,LocalBP);
		End;
		LastMatchLen:=MatchLen;
		I:=0;
		While I<LastMatchLen Do Begin
			If GetLocal Then Asm
				LEA		DI,[Ct]
				PUSH	SS
				PUSH	DI
				PUSH	LocalBP
				CALL	DWORD PTR [Get]
				MOV		Result,AL
			End Else
				Result:=IOFunc(Get)(Ct);
			If Result Then Begin
				Inc(Count);
				DeleteNode(S);
				TextBuf^[S]:=Ct;
				If S<Pred(LookAheadSize) Then
					TextBuf^[S+BufSize]:=Ct;
				S:=Succ(S) And Pred(BufSize);
				R:=Succ(R) And Pred(BufSize);
				InsertNode(R);
				Inc(I);
			End Else
				Break;
		End;
		Inc(TextSize,I);
		While I<LastMatchLen Do Begin
			Inc(I);
			DeleteNode(S);
			S:=Succ(S) And Pred(BufSize);
			R:=Succ(R) And Pred(BufSize);
			Dec(Len);
			If Boolean(Len) Then
				InsertNode(R);
		End;
	Until Len<=0;
	EnCodeEnd(Put,PutLocal,LocalBP);
	EndLZH;
	Pack:=Count;
End;

Function UnPack(DataSize : LongInt; Get : IOFuncPtr; GetLocal : Boolean;
	Put : IOFuncPtr; PutLocal : Boolean) : LongInt;
Var
	C,I,J,K,R	: Integer;
	C2,A		: Byte;
	Count		: LongInt;
	Result		: Boolean;
	LocalBP		: Word;
Begin
	Asm
		MOV		AX,WORD PTR [BP]
		MOV		LocalBP,AX
	End;
	UnPack:=0;
	For I:=1 To SizeOf(Header) Do Begin
		If GetLocal Then Asm
			LEA		DI,[C2]
			PUSH	SS
			PUSH	DI
			PUSH	LocalBP
			CALL	DWORD PTR [Get]
			MOV		Result,AL
		End Else
			Result:=IOFunc(Get)(C2);
		If Not Result Then
			Exit;
		If C2<>Header[I] Then
			Exit;
	End;
	InitLZH;
	StartHuff;
	R:=BufSize-LookAheadSize;
	FillChar(TextBuf^[0],R,#32);
	Count:=0;
	While Count<DataSize Do Begin
		C:=DeCodeChar(Get,GetLocal,LocalBP);
		If C<256 Then Begin
			C2:=Lo(C);
			If PutLocal Then Asm
				LEA		DI,[C2]
				PUSH	SS
				PUSH	DI
				PUSH	LocalBP
				CALL	DWORD PTR [Put]
			End Else
				IOFunc(Put)(C2);
			TextBuf^[R]:=C;
			Inc(R);
			R:=R And Pred(BufSize);
			Inc(Count);
		End Else Begin
			I:=(R-Succ(DeCodePosition(Get,GetLocal,LocalBP))) And Pred(BufSize);
			J:=C-255+Threshold;
			For K:=0 To Pred(J) Do Begin
				C:=TextBuf^[(I+K) And Pred(BufSize)];
				C2:=Lo(C);
				If PutLocal Then Asm
					LEA		DI,[C2]
					PUSH	SS
					PUSH	DI
					PUSH	LocalBP
					CALL	DWORD PTR [Put]
				End Else
					IOFunc(Put)(C2);
				TextBuf^[R]:=C;
				Inc(R);
				R:=R And Pred(BufSize);
				Inc(Count);
			End;
		End;
	End;
	EndLZH;
	UnPack:=Count;
End;

Function IsPacked(Get : IOFuncPtr; GetLocal : Boolean) : Boolean;
Var
	I,B		: Byte;
	LocalBP	: Word;
	Result	: Boolean;
Begin
	Asm
		MOV		AX,WORD PTR [BP]
		MOV		LocalBP,AX
	End;
	IsPacked:=FALSE;
	For I:=1 To SizeOf(Header) Do Begin
		If GetLocal Then Asm
			LEA		DI,[B]
			PUSH	SS
			PUSH	DI
			PUSH	LocalBP
			CALL	DWORD PTR [Get]
			MOV		Result,AL
		End Else
			Result:=IOFunc(Get)(B);
		If Not Result Then
			Exit;
		If B<>Header[I] Then
			Exit;
	End;
	IsPacked:=TRUE;
End;

Var
	S1,S2	: ^String;
{$F+}
Function GetS(Var C : Byte) : Boolean;
Begin
	If S1^<>'' Then Begin
		C:=Ord(S1^[1]);
		Delete(S1^,1,1);
		GetS:=TRUE;
	End Else
		GetS:=FALSE;
End;

Function PutS(Var C : Byte) : Boolean;
Begin
	If Length(S2^)<255 Then Begin
		S2^:=S2^+Chr(C);
		PutS:=TRUE;
	End Else
		PutS:=FALSE;
End;
{$F-}

Function PackS(S : String) : String;
Begin
	New(S1);
	New(S2);
	S1^:=S;
	S2^:='';
	Pack(@GetS,FALSE,@PutS,FALSE);
	Insert(Chr(Length(S2^)),S2^,1);
	PackS:=S2^;
	Dispose(S2);
	Dispose(S1);
End;

Function UnPackS(S : String) : String;
Var
	L	: Byte;
Begin
	New(S1);
	New(S2);
	S1^:=S;
	S2^:='';
	L:=Ord(S[1]);
	Delete(S,1,1);
	UnPack(L,@GetS,FALSE,@PutS,FALSE);
	UnPackS:=S2^;
	Dispose(S2);
	Dispose(S1);
End;

Var
	F1,F2				: File;
	CSize				: Word;
	InCache,OutCache	: PChar;
	InHead,OutHead		: PChar;
	InTail,OutTail		: PChar;

{$F+}
Function GetF(Var C : Byte) : Boolean;
Var
	InSize	: Word;
Begin
	If InHead=InTail Then Begin
		BlockRead(F1,InCache^,CSize,InSize);
		If InSize=0 Then Begin
			GetF:=FALSE;
			Exit;
		End;
		InHead:=InCache;
		InTail:=InCache+InSize;
	End;
	C:=Ord(InHead^);
	Inc(InHead);
	GetF:=TRUE;
End;

Function Flush : Boolean;
Var
	OutSize	: Word;
Begin
	If OutTail>OutCache Then Begin
		BlockWrite(F2,OutCache^,OutHead-OutCache,OutSize);
		If OutSize<(OutHead-OutCache) Then
			Flush:=FALSE
		Else Begin
			OutHead:=OutCache;
			Flush:=TRUE;
		End;
	End Else
		Flush:=TRUE;
End;

Function PutF(Var C : Byte) : Boolean;
Begin
	OutHead^:=Chr(C);
	Inc(OutHead);
	If OutHead=OutTail Then
		PutF:=Flush
	Else
		PutF:=TRUE;
End;
{$F-}

Function PackF(SourceName,DestName : String; CacheSize : Word) : Boolean;
Var
	RealSize,OutSize	: LongInt;
	UnPackedSize		: LongInt;
Begin
	PackF:=FALSE;
	CSize:=CacheSize;
	GetMem(InCache,CacheSize);
	If InCache=NIL Then
		Exit;
	GetMem(OutCache,CacheSize);
	If OutCache=NIL Then Begin
		FreeMem(InCache,CacheSize);
		Exit;
	End;
	Assign(F1,SourceName);
	{$I-}
	ReSet(F1,1);
	{$I+}
	If IOResult<>0 Then Begin
		FreeMem(InCache,CacheSize);
		FreeMem(OutCache,CacheSize);
		Exit;
	End;
	Assign(F2,DestName);
	{$I-}
	ReWrite(F2,1);
	{$I+}
	If IOResult<>0 Then Begin
		Close(F1);
		FreeMem(InCache,CacheSize);
		FreeMem(OutCache,CacheSize);
		Exit;
	End;
	InHead:=InCache;		InTail:=InCache;
	OutHead:=OutCache;		OutTail:=OutCache+CacheSize;
	OutSize:=Pack(@GetF,FALSE,@PutF,FALSE);
	If Not Flush Then Begin
		Seek(F2,0);
		Truncate(F2);
	End;
	UnPackedSize:=FileSize(F1);
	BlockWrite(F2,UnPackedSize,4);
	FreeMem(InCache,CacheSize);
	FreeMem(OutCache,CacheSize);
	Close(F1);
	RealSize:=FileSize(F2);
	Close(F2);
	If OutSize<>RealSize-4 Then
		Erase(F2)
	Else
		PackF:=TRUE;
End;

Function UnPackF(SourceName,DestName : String; CacheSize : Word) : Boolean;
Var
	RealSize,OutSize	: LongInt;
	UnPackedSize		: LongInt;
Begin
	UnPackF:=FALSE;
	CSize:=CacheSize;
	GetMem(InCache,CacheSize);
	If InCache=NIL Then
		Exit;
	GetMem(OutCache,CacheSize);
	If OutCache=NIL Then Begin
		FreeMem(InCache,CacheSize);
		Exit;
	End;
	Assign(F1,SourceName);
	{$I-}
	ReSet(F1,1);
	{$I+}
	If IOResult<>0 Then Begin
		FreeMem(InCache,CacheSize);
		FreeMem(OutCache,CacheSize);
		Exit;
	End;
	Assign(F2,DestName);
	{$I-}
	ReWrite(F2,1);
	{$I+}
	If IOResult<>0 Then Begin
		Close(F1);
		FreeMem(InCache,CacheSize);
		FreeMem(OutCache,CacheSize);
		Exit;
	End;
	InHead:=InCache;		InTail:=InCache;
	OutHead:=OutCache;		OutTail:=OutCache+CacheSize;
	Seek(F1,FileSize(F1)-4);
	BlockRead(F1,UnPackedSize,4);
	Seek(F1,0);
	OutSize:=UnPack(UnPackedSize,@GetF,FALSE,@PutF,FALSE);
	If Not Flush Then Begin
		Seek(F2,0);
		Truncate(F2);
	End;
	FreeMem(InCache,CacheSize);
	FreeMem(OutCache,CacheSize);
	Close(F1);
	RealSize:=FileSize(F2);
	Close(F2);
	If OutSize<>RealSize Then
		Erase(F2)
	Else
		UnPackF:=TRUE;
End;

End.
