/* ast_gen.c: write PoV-format data file of many spheres/asteriods */
/* JPB  11/29/93  */

#include <stdio.h>
#include <math.h>       /* sqrt() */
#include <stdlib.h>     /* for rand() function */
#include <string.h>     /* strcpy() */

void seed_ran1(int seed);
float ran1();              /* returns random # between 0.0 and 1.0 */

double dist();             /* distance between two points */
float value(float n1, float n2, float hue);  /* intermed value for hls conv. */

int main(int argc, char **argv)
{
  double x, y, z, r1, rad;
  double xmin,xmax,zmin,zmax,rmax;
  double dexp;                          /* exponent of distribution */
  double ex,ey,ez;  /* eye location */
  double dx,dy,dz;  /* deltas between current point and eye location */
  double dist;      /* distance between current point and eye */
  double rs;   /* relative apparent size of object from viewpoint */
  double rx,ry,rz;  /* rotation angles  */
  double uplim;     /* upper limit on distribution. 100: 2-ord-of-magnitude */
  double farlim;    /* far-away limit of asteroid field */
  double yinc;      /* y-coordinate increment for each new asteroid */
  double minvis;    /* minimum apparent radius we consider visible */
  int i,lim;
  int rseed;
  char *buf;  /* misc. string from strtod() */
  FILE *fpout;
  char fname_out[80] = "output.dat";

  rseed = 0;            /* random number seed */
  dexp = 1.0;           /* radius power law distribution exponent */
  lim = 100;            /* number of asteriods to generate */
  rmax = 0.1;           /* maximum radius of sphere */
  uplim = 200;          /* range of distribution: 1..uplim */
  farlim = 10;          /* maximum extent in the +y direction */
  minvis = 0.02;        /* drop objects w/apparent radii smaller than this */

  if (argc < 2) {
  printf("Asteroid field generator jpb 8/28/95. Usage:\n");
  printf("ast_gen <fname> <#_objs> <rseed> <d_pwr> <rmax> <uplim> <farlim>\n");
  printf("        defaults: 100    0       1.0     0.1    200      10\n");
  printf("Enter output file name:");
  scanf("%s",fname_out);
  printf("Enter number of asteriods to generate:");
  scanf("%d",&lim);
  printf("Enter random number seed:");
  scanf("%d",&rseed);
  printf("Enter distribution power (eg 1.0):");
  scanf("%lf",&dexp);
  printf("Enter rmax (eg 0.1):");
  scanf("%lf",&rmax);
  printf("Enter uplim (eg 100):");
  scanf("%lf",&uplim);
  printf("Enter farlim (eg 10):");
  scanf("%lf",&farlim);
  } else  strcpy(fname_out,argv[1]);
 
  if (argc > 2)
   lim = (int) strtod(argv[2],&buf);
  if (argc > 3)
   rseed = (int) strtod(argv[3],&buf);
  if (argc > 4)
   dexp = strtod(argv[4],&buf);
  if (argc > 5)
   rmax = strtod(argv[5],&buf);
  if (argc > 6)
   uplim = strtod(argv[6],&buf);

  seed_ran1(rseed);
  dexp = 1.2;

  fpout = fopen(fname_out,"w");

  printf("Ast_gen: now generating data...\n");

  x = 0.0;
  y = 1.0;
  yinc = (farlim - y) / (double) lim;

  xmin = -1; xmax = 3;
  zmin = -0.8; zmax = -0.1;

  ex = 1.0; ey = -0.2; ez = -.5;  /* eye location in POV file */

  for (i=0;i<lim;)   {
	xmin = -1 - (y-1)/2;
	xmax = 3 + (y-1)/2;
	x = (xmax-xmin)*ran1() + xmin;
	z = (zmax-zmin)*ran1() + zmin;
	r1 = uplim*ran1() + 1.0;
	rad = rmax * pow(10,-dexp*log10(r1));

	dx = x-ex; dy = y-ey; dz = z-ez;
	dist = sqrt(dx*dx + dy*dy + dz*dz);
	rs = 100*atan(rad/dist);           /* relative apparent size */

	if (rs > 1.0) printf("%5.4f ",rs);
	fflush(stdout);
	rx = ran1() * 360.0; ry = ran1() * 360.0; rz = ran1() * 360.0;

        if (rs > minvis) {
	  fprintf(fpout,"object{ ");
	if (rs > minvis*32)
	  fprintf(fpout,"#include \"a5.inc\"\n");
	else if (rs > minvis*16)
	  fprintf(fpout,"#include \"a4.inc\"\n");
	else if (rs > minvis*8)
	  fprintf(fpout,"#include \"a3.inc\"\n");
	else if (rs > minvis*4)
	  fprintf(fpout,"#include \"a2.inc\"\n");
/*	else if (rs > minvis*2)
	  fprintf(fpout,"#include \"a1.inc\"\n");  */
	else 
	  fprintf(fpout,"sphere { <%5.3f, %5.3f, %5.3f> , %5.4f } ",
	      x,y,z,rad);
	if (rs > minvis*4) {
	  fprintf(fpout," rotate <%4.0f,%4.0f,%4.0f>\n",rx,ry,rz);
	  fprintf(fpout," scale <%5.3f,%5.3f,%5.3f>\n",rad,rad,rad);
	  fprintf(fpout," translate <%5.3f,%5.3f,%5.3f> ",x,y,z);
 	 }
	fprintf(fpout,"}\n");
	i++; /* increment counter */
	y += yinc;
	} /* end if (rs > minvis) */
  }

  fclose( fpout );
  printf("Asteroid file written.\n");
  return(0);
}


double dist(double x1, double y1, double z1, double x2, double y2, double z2)
{
  return(sqrt( pow((x2-x1),2) + pow((y2-y1),2) + pow((z2-z1),2) )  );
}

