// --------------------------------------------------------
// Tutorial file for Dave G's Bezier Curve System
//  See DGBZ.PDF for documentation
// --------------------------------------------------------

#include "colors.inc"

camera { location <0, 0, -10> look_at <0, 0, 0> }

light_source { <20, 20, -20> color White }

#declare Curve1C0 = <-6, -6, 4>
#declare Curve1C1 = <-6,  6, 4>
#declare Curve1C2 = <-1, -6, 4>
#declare Curve1C3 = <-1,  6, 4>

#declare Curve2C0 = < 6, -6, 4>
#declare Curve2C1 = < 6,  6, 4>
#declare Curve2C2 = < 1, -6, 4>
#declare Curve2C3 = < 1,  6, 4>

sphere { Curve1C0, .3 pigment { color Green } }
sphere { Curve1C1, .2 pigment { color Blue  } }
sphere { Curve1C2, .2 pigment { color Blue  } }
sphere { Curve1C3, .3 pigment { color Green } }
cylinder { Curve1C0, Curve1C1, 0.05 pigment { color Yellow } }
cylinder { Curve1C2, Curve1C3, 0.05 pigment { color Yellow } }

sphere { Curve2C0, .3 pigment { color Green } }
sphere { Curve2C1, .2 pigment { color Blue  } }
sphere { Curve2C2, .2 pigment { color Blue  } }
sphere { Curve2C3, .3 pigment { color Green } }
cylinder { Curve2C0, Curve2C1, 0.05 pigment { color Yellow } }
cylinder { Curve2C2, Curve2C3, 0.05 pigment { color Yellow } }


#declare Looper = 20

#declare DGBZCommand = "RESET"
#include "DGBZ.INC"

#declare DGBZC0        = Curve1C0
#declare DGBZC1        = Curve1C1
#declare DGBZC2        = Curve1C2
#declare DGBZC3        = Curve1C3
#declare DGBZCommand   = "POSITION"

#declare Count = 0
#while (Count <= Looper)
	#declare DGBZAmount = Count / Looper
	#include "DGBZ.INC"
	sphere { DGBZPosition, 0.2 pigment { color Red } }
	#declare Count = Count + 1
#end

#declare DGBZC0        = Curve2C0
#declare DGBZC1        = Curve2C1
#declare DGBZC2        = Curve2C2
#declare DGBZC3        = Curve2C3
#declare DGBZCommand   = "POSITION"
#declare DGBZCalc_Type = "EXACT"

#declare Count = 0
#while (Count <= Looper)
	#declare DGBZAmount = Count / Looper
	#include "DGBZ.INC"
	sphere { DGBZPosition, 0.2 pigment { color Red } }
	#declare Count = Count + 1
#end
