// --------------------------------------------------------
// Tutorial file for Dave G's Bezier Curve System
//  See DGBZ.PDF for documentation
// --------------------------------------------------------

#include "colors.inc"

camera { location <0, 3, -10> look_at <0, 3, 0> }

light_source { <20, 20, -20> color White }


#declare DGMBZCurves = 3

#declare DGMBZ01C0 = < 0, 6, 1>
#declare DGMBZ01C1 = < 2, 6, 1>
#declare DGMBZ01C2 = < 5, 2, 1>
#declare DGMBZ01C3 = < 4, 0, 1>

#declare DGMBZ02C0 = < 4, 0, 1>
#declare DGMBZ02C1 = < 3,-2, 1>
#declare DGMBZ02C2 = <-3,-2, 1>
#declare DGMBZ02C3 = <-4, 0, 1>

#declare DGMBZ03C0 = <-4, 0,1>
#declare DGMBZ03C1 = <-5, 2, 1>
#declare DGMBZ03C2 = <-2, 6, 1>
#declare DGMBZ03C3 = < 0, 6, 1>

sphere { DGMBZ01C0, 0.2 pigment { color Green } }
sphere { DGMBZ01C1, 0.2 pigment { color Blue } }
sphere { DGMBZ01C2, 0.2 pigment { color Blue } }
sphere { DGMBZ01C3, 0.2 pigment { color Green } }
sphere { DGMBZ02C0, 0.2 pigment { color Green } }
sphere { DGMBZ02C1, 0.2 pigment { color Blue } }
sphere { DGMBZ02C2, 0.2 pigment { color Blue } }
sphere { DGMBZ02C3, 0.2 pigment { color Green } }
sphere { DGMBZ03C0, 0.2 pigment { color Green } }
sphere { DGMBZ03C1, 0.2 pigment { color Blue } }
sphere { DGMBZ03C2, 0.2 pigment { color Blue } }
sphere { DGMBZ03C3, 0.2 pigment { color Green } }

#declare Looper = 20

#declare Count = 0
#while (Count <= Looper)
	#warning "\n Working on point -"
	#warning str(Count,0,4)
	#declare DGMBZAmount = Count / Looper
	#include "DGMBZ.INC"
	sphere { DGMBZPosition, 0.1 pigment { color Red } }
	#declare Count = Count + 1
#end

