// --------------------------------------------------------
//     DGBZ.INC
//     Dave G's Bezier Curve System
//     Include file for POV-RAY 3.0
// --------------------------------------------------------
//
//     Copyright (C) 1997
//        David Govoni
//        E-mail: david.govoni@sympatico.ca
//
//           Please contact me with any:
//              comments, suggestions, changes,
//              and success stories. If you
//              create any wonderful animations or images
//              I would like to know about them.
//
//     Version
//        0.95 Beta - March 22, 1997
//
// --------------------------------------------------------
// Documentation is in:
//   DGBZ.PDF - Adobe Acrobat Format
//
// --------------------------------------------------------
// This file is freely distributable and useable as long
// as all files in this archive are kept together.
// --------------------------------------------------------
// If you make changes or additions to this file, please
// put your name, the date, and a description of the
// changes into the file. If you feel the changes should
// be added to later releases of this file, please tell me
// about your modifications.
// --------------------------------------------------------
//
//
//
//
// --------------------------------------------------------
// Declare all variable not set by the user to their defaults
#ifndef (DGBZCommand)     #declare DGBZCommand     = "RESET"       #end
#ifndef (DGBZCommand_Num) #declare DGBZCommand_Num = 1             #end
#ifndef (DGBZCalc_Type)   #declare DGBZCalc_Type   = "APPROXIMATE" #end
#ifndef (DGBZC0)          #declare DGBZC0          = <-5,0,0>      #end
#ifndef (DGBZC1)          #declare DGBZC1          = <-3,2,0>      #end
#ifndef (DGBZC2)          #declare DGBZC2          = < 3,2,0>      #end
#ifndef (DGBZC3)          #declare DGBZC3          = < 5,0,0>      #end
#ifndef (DGBZLength)      #declare DGBZLength      = 0             #end
#ifndef (DGBZSteps)       #declare DGBZSteps       = 1000          #end
#ifndef (DGBZPosition)    #declare DGBZPosition    = <0,0,0>       #end
#ifndef (DGBZAmount)      #declare DGBZAmount      = 0             #end
#ifndef (DGBZDistance)    #declare DGBZDistance    = 0             #end
#ifndef (DGBZTransition)  #declare DGBZTransition  = 0             #end
// --------------------------------------------------------


// --------------------------------------------------------
// Check for incorrect data
// --------------------------------------------------------
// 1) The Amount through the curve is not between 0-1
#declare DGBZAmount = abs(DGBZAmount)
#declare DGBZAmount = mod(DGBZAmount,1)
// --------------------------------------------------------
// Make all string variables uppercase
#declare DGBZCommand =   strupr(DGBZCommand)
#declare DGBZCalc_Type = strupr(DGBZCalc_Type)
// --------------------------------------------------------


// --------------------------------------------------------
// Since POV can't #switch on strings, convert strings
// into numeric commands
// --------------------------------------------------------
// Convert the Command string
#declare DGBZCommand_Num = 1 // RESET
#if (strcmp(DGBZCommand,"RESET")=0)     #declare DGBZCommand_Num = 1   #end
#if (strcmp(DGBZCommand,"POSITION")=0)  #declare DGBZCommand_Num = 2   #end
#if (strcmp(DGBZCommand,"LENGTH")=0)    #declare DGBZCommand_Num = 3   #end
#if (strcmp(DGBZCommand,"DISTANCE")=0)  #declare DGBZCommand_Num = 4   #end
#if (strcmp(DGBZCommand,"TRANS_001")=0) #declare DGBZCommand_Num = 100 #end
#if (strcmp(DGBZCommand,"TRANS_002")=0) #declare DGBZCommand_Num = 101 #end
#if (strcmp(DGBZCommand,"TRANS_003")=0) #declare DGBZCommand_Num = 102 #end
#if (strcmp(DGBZCommand,"TRANS_004")=0) #declare DGBZCommand_Num = 103 #end
#if (strcmp(DGBZCommand,"TRANS_005")=0) #declare DGBZCommand_Num = 104 #end
#if (strcmp(DGBZCommand,"TRANS_006")=0) #declare DGBZCommand_Num = 105 #end
#if (strcmp(DGBZCommand,"TRANS_007")=0) #declare DGBZCommand_Num = 106 #end
#if (strcmp(DGBZCommand,"TRANS_008")=0) #declare DGBZCommand_Num = 107 #end
#if (strcmp(DGBZCommand,"TRANS_009")=0) #declare DGBZCommand_Num = 108 #end
#if (strcmp(DGBZCommand,"TRANS_010")=0) #declare DGBZCommand_Num = 109 #end
#if (strcmp(DGBZCommand,"TRANS_011")=0) #declare DGBZCommand_Num = 110 #end
#if (strcmp(DGBZCommand,"TRANS_012")=0) #declare DGBZCommand_Num = 111 #end
#if (strcmp(DGBZCommand,"TRANS_013")=0) #declare DGBZCommand_Num = 112 #end
#if (strcmp(DGBZCommand,"TRANS_014")=0) #declare DGBZCommand_Num = 113 #end
#if (strcmp(DGBZCommand,"TRANS_015")=0) #declare DGBZCommand_Num = 114 #end
#if (strcmp(DGBZCommand,"TRANS_016")=0) #declare DGBZCommand_Num = 115 #end
#if (strcmp(DGBZCommand,"TRANS_017")=0) #declare DGBZCommand_Num = 116 #end
#if (strcmp(DGBZCommand,"TRANS_018")=0) #declare DGBZCommand_Num = 117 #end
#if (strcmp(DGBZCommand,"TRANS_019")=0) #declare DGBZCommand_Num = 118 #end
#if (strcmp(DGBZCommand,"TRANS_020")=0) #declare DGBZCommand_Num = 119 #end
#if (strcmp(DGBZCommand,"TRANS_021")=0) #declare DGBZCommand_Num = 120 #end
#if (strcmp(DGBZCommand,"TRANS_022")=0) #declare DGBZCommand_Num = 121 #end
#if (strcmp(DGBZCommand,"TRANS_023")=0) #declare DGBZCommand_Num = 122 #end
#if (strcmp(DGBZCommand,"TRANS_024")=0) #declare DGBZCommand_Num = 123 #end
#if (strcmp(DGBZCommand,"TRANS_025")=0) #declare DGBZCommand_Num = 124 #end
#if (strcmp(DGBZCommand,"TRANS_026")=0) #declare DGBZCommand_Num = 125 #end
#if (strcmp(DGBZCommand,"TRANS_027")=0) #declare DGBZCommand_Num = 126 #end
#if (strcmp(DGBZCommand,"TRANS_028")=0) #declare DGBZCommand_Num = 127 #end
#if (strcmp(DGBZCommand,"TRANS_029")=0) #declare DGBZCommand_Num = 128 #end
#if (strcmp(DGBZCommand,"TRANS_030")=0) #declare DGBZCommand_Num = 129 #end
#if (strcmp(DGBZCommand,"TRANS_031")=0) #declare DGBZCommand_Num = 130 #end
#if (strcmp(DGBZCommand,"TRANS_032")=0) #declare DGBZCommand_Num = 131 #end
#if (strcmp(DGBZCommand,"TRANS_033")=0) #declare DGBZCommand_Num = 132 #end
#if (strcmp(DGBZCommand,"TRANS_034")=0) #declare DGBZCommand_Num = 133 #end
// --------------------------------------------------------
// Convert the Calc_Type string
#declare DGBZCalc_Num = 1 // APPROXIMATE
#if (strcmp(DGBZCalc_Type,"EXACT")=0) #declare DGBZCalc_Num = 2 #end
// --------------------------------------------------------


// --------------------------------------------------------
// Do the actual work of the file
#if (DGBZCommand_Num = 1) // RESET
	// RESET all variables to their defaults
	#declare DGBZCalc_Type = "APPROXIMATE"
	#declare DGBZC0        = <-5,0,0>
	#declare DGBZC1        = <-3,2,0>
	#declare DGBZC2        = < 3,2,0>
	#declare DGBZC3        = < 5,0,0>
	#declare DGBZLength    = 0
	#declare DGBZSteps     = 1000
	#declare DGBZPosition  = <0,0,0>
	#declare DGBZAmount    = 0
	#declare DGBZDistance  = 0
#else
	// The Command is any of the others
	// Prepare the variables for the DGBZINT.INC file
	#declare DGBZINTC0             = DGBZC0
	#declare DGBZINTC1             = DGBZC1
	#declare DGBZINTC2             = DGBZC2
	#declare DGBZINTC3             = DGBZC3
	#declare DGBZINTDistance       = DGBZDistance
	#declare DGBZINTCurve_Position = DGBZAmount
	// Perform the different commands
	#switch (DGBZCommand_Num)
		#case (2) // POSITION
			#if (DGBZCalc_Num = 1)
				#declare  DGBZINTCommand = 4 // APPROXIMATE
			#else
				#declare  DGBZINTCommand = 2 // EXACT
			#end
			#include "DGBZINT.INC"
			#declare DGBZPosition = DGBZINTPosition
			#declare DGBZLength   = 0
		#break
		#case (3) // LENGTH
			#declare DGBZINTCommand = 1 // Find the Length of the curve
			#include "DGBZINT.INC"
			#declare DGBZLength   = DGBZINTLength
			#declare DGBZPosition = <0,0,0>
		#break
		#case (4) // DISTANCE
			#declare DGBZINTCommand = 3 // Find correct distance
			#include "DGBZINT.INC"
			#declare DGBZLength   = 0
			#declare DGBZPosition = DGBZINTPosition
		#break
		#case (100) // Transition 001
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0,0,0>
			#declare DGBZINTC2 = <1,0,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (101) // Transition 002
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0,0,0>
			#declare DGBZINTC2 = <.75,0,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (102) // Transition 003
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0,0,0>
			#declare DGBZINTC2 = <0.5,0,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (103) // Transition 004
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0,0,0>
			#declare DGBZINTC2 = <0.25,0,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (104) // Transition 005
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.25,0,0>
			#declare DGBZINTC2 = <0.25,0,0>
			#declare DGBZINTC3 = <0.25,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (105) // Transition 006
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.5,0,0>
			#declare DGBZINTC2 = <0.5,0,0>
			#declare DGBZINTC3 = <0.5,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (106) // Transition 007
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.75,0,0>
			#declare DGBZINTC2 = <0.75,0,0>
			#declare DGBZINTC3 = <0.75,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (107) // Transition 008
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <1,0,0>
			#declare DGBZINTC2 = <1,0,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (108) // Transition 009
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.25,0,0>
			#declare DGBZINTC2 = <0.25,1,0>
			#declare DGBZINTC3 = <0.25,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (109) // Transition 010
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.5,0,0>
			#declare DGBZINTC2 = <0.5,1,0>
			#declare DGBZINTC3 = <0.5,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (110) // Transition 011
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.75,0,0>
			#declare DGBZINTC2 = <0.75,1,0>
			#declare DGBZINTC3 = <0.75,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (111) // Transition 012
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <1,0,0>
			#declare DGBZINTC2 = <1,1,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (112) // Transition 013
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0,-0.25,0>
			#declare DGBZINTC2 = <1,1,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (113) // Transition 014
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.25,-0.25,0>
			#declare DGBZINTC2 = <1,1,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (114) // Transition 015
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.5,-0.25,0>
			#declare DGBZINTC2 = <1,1,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (115) // Transition 016
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.75,-0.25,0>
			#declare DGBZINTC2 = <1,1,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (116) // Transition 017
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <1,-0.25,0>
			#declare DGBZINTC2 = <1,1,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (117) // Transition 018
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <1,-0.25,0>
			#declare DGBZINTC2 = <5,1,0>
			#declare DGBZINTC3 = <5,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (118) // Transition 019
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.25,0,0>
			#declare DGBZINTC2 = <0,1,0>
			#declare DGBZINTC3 = <.25,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (119) // Transition 020
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.5,0,0>
			#declare DGBZINTC2 = <0,1,0>
			#declare DGBZINTC3 = <0.5,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (120) // Transition 021
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.75,0,0>
			#declare DGBZINTC2 = <0,1,0>
			#declare DGBZINTC3 = <0.75,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (121) // Transition 022
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <1,0,0>
			#declare DGBZINTC2 = <0,1,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (122) // Transition 023
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <5,0,0>
			#declare DGBZINTC2 = <0,1,0>
			#declare DGBZINTC3 = <5,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (123) // Transition 024
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <10,0,0>
			#declare DGBZINTC2 = <0,1,0>
			#declare DGBZINTC3 = <10,1,0>
			#declare DGBZINTC1 = <0,0,0>
			#declare DGBZINTC2 = <0,0,0>
			#declare DGBZINTC3 = <0,0,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (124) // Transition 025
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.25,0,0>
			#declare DGBZINTC2 = <0,1,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (125) // Transition 026
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.5,0,0>
			#declare DGBZINTC2 = <0,1,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (126) // Transition 027
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.75,0,0>
			#declare DGBZINTC2 = <0,1,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (127) // Transition 028
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <1,0,0>
			#declare DGBZINTC2 = <0,1,0>
			#declare DGBZINTC3 = <2,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (128) // Transition 029
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <1,0,0>
			#declare DGBZINTC2 = <0,1,0>
			#declare DGBZINTC3 = <5,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (129) // Transition 030
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.25,-0.2,0>
			#declare DGBZINTC2 = <0,1.2,0>
			#declare DGBZINTC3 = <0.25,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (130) // Transition 031
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.5,-0.2,0>
			#declare DGBZINTC2 = <0,1.2,0>
			#declare DGBZINTC3 = <0.5,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (131) // Transition 032
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <0.75,-0.2,0>
			#declare DGBZINTC2 = <0,1.2,0>
			#declare DGBZINTC3 = <0.75,1,0>
			#declare DGBZINTC1 = <0,0,0>
			#declare DGBZINTC2 = <0,0,0>
			#declare DGBZINTC3 = <0,0,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (132) // Transition 033
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <1,-0.2,0>
			#declare DGBZINTC2 = <0,1.2,0>
			#declare DGBZINTC3 = <1,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
		#case (133) // Transition 034
			#declare DGBZINTC0 = <0,0,0>
			#declare DGBZINTC1 = <2,-0.2,0>
			#declare DGBZINTC2 = <0,1.2,0>
			#declare DGBZINTC3 = <2,1,0>
			#declare DGBZINTCommand = 2 // Exact position
			#include "DGBZINT.INC"
			#declare DGBZLength = 0
			#declare DGBZTransition = DGBZPosition.y
		#break
	#end
#end
// End of the DGBZ.INC File

