// --------------------------------------------------------
//     DGBZINT.INC
//     Dave G's Timeline Animation System (internal file)
//     Include file for POV-RAY 3.0
//
//     File is for use of the DGBZ.INC file
// --------------------------------------------------------
//
//     Copyright (C) 1997
//        David Govoni
//        E-mail: david.govoni@sympatico.ca
//
//           Please contact me with any:
//              comments, suggestions, changes,
//              and success stories. If you
//              create any wonderful animations or images
//              I would like to know about them.
//
//     Version
//        0.95 Beta - March 22nd, 1997
//
// --------------------------------------------------------
// Documentation is in:
//   DGBZ.PDF - Adobe Acrobat Format
//
// --------------------------------------------------------
// This file is freely distributable and useable as long
// as all files in this archive are kept together.
// --------------------------------------------------------
// If you make changes or additions to this file, please
// put your name, the date, and a description of the
// changes into the file. If you feel the changes should
// be added to later releases of this file, please tell me
// about your modifications.
// --------------------------------------------------------
//
//
//
//
// --------------------------------------------------------
// ***** NOTE - Math follows *****
// --------------------------------------------------------
// If you are trying to figure out how this file works, here
// is a help to cut through the confusion.
//
// Usually the bezier curve of four points is generated using
// the Bernstein's Basis Function:
// C0 - C4 are the points
// A point(P) u amount through the curve is given by:
// P0 = C0 * (1-u)^3
// P1 = C1 * (3 * (1-u)^2 * u)
// P2 = C2 * (3 * (1-y) * u^2)
// p3 = C3 * (u^3)
// P = P0 + P1 + P2 + P3
//
// However, a bit of algebra and elbow grease gives:
// P0 = C0 * (-u^3 + 3u^2 -3u + 1)
// P1 = C1 * (3u^3 - 6u^2 + 3u)
// P2 = C2 * (-3u^3+3u^2)
// P3 = C3 * (u^3)
// P  = P0 + P1 + P2 + P3
//
// This form, which is just a simple expansion can be
// coded so that POV-Ray performs fewer exponential
// calculations. I'm not sure if this makes any
// difference in performance (I'll be testing later)
// but for the time being, I'm leaving the calculations
// in this way.
// --------------------------------------------------------



// --------------------------------------------------------
// Now check to see that all variables are defined for use.
// If they aren't then set them to their defaults.
#ifndef (DGBZINTC0)             #declare DGBZINTC0 = <-5, 0, 0>      #end
#ifndef (DGBZINTC1)             #declare DGBZINTC1 = <-4, 5, 0>      #end
#ifndef (DGBZINTC2)             #declare DGBZINTC2 = < 4, 5, 0>      #end
#ifndef (DGBZINTC3)             #declare DGBZINTC3 = < 5, 0, 0>      #end
#ifndef (DGBZINTLength)         #declare DGBZINTLength = 0           #end
#ifndef (DGBZSteps)             #declare DGBZSteps = 1000            #end
#ifndef (DGBZINTCurve_Position) #declare DGBZINTCurve_Position = 0.5 #end
#ifndef (DGBZINTPosition)       #declare DGBZINTPosition = <0,0,0>   #end
#ifndef (DGBZINTCommand)        #declare DGBZINTCommand = 1          #end
// --------------------------------------------------------


// --------------------------------------------------------
// Now, check to see if we are integrating the curve or placing a point.
#switch (DGBZINTCommand)
#case (1) // Integrate the length
	// We are integrating the length
	#declare DGBZINTLast_Position = DGBZINTC0
	#declare DGBZINTLength        = 0
	#declare DGBZINTCurrent_Step  = 1
	#while (DGBZINTCurrent_Step < DGBZSteps)
		// One way of calculating the current position (see note on algebra)
		// Pre-calculation of values
		#declare DGBZINTU   = DGBZINTCurrent_Step / DGBZSteps
		#declare DGBZINTU2  = DGBZINTU  * DGBZINTU
		#declare DGBZINTU3  = DGBZINTU2 * DGBZINTU
		#declare DGBZINT3U  = DGBZINTU  * 3
		#declare DGBZINT3U2 = DGBZINTU2 * 3
		#declare DGBZINT3U3 = DGBZINTU3 * 3
		// Now find the four values for the basis function
		#declare DGBZINTQ0  = 1 - DGBZINT3U + DGBZINT3U2 - DGBZINTU3
		#declare DGBZINTQ1  = DGBZINT3U3 - (2 * DGBZINT3U2) + DGBZINT3U
		#declare DGBZINTQ2  = DGBZINT3U2 - DGBZINT3U3
		// #declare DGBZINTQ3 = DGBZINTU3 (so I use DGBZINTU3 directly)
		// Now calculate the point itself
		#declare DGBZINTPosition = (DGBZINTQ0*DGBZINTC0)+(DGBZINTQ1*DGBZINTC1)+(DGBZINTQ2*DGBZINTC2)+(DGBZINTU3*DGBZINTC3)

		// Now add the length from the last point to the total length
		#declare DGBZINTLength = DGBZINTLength + vlength(DGBZINTPosition - DGBZINTLast_Position)

		// Now store this position for the next increment
		#declare DGBZINTLast_Position = DGBZINTPosition

		// Now advance the loop to the next increment
		#declare DGBZINTCurrent_Step = DGBZINTCurrent_Step + 1
	#end
	#break
#case (2) // Find an accurate point along the curve
	// We are finding a point along the curve
	// This assumes that the length along the has not been found.
	// Therefore we find the length as above and then increment along
	// again until we've covered the right distance
	// We are integrating the length
	#declare DGBZINTLast_Position = DGBZINTC0
	#declare DGBZINTLength        = 0
	#declare DGBZINTCurrent_Step  = 1
	#while (DGBZINTCurrent_Step < DGBZSteps)
		// One way of calculating the current position (see note on algebra)
		// Pre-calculation of values
		#declare DGBZINTU   = DGBZINTCurrent_Step / DGBZSteps
		#declare DGBZINTU2  = DGBZINTU  * DGBZINTU
		#declare DGBZINTU3  = DGBZINTU2 * DGBZINTU
		#declare DGBZINT3U  = DGBZINTU  * 3
		#declare DGBZINT3U2 = DGBZINTU2 * 3
		#declare DGBZINT3U3 = DGBZINTU3 * 3
		// Now find the four values for the basis function
		#declare DGBZINTQ0  = 1 - DGBZINT3U + DGBZINT3U2 - DGBZINTU3
		#declare DGBZINTQ1  = DGBZINT3U3 - (2 * DGBZINT3U2) + DGBZINT3U
		#declare DGBZINTQ2  = DGBZINT3U2 - DGBZINT3U3
		// #declare DGBZINTQ3 = DGBZINTU3 (so I use DGBZINTU3 directly)
		// Now calculate the point itself
		#declare DGBZINTPosition = (DGBZINTQ0*DGBZINTC0)+(DGBZINTQ1*DGBZINTC1)+(DGBZINTQ2*DGBZINTC2)+(DGBZINTU3*DGBZINTC3)

		// Now add the length from the last point to the total length
		#declare DGBZINTLength = DGBZINTLength + vlength(DGBZINTPosition - DGBZINTLast_Position)

		// Now store this position for the next increment
		#declare DGBZINTLast_Position = DGBZINTPosition

		// Now advance the loop to the next increment
		#declare DGBZINTCurrent_Step = DGBZINTCurrent_Step + 1
	#end
	// We are integrating and keeping track of the current length of the curve
	#declare DGBZINTTotal_Length = DGBZINTLength // and return this value back into length later
	#declare DGBZINTLast_Position = DGBZINTC0
	#declare DGBZINTLength        = 0
	#declare DGBZINTCurrent_Step  = 1
	#declare DGBZINTFound_Position = false
	// if we are at the starting or ending points...
	#if (DGBZINTCurve_Position = 0)
		#declare DGBZINTPosition = DGBZINTC0
		#declare DGBZINTFound_Position = true
	#end
	#if (DGBZINTCurve_Position = 1.0)
		#declare DGBZINTPosition = DGBZINTC3
		#declare DGBZINTFound_Position = true
	#end
	#while ((DGBZINTCurrent_Step < DGBZSteps) & (DGBZINTFound_Position = false))
		// One way of calculating the current position (see note on algebra)
		// Pre-calculation of values
		#declare DGBZINTU   = DGBZINTCurrent_Step / DGBZSteps
		#declare DGBZINTU2  = DGBZINTU  * DGBZINTU
		#declare DGBZINTU3  = DGBZINTU2 * DGBZINTU
		#declare DGBZINT3U  = DGBZINTU  * 3
		#declare DGBZINT3U2 = DGBZINTU2 * 3
		#declare DGBZINT3U3 = DGBZINTU3 * 3
		// Now find the four values for the basis function
		#declare DGBZINTQ0  = 1 - DGBZINT3U + DGBZINT3U2 - DGBZINTU3
		#declare DGBZINTQ1  = DGBZINT3U3 - (2 * DGBZINT3U2) + DGBZINT3U
		#declare DGBZINTQ2  = DGBZINT3U2 - DGBZINT3U3
		// #declare DGBZINTQ3 = DGBZINTU3 (so I use DGBZINTU3 directly)
		// Now calculate the point itself
		#declare DGBZINTPosition = (DGBZINTQ0*DGBZINTC0)+(DGBZINTQ1*DGBZINTC1)+(DGBZINTQ2*DGBZINTC2)+(DGBZINTU3*DGBZINTC3)
		// Now add the length from the last point to the total length
		#declare DGBZINTLength = DGBZINTLength + vlength(DGBZINTPosition - DGBZINTLast_Position)
		// Now store this position for the next increment
		#declare DGBZINTLast_Position = DGBZINTPosition

		// Now check to see if the current position is past the position we wish to find
		#if (DGBZINTLength > (DGBZINTTotal_Length * DGBZINTCurve_Position))
			#declare DGBZINTFound_Position = true
		#end

		// Now advance the loop to the next increment
		#declare DGBZINTCurrent_Step = DGBZINTCurrent_Step + 1

	#end
	#declare DGBZINTLength = DGBZINTTotal_Length // return the correct path length to the length variable

	// Just in case
	#if (DGBZINTFound_Position = false)
		#declare DGBZINTFound_Position = true
		#declare DGBZINTPosition = DGBZINTC3 // if we didn't find it use the final point on the curve
	#end
	#break
#case (3) // Find an Accurate Position so far along the curve
	#declare DGBZINTLast_Position = DGBZINTC0
	#declare DGBZINTLength        = 0
	#declare DGBZINTCurrent_Step  = 1
	#while (DGBZINTCurrent_Step < DGBZSteps)
		// One way of calculating the current position (see note on algebra)
		// Pre-calculation of values
		#declare DGBZINTU   = DGBZINTCurrent_Step / DGBZSteps
		#declare DGBZINTU2  = DGBZINTU  * DGBZINTU
		#declare DGBZINTU3  = DGBZINTU2 * DGBZINTU
		#declare DGBZINT3U  = DGBZINTU  * 3
		#declare DGBZINT3U2 = DGBZINTU2 * 3
		#declare DGBZINT3U3 = DGBZINTU3 * 3
		// Now find the four values for the basis function
		#declare DGBZINTQ0  = 1 - DGBZINT3U + DGBZINT3U2 - DGBZINTU3
		#declare DGBZINTQ1  = DGBZINT3U3 - (2 * DGBZINT3U2) + DGBZINT3U
		#declare DGBZINTQ2  = DGBZINT3U2 - DGBZINT3U3
		// #declare DGBZINTQ3 = DGBZINTU3 (so I use DGBZINTU3 directly)
		// Now calculate the point itself
		#declare DGBZINTPosition = (DGBZINTQ0*DGBZINTC0)+(DGBZINTQ1*DGBZINTC1)+(DGBZINTQ2*DGBZINTC2)+(DGBZINTU3*DGBZINTC3)

		// Now add the length from the last point to the total length
		#declare DGBZINTLength = DGBZINTLength + vlength(DGBZINTPosition - DGBZINTLast_Position)

		// Now store this position for the next increment
		#declare DGBZINTLast_Position = DGBZINTPosition

		// Now advance the loop to the next increment
		#declare DGBZINTCurrent_Step = DGBZINTCurrent_Step + 1
	#end
	// We are integrating and keeping track of the current length of the curve
	#declare DGBZINTTotal_Length = DGBZINTLength // and return this value back into length later
	#declare DGBZINTLast_Position = DGBZINTC0
	#declare DGBZINTLength        = 0
	#declare DGBZINTCurrent_Step  = 1
	#declare DGBZINTFound_Position = false
	#declare DGBZINTCurve_Position = mod(abs(DGBZINTDistance / DGBZINTTotal_Length),1)
	// if we are at the starting or ending points...
	#if (DGBZINTCurve_Position = 0)
		#declare DGBZINTPosition = DGBZINTC0
		#declare DGBZINTFound_Position = true
	#end
	#if (DGBZINTCurve_Position = 1.0)
		#declare DGBZINTPosition = DGBZINTC3
		#declare DGBZINTFound_Position = true
	#end
	#while ((DGBZINTCurrent_Step < DGBZSteps) & (DGBZINTFound_Position = false))
		// One way of calculating the current position (see note on algebra)
		// Pre-calculation of values
		#declare DGBZINTU   = DGBZINTCurrent_Step / DGBZSteps
		#declare DGBZINTU2  = DGBZINTU  * DGBZINTU
		#declare DGBZINTU3  = DGBZINTU2 * DGBZINTU
		#declare DGBZINT3U  = DGBZINTU  * 3
		#declare DGBZINT3U2 = DGBZINTU2 * 3
		#declare DGBZINT3U3 = DGBZINTU3 * 3
		// Now find the four values for the basis function
		#declare DGBZINTQ0  = 1 - DGBZINT3U + DGBZINT3U2 - DGBZINTU3
		#declare DGBZINTQ1  = DGBZINT3U3 - (2 * DGBZINT3U2) + DGBZINT3U
		#declare DGBZINTQ2  = DGBZINT3U2 - DGBZINT3U3
		// #declare DGBZINTQ3 = DGBZINTU3 (so I use DGBZINTU3 directly)
		// Now calculate the point itself
		#declare DGBZINTPosition = (DGBZINTQ0*DGBZINTC0)+(DGBZINTQ1*DGBZINTC1)+(DGBZINTQ2*DGBZINTC2)+(DGBZINTU3*DGBZINTC3)
		// Now add the length from the last point to the total length
		#declare DGBZINTLength = DGBZINTLength + vlength(DGBZINTPosition - DGBZINTLast_Position)
		// Now store this position for the next increment
		#declare DGBZINTLast_Position = DGBZINTPosition

		// Now check to see if the current position is past the position we wish to find
		#if (DGBZINTLength > (DGBZINTTotal_Length * DGBZINTCurve_Position))
			#declare DGBZINTFound_Position = true
		#end

		// Now advance the loop to the next increment
		#declare DGBZINTCurrent_Step = DGBZINTCurrent_Step + 1

	#end
	#declare DGBZINTLength = DGBZINTTotal_Length // return the correct path length to the length variable

	// Just in case
	#if (DGBZINTFound_Position = false)
		#declare DGBZINTFound_Position = true
		#declare DGBZINTPosition = DGBZINTC3 // if we didn't find it use the final point on the curve
	#end


	#break
#else // (4 and above) calculate a fast position
	// This calculates a quick position using the standard computation
	#declare DGBZINTU   = DGBZINTCurve_Position
	#declare DGBZINTU2  = DGBZINTU  * DGBZINTU
	#declare DGBZINTU3  = DGBZINTU2 * DGBZINTU
	#declare DGBZINT3U  = DGBZINTU  * 3
	#declare DGBZINT3U2 = DGBZINTU2 * 3
	#declare DGBZINT3U3 = DGBZINTU3 * 3
	// Now find the four values for the basis function
	#declare DGBZINTQ0  = 1 - DGBZINT3U + DGBZINT3U2 - DGBZINTU3
	#declare DGBZINTQ1  = DGBZINT3U3 - (2 * DGBZINT3U2) + DGBZINT3U
	#declare DGBZINTQ2  = DGBZINT3U2 - DGBZINT3U3
	// #declare DGBZINTQ3 = DGBZINTU3 (so I use DGBZINTU3 directly)
	// Now calculate the point itself
	#declare DGBZINTPosition = (DGBZINTQ0*DGBZINTC0)+(DGBZINTQ1*DGBZINTC1)+(DGBZINTQ2*DGBZINTC2)+(DGBZINTU3*DGBZINTC3)

#end


