// --------------------------------------------------------
//     DGPAS.INC
//     Dave G's Particle Animation System
//     Include file for POV-RAY 3.0
// --------------------------------------------------------
//
//     Copyright (C) 1997
//        David Govoni
//        E-mail: david.govoni@sympatico.ca
//
//           Please contact me with any:
//              comments, suggestions, changes,
//              and success stories. If you
//              create any wonderful animations or images
//              I would like to know about them.
//
//     Version
//        0.95 Beta - March 22nd, 1997
//
// --------------------------------------------------------
// Documentation is in:
//   DGPAS.PDF - Adobe Acrobat Format
//
// --------------------------------------------------------
// This file is freely distributable and useable as long
// as all files in this archive are kept together.
// --------------------------------------------------------
// If you make changes or additions to this file, please
// put your name, the date, and a description of the
// changes into the file. If you feel the changes should
// be added to later releases of this file, please tell me
// about your modifications.
// --------------------------------------------------------
//
//
//
//
// --------------------------------------------------------
// Check to see if any of the declared variables do not exist.
//  If they don't - set them to a default value
#ifndef (DGPASCommand)          #declare DGPASCommand          = "RESET"    #end
#ifndef (DGPASInitial_Time)     #declare DGPASInitial_Time     = 0.0        #end
#ifndef (DGPASFinal_Time)       #declare DGPASFinal_Time       = 1.0        #end
#ifndef (DGPASTime_Scale)       #declare DGPASTime_Scale       = 1.0        #end
#ifndef (DGPASTime_Type)        #declare DGPASTime_Type        =  "CLOCK"   #end
#ifndef (DGPASObject_Type)      #declare DGPASObject_Type      = "DECLARED" #end
#ifndef (DGPASParticle)         #declare DGPASParticle         = false      #end
#ifndef (DGPASParticle_Life)    #declare DGPASParticle_Life    = 0          #end
#ifndef (DGPASCommand_Num)      #declare DGPASCommand_Num      = 1          #end
#ifndef (DGPASStart_Point)      #declare DGPASStart_Point      = <-1,0,0>   #end
#ifndef (DGPASEnd_Point)        #declare DGPASEnd_Point        = <1,0,0>    #end
#ifndef (DGPASCurrent_Point)    #declare DGPASCurrent_Point    = <0,0,0>    #end
#ifndef (DGPASInitial_Velocity) #declare DGPASInitial_Velocity = <0,0,0>    #end
#ifndef (DGPASCurrent_Velocity) #declare DGPASCurrent_Velocity = <0,0,0>    #end
#ifndef (DGPASSegment)          #declare DGPASSegment          = 0          #end
#ifndef (DGPASAcceleration)     #declare DGPASAcceleration     = <0,0,0>    #end
#ifndef (DGPASBounce_Plane)     #declare DGPASBounce_Plane      = "X"       #end
#ifndef (DGPASBounce_Point)     #declare DGPASBounce_Point     = 0          #end
#ifndef (DGPASBounce_Num)       #declare DGPASBounce_Num       = 1          #end
#ifndef (DGPASBounce)           #declare DGPASBounce           = false      #end
#ifndef (DGPASResilience)       #declare DGPASResilience       = 1          #end
#ifndef (DGPASBounce_Min)       #declare DGPASBounce_Min       = 0.05       #end
#ifndef (DGPASFold_X)           #declare DGPASFold_X           = false      #end
#ifndef (DGPASFold_Y)           #declare DGPASFold_Y           = false      #end
#ifndef (DGPASFold_Z)           #declare DGPASFold_Z           = false      #end
#ifndef (DGPASFold_X_Max)       #declare DGPASFold_X_Max       = 5          #end
#ifndef (DGPASFold_X_Min)       #declare DGPASFold_X_Min       = 5          #end
#ifndef (DGPASFold_Y_Max)       #declare DGPASFold_Y_Max       = 5          #end
#ifndef (DGPASFold_Y_Min)       #declare DGPASFold_Y_Min       = 5          #end
#ifndef (DGPASFold_Z_Max)       #declare DGPASFold_Z_Max       = 5          #end
#ifndef (DGPASFold_Z_Min)       #declare DGPASFold_Z_Min       = 5          #end
// --------------------------------------------------------


// --------------------------------------------------------
// Checking for correctness of incoming data
// --------------------------------------------------------
// 1) Is Initial_Time less than Final_Time?
//    If not switch them
#if (DGPASInitial_Time > DGPASFinal_Time)
	#declare DGPASTemp         = DGPASInitial_Time
	#declare DGPASInitial_Time = DGPASFinal_Time
	#declare DGPASFinal_Time   = DGPASTemp
#end
// --------------------------------------------------------
// 2) Is Initial_Time equal to Final_Time?
//    If so set them to 0 and 1
#if (DGPASInitial_Time = DGPASFinal_Time)
	#declare DGPASInitial_Time = 0
	#declare DGPASFinal_Time   = 0
#end
// --------------------------------------------------------
// 3) Is the Time_Scale set to zero?
//    If so make it 1
#if (DGPASTime_Scale = 0) #declare DGPASTime_Scale = 1 #end
// --------------------------------------------------------
// 4) Make the Time_Scale value greater than zero
#declare DGPASTime_Scale = abs(DGPASTime_Scale)
// --------------------------------------------------------
// 5) Make all the String Variables Upper Case
#declare DGPASCommand      = strupr(DGPASCommand)
#declare DGPASObject_Type  = strupr(DGPASObject_Type)
#declare DGPASTime_Type    = strupr(DGPASTime_Type)
#declare DGPASBounce_Plane = strupr(DGPASBounce_Plane)
// --------------------------------------------------------
// 6) Check the Bounce_Min
#declare DGPASBounce_Min = abs(DGPASBounce_Min)
#if (DGPASBounce_Min = 0) #declare DGPASBounce_Min = 0.01 #end
// --------------------------------------------------------
// 7) Make sure the Resilience is above zero
#declare DGPASResilience = abs(DGPASResilience)
// --------------------------------------------------------
// 8) Re-order the fold Max and Min if necessary
#if (DGPASFold_X_Min > DGPASFold_X_Max)
	#declare DGPASTemp       = DGPASFold_X_Min
	#declare DGPASFold_X_Min = DGPASFold_X_Max
	#declare DGPASFold_X_Max = DGPASTemp
#end
#if (DGPASFold_Y_Min > DGPASFold_Y_Max)
	#declare DGPASTemp       = DGPASFold_Y_Min
	#declare DGPASFold_Y_Min = DGPASFold_Y_Max
	#declare DGPASFold_Y_Max = DGPASTemp
#end
#if (DGPASFold_Z_Min > DGPASFold_Z_Max)
	#declare DGPASTemp       = DGPASFold_Z_Min
	#declare DGPASFold_Z_Min = DGPASFold_Z_Max
	#declare DGPASFold_Z_Max = DGPASTemp
#end
// --------------------------------------------------------
// 9) Check for fold Max being equal to Min
#if (DGPASFold_X_Min = DGPASFold_X_Max) #declare DGPASFold_X = false #end
#if (DGPASFold_Y_Min = DGPASFold_Y_Max) #declare DGPASFold_Y = false #end
#if (DGPASFold_Z_Min = DGPASFold_Z_Max) #declare DGPASFold_Z = false #end
// --------------------------------------------------------


// --------------------------------------------------------
// POV-RAY's parser does not allow for strings to be used
// in a switch-case statement. So this section converts
// the string commands and settings into numerical
// values
// --------------------------------------------------------
// Translate the Command String
#declare DGPASCommand_Num = 1 // RESET
#if (strcmp(DGPASCommand,"RESET")=0)             #declare DGPASCommand_Num = 1 #end
#if (strcmp(DGPASCommand,"STILL_PARTICLE")=0)    #declare DGPASCommand_Num = 2 #end
#if (strcmp(DGPASCommand,"MOVING_PARTICLE")=0)   #declare DGPASCommand_Num = 3 #end
#if (strcmp(DGPASCommand,"VELOCITY_PARTICLE")=0) #declare DGPASCommand_Num = 4 #end
#if (strcmp(DGPASCommand,"ACCEL_PARTICLE")=0)    #declare DGPASCommand_Num = 5 #end
#if (strcmp(DGPASCommand,"BOUNCE_PARTICLE")=0)   #declare DGPASCommand_Num = 6 #end
// --------------------------------------------------------
// Translate the Object Type String
#declare DGPASObject_Num = 1 // DECLARED
#if (strcmp(DGPASObject_Type,"DECLARED")=0) #declare DGPASObject_Num = 1 #end
#if (strcmp(DGPASObject_Type,"USER")=0)     #declare DGPASObject_Num = 2 #end
// --------------------------------------------------------
// Translate the Time_Type String
#declare DGPASTime_Num = 1 // POV-Ray clock variable
#if (strcmp(DGPASTime_Type,"CLOCK")=0)         #declare DGPASTime_Num = 1 #end
#if (strcmp(DGPASTime_Type,"SEGMENT_CLOCK")=0) #declare DGPASTime_Num = 2 #end
#if (strcmp(DGPASTime_Type,"MASTER_CLOCK")=0)  #declare DGPASTime_Num = 3 #end
#if (strcmp(DGPASTime_Type,"SEGMENT_TIME")=0)  #declare DGPASTime_Num = 4 #end
// --------------------------------------------------------
// Translate the Bounce_Plane String
#declare DGPASBounce_Num = 1 // X axis
#if (strcmp(DGPASBounce_Plane,"X")=0) #declare DGPASBounce_Num = 1 #end
#if (strcmp(DGPASBounce_Plane,"Y")=0) #declare DGPASBounce_Num = 2 #end
#if (strcmp(DGPASBounce_Plane,"Z")=0) #declare DGPASBounce_Num = 3 #end
// --------------------------------------------------------


// --------------------------------------------------------
// Start to work through the commands. All the particle
// commands are grouped together. Only the RESET command is
// separate.
// --------------------------------------------------------
#if (DGPASCommand_Num = 1) // RESET
	// RESET all variables to their defaults
	#declare DGPASInital_Time      = 0.0
	#declare DGPASFinal_Time       = 1.0
	#declare DGPASTime_Scale       = 1.0
   #declare DGPASTime_Type        = "CLOCK"
	#declare DGPASObject_Type      = "DECLARED"
	#declare DGPASSegment          = 0
	#declare DGPASParticle         = false
	#declare DGPASParticle_Life    = 0
	#declare DGPASStart_Point      = <-1, 0, 0>
	#declare DGPASEnd_Point        = < 1, 0, 0>
	#declare DGPASCurrent_Point    = < 0, 0, 0>
	#declare DGPASInitial_Velocity = < 0, 0, 0>
	#declare DGPASCurrent_Velocity = < 0, 0, 0>
	#declare DGPASAcceleration     = < 0, 0, 0>
	#declare DGPASBounce_Plane     = "X"
	#declare DGPASBounce_Point     = 0
	#declare DGPASResilience       = 1
	#declare DGPASBounce_Min       = 0.01
	#declare DGPASFold_X           = false
	#declare DGPASFold_Y           = false
	#declare DGPASFold_Z           = false
	#declare DGPASFold_X_Max       =  5
	#declare DGPASFold_X_Min       = -5
	#declare DGPASFold_Y_Max       =  5
	#declare DGPASFold_Y_Min       = -5
	#declare DGPASFold_Z_Max       =  5
	#declare DGPASFold_Z_Min       = -5
#else
	// All commands except RESET
	#declare DGPASParticle      = false
	#declare DGPASParticle_Life = 0
	#switch (DGPASTime_Num)
		#case(3) // Timeline Master clock from DGTL timeline file
			#ifdef (DGTLMaster_Clock)
				#declare DGPASNewClock = DGTLMaster_Clock * DGPASTime_Scale
				#if ((DGPASInitial_Time <= DGTLNewClock) & (DGPASFinal_Time >= DGTLNewClock))
					#declare DGPASParticle      = true
					#declare DGPASParticle_Life = DGPASNewClock / (DGPASFinal_Time - DGPASInitial_Time)
					#declare DGPASTime_In       = DGPASNewClock - DGPASInitial_Time
					#declare DGPASTime_Total    = DGPASFinal_Time  - DGPASInitial_Time
				#end
			#end
		#break
		#case(2) // Timeline Segment clock from the DGTL timeline file
			#ifdef (DGTLCurrent_Segment)
			#ifdef (DGTLSegment_Clock)
				#if ((DGPASSegment = 0) | (DGPASSegment = DGTLCurrent_Segment))
					#declare DGPASNewClock = DGTLSegment_Clock * DGPASTime_Scale
					#if ((DGPASNewClock >= DGPASInitial_Time) & (DGPASNewClock <= DGPASFinal_Time))
						#declare DGPASParticle      = true
						#declare DGPASParticle_Life = (DGPASNewClock - DGPASInitial_Time) / (DGPASFinal_Time - DGPASInitial_Time)
						#declare DGPASTime_In       = DGPASNewClock - DGPASInitial_Time
						#declare DGPASTime_Total    = DGPASFinal_Time - DGPASInitial_Time
					#end
				#end
			#end
			#end
		#break
		#case(4) // TimeLine time amount
			#ifdef (DGTLCurrent_Segment)
			#ifdef (DGTLSegment_Clock)
			#ifdef (DGTLSegment_Duration)
				#if ((DGPASSegment = 0) | (DGPASSegment = DGTLCurrent_Segment))
					#declare DGPASNewClock = DGTLSegment_Duration * DGPASTime_Scale * DGTLSegment_Clock
					#if ((DGPASNewClock >= DGPASInitial_Time) & (DGPASNewClock <= DGPASFinal_Time))
						#declare DGPASParticle      = true
						#declare DGPASParticle_Life = (DGPASNewClock - DGPASInitial_Time) / (DGPASFinal_Time - DGPASInitial_Time)
						#declare DGPASTime_In       = DGPASNewClock - DGPASInitial_Time
						#declare DGPASTime_Total    = DGPASFinal_Time - DGPASInitial_Time
					#end
				#end
			#end
			#end
			#end
		#break
		#else // POV-RAY clock variable
			#declare DGPASNewClock = clock * DGPASTime_Scale
			#if ((DGPASNewClock >= DGPASInitial_Time) & (DGPASNewClock <= DGPASFinal_Time))
				#declare DGPASParticle = true
				#declare DGPASParticle_Life = (DGPASNewClock - DGPASInitial_Time) / (DGPASFinal_Time - DGPASInitial_Time)
				#declare DGPASTime_In       = DGPASNewClock - DGPASInitial_Time
				#declare DGPASTime_Total    = DGPASFinal_Time - DGPASInitial_Time
			#end
	#end

	// If the particle exists determine its location
	#if (DGPASParticle = true)
		#switch (DGPASCommand_Num) // Type of Particle
			#case (2) // STILL_PARTICLE
				#declare DGPASCurrent_Point    = <0, 0, 0>
				#declare DGPASCurrent_Velocity = <0, 0, 0>
			#break
			#case (3) // MOVING_PARTICLE
				#declare DGPASCurrent_Point    = (DGPASStart_Point - DGPASEnd_Point)
				#declare DGPASCurrent_Point    = DGPASCurrent_Point * (DGPASParticle_Life * <1,1,1> )
				#declare DGPASCurrent_Point    = DGPASStart_Point - DGPASCurrent_Point
				#declare DGPASCurrent_Velocity = DGPASStart_Point - DGPASEnd_Point
				#declare DGPASCurrent_Velocity = DGPASCurrent_Velocity / (DGPASTime_Total * <1,1,1>)
			#break
			#case (4) // VELOCITY_PARTICLE
				#declare DGPASCurrent_Point    = DGPASTime_In * DGPASInitial_Velocity
				#declare DGPASCurrent_Point    = DGPASCurrent_Point + DGPASStart_Point
				#declare DGPASCurrent_Velocity = DGPASInitial_Velocity
			#break
			#case (5) // ACCEL_PARTICLE
				#declare DGPASCurrent_Point = DGPASStart_Point + (DGPASInitial_Velocity * DGPASTime_In)
				#declare DGPASCurrent_Point = DGPASCurrent_Point + (0.5 * DGPASAcceleration * DGPASTime_In * DGPASTime_In)
				#declare DGPASCurrent_Velocity = DGPASInitial_Velocity + (DGPASAcceleration * DGPASTime_In)
			#break
			#case (6) // BOUNCE_PARTICLE
				#declare DGPASBounce = true
				// Is the acceleration towards the plane?
				#switch (DGPASBounce_Num)
					#case (1) // X Axis
						#declare DGPASTempSP = DGPASStart_Point.x
						#declare DGPASTempAC = DGPASAcceleration.x
						#declare DGPASTempVL = DGPASInitial_Velocity.x
					#break
					#case (2) // Y Axis
						#declare DGPASTempSP = DGPASStart_Point.y
						#declare DGPASTempAC = DGPASAcceleration.y
						#declare DGPASTempVL = DGPASInitial_Velocity.y
					#break
					#case (3) // Z Axis
						#declare DGPASTempSP = DGPASStart_Point.z
						#declare DGPASTempAC = DGPASAcceleration.z
						#declare DGPASTempVL = DGPASInitial_Velocity.z
					#break
				#end
				// record the starting position and velocity
				#declare DGPASTempSP2 = DGPASStart_Point
				#declare DGPASTempVL2 = DGPASInitial_Velocity
				#declare DGPASTempAC2 = DGPASAcceleration
				// Is there no Acceleration ?
				#if (DGPASTempAC = 0)
					#declare DGPASBounce = false
				#end
				// is the accel towards the bounce point ?
				#if ((DGPASBounce = true) & (DGPASBounce_Point != DGPASTempSP))
					#if ((DGPASTempSP - DGPASBounce_Point) > 0)
						// Point is 'above' the plane
						#if (DGPASTempAC > 0)
							#declare DGPASBounce = false
						#end
					#else
						// Point is 'below' the plane
						#if (DGPASTempAC < 0)
							#declare DGPASBounce = false
						#end
					#end
				#end
				// is the particle on the bounce plane ?
				#if ((DGPASBounce = true) & (DGPASBounce_Point = DGPASTempSP))
					// check that there is an initial velocity
					#if (DGPASTempVL = 0)
						#declare DGPASBounce = false
					#end
				#end

				#if (DGPASBounce = true)
					// now bounce the particle
                                        #declare DGPASTempIT = DGPASInitial_Time
					#declare DGPASFound = false
					#while (DGPASFound = false)
						#declare DGPASTempA = 0.5 * DGPASTempAC
						#declare DGPASTempB = DGPASTempVL
						#declare DGPASTempC = DGPASTempSP - DGPASBounce_Point
						#declare DGPASTempR1 = sqrt((DGPASTempB* DGPASTempB) - (4 * DGPASTempA * DGPASTempC))
						#declare DGPASTempR1 = (-DGPASTempB - DGPASTempR1) / (2 * DGPASTempA)
						#declare DGPASTempR2 = sqrt((DGPASTempB* DGPASTempB) - (4 * DGPASTempA * DGPASTempC))
						#declare DGPASTempR2 = (-DGPASTempB + DGPASTempR2) / (2 * DGPASTempA)
						#if (DGPASTempR2 > DGPASTempR1)
							#declare DGPASTempR1 = DGPASTempR2
						#end
						#if (DGPASNewClock > (DGPASTempR1 + DGPASTempIT))
							#declare DGPASTempIT = DGPASTempIT + DGPASTempR1
							#declare DGPASTempVL = -(DGPASTempAC * DGPASTempR1 + DGPASTempVL) * DGPASResilience
							#declare DGPASTempSP = DGPASBounce_Point
							#declare DGPASTempSP2 = DGPASTempSP2 + (DGPASTempVL2 * DGPASTempR1)
							#declare DGPASTempSP2 = DGPASTempSP2 + (0.5 * DGPASTempAC2 * DGPASTempR1 * DGPASTempR1)
							#declare DGPASTempVL2 = DGPASTempVL2 + (DGPASTempAC2 * DGPASTempR1)
							#declare DGPASTempVL2 = DGPASTempVL2 * (DGPASResilience * <1,1,1>)
							#if (abs(DGPASTempVL) <= abs(DGPASBounce_Min))
								#declare DGPASFound = true
								#declare DGPASTempVL = 0
								#declare DGPASTempSP = DGPASBounce_Point
								#declare DGPASTemp = DGPASNewClock - DGPASTempIT // time left
								#declare DGPASTempCP2 = DGPASTempSP2 + DGPASTempVL2 * DGPASTemp
								#declare DGPASTempCP2 = DGPASTempCP2 + (0.5 * DGPASTempAC2 * DGPASTemp * DGPASTemp)
								#declare DGPASTempVL2 = DGPASTempVL2 + (DGPASTempAC2 * DGPASTemp)
								#switch (DGPASBounce_Num)
									#case (1) // X-Axis
										#declare DGPASCurrent_Point = DGPASTempCP2
										#declare DGPASCurrent_Point = (DGPASTempSP * <1,0,0>) + (DGPASCurrent_Point * <0,1,1>)
										#declare DGPASCurrent_Velocity = DGPASTempVL2
										#declare DGPASCurrent_Velocity = (DGPASTempVL * <1,0,0>) + (DGPASCurrent_Velocity * <0,1,1>)
									#break
									#case (2) // Y Axis
										#declare DGPASCurrent_Point = DGPASTempCP2
										#declare DGPASCurrent_Point = (DGPASTempSP * <0,1,0>) + (DGPASCurrent_Point*<1,0,1>)
											#declare DGPASCurrent_Velocity = DGPASTempVL2
										#declare DGPASCurrent_Velocity = (DGPASTempVL * <0,1,0>) + (DGPASCurrent_Velocity*<1,0,1>)
									#break
									#case (3) //Z-Axis
										#declare DGPASCurrent_Point = DGPASTempCP2
											#declare DGPASCurrent_Point = (DGPASTempSP * <0,0,1>) + (DGPASCurrent_Point*<1,1,0>)
										#declare DGPASCurrent_Velocity = DGPASTempVL2
										#declare DGPASCurrent_Velocity = (DGPASTempVL * <0,0,1>) + (DGPASCurrent_Velocity*<1,1,0>)
									#break
								#end
							#end
						#else
							// in the current bounce, solve for all values and continue
							#declare DGPASFound = true
							#declare DGPASTemp   = (DGPASNewClock - DGPASTempIT)
							#declare DGPASTempCP = (0.5 * DGPASTempAC * DGPASTemp * DGPASTemp)
							#declare DGPASTempCP = DGPASTempCP + (DGPASTemp * DGPASTempVL)
							#declare DGPASTempCP = DGPASTempCP + DGPASTempSP
							#declare DGPASTempVL = (DGPASTempAC * DGPASTemp) + DGPASTempVL
							#declare DGPASTempCP2 = DGPASTempSP2 + (DGPASTempVL2 * DGPASTemp)
							#declare DGPASTempCP2 = DGPASTempCP2 + (0.5 * DGPASTempAC2 * DGPASTemp * DGPASTemp)
							#declare DGPASTempVL2 = DGPASTempVL2 + (DGPASTemp * DGPASTempAC2)
							#switch (DGPASBounce_Num)
								#case (1) // X-Axis
									#declare DGPASCurrent_Point = DGPASTempCP2
									#declare DGPASCurrent_Point = (DGPASTempCP * <1,0,0>) + (DGPASCurrent_Point * <0,1,1>)
									#declare DGPASCurrent_Velocity = DGPASTempVL2
									#declare DGPASCurrent_Velocity = (DGPASTempVL * <1,0,0>) + (DGPASCurrent_Velocity * <0,1,1>)
								#break
								#case (2) // Y Axis
									#declare DGPASCurrent_Point = DGPASTempCP2
									#declare DGPASCurrent_Point = (DGPASTempCP * <0,1,0>) + (DGPASCurrent_Point*<1,0,1>)
									#declare DGPASCurrent_Velocity = DGPASTempVL2
									#declare DGPASCurrent_Velocity = (DGPASTempVL * <0,1,0>) + (DGPASCurrent_Velocity*<1,0,1>)
								#break
								#case (3) //Z-Axis
									#declare DGPASCurrent_Point = DGPASTempCP2
									#declare DGPASCurrent_Point = (DGPASTempCP * <0,0,1>) + (DGPASCurrent_Point*<1,1,0>)
									#declare DGPASCurrent_Velocity = DGPASTempVL2
									#declare DGPASCurrent_Velocity = (DGPASTempVL * <0,0,1>) + (DGPASCurrent_Velocity*<1,1,0>)
								#break
							#end
						#end
					#end
				#else // Doesn't pass the tests, no bounce possible, make it an accel particle instead
					#declare DGPASCurrent_Point = DGPASStart_Point + (DGPASInitial_Velocity * DGPASTime_In)
					#declare DGPASCurrent_Point = DGPASCurrent_Point + (0.5 * DGPASAcceleration * DGPASTime_In * DGPASTime_In)
					#declare DGPASCurrent_Velocity = DGPASInitial_Velocity + (DGPASAcceleration * DGPASTime_In)
				#end
			#break
		#end // end of particle types

		// Fold the particle
		#if ((DGPASFold_X = true) & !((DGPASCommand_Num = 6) & (DGPASBounce_Num = 1)))
			#declare DGPASTemp  = DGPASCurrent_Point.x
			#declare DGPASFound = false
			#while (DGPASFound = false)
				#if ((DGPASTemp <= DGPASFold_X_Max) & (DGPASTemp >= DGPASFold_X_Min))
					#declare DGPASFound = true
				#else
					#if (DGPASTemp > DGPASFold_X_Max)
						#declare DGPASTemp = DGPASFold_X_Max - (DGPASTemp - DGPASFold_X_Max)
					#else
						#declare DGPASTemp = DGPASFold_X_Min - (DGPASTemp - DGPASFold_X_Min)
					#end
				#end
			#end
			#declare DGPASCurrent_Point = (DGPASCurrent_Point * <0,1,1>) + (DGPASTemp * <1,0,0>)
		#end
		#if ((DGPASFold_Y = true) & !((DGPASCommand_Num = 6) & (DGPASBounce_Num = 2)))
			#declare DGPASTemp  = DGPASCurrent_Point.y
			#declare DGPASFound = false
			#while (DGPASFound = false)
				#if ((DGPASTemp <= DGPASFold_Y_Max) & (DGPASTemp >= DGPASFold_Y_Min))
					#declare DGPASFound = true
				#else
					#if (DGPASTemp > DGPASFold_Y_Max)
						#declare DGPASTemp = DGPASFold_Y_Max - (DGPASTemp - DGPASFold_Y_Max)
					#else
						#declare DGPASTemp = DGPASFold_Y_Min - (DGPASTemp - DGPASFold_Y_Min)
					#end
				#end
			#end
			#declare DGPASCurrent_Point = (DGPASCurrent_Point * <1,0,1>) + (DGPASTemp * <0,1,0>)
		#end
		#if ((DGPASFold_Z = true) & !((DGPASCommand_Num = 6) & (DGPASBounce_Num = 3)))
			#declare DGPASTemp  = DGPASCurrent_Point.z
			#declare DGPASFound = false
			#while (DGPASFound = false)
				#if ((DGPASTemp <= DGPASFold_Z_Max) & (DGPASTemp >= DGPASFold_Z_Min))
					#declare DGPASFound = true
				#else
					#if (DGPASTemp > DGPASFold_Z_Max)
						#declare DGPASTemp = DGPASFold_Z_Max - (DGPASTemp - DGPASFold_Z_Max)
					#else
						#declare DGPASTemp = DGPASFold_Z_Min - (DGPASTemp - DGPASFold_Z_Min)
					#end
				#end
			#end
			#declare DGPASCurrent_Point = (DGPASCurrent_Point * <1,1,0>) + (DGPASTemp * <0,0,1>)
		#end

		// Place the object in the scene if Object_Type = "DECLARED"
		#if (DGPASObject_Num = 1)
			object { DGPASObject translate DGPASCurrent_Point }
		#end
	#end
#end


