// --------------------------------------------------------
// Tutorial file for Dave G's Particle Animation System
//  See DGPAS.PDF for documentation
// --------------------------------------------------------

#include "colors.inc"

camera { location <0, 3, -6> look_at <0, 2, 0> }

light_source { <20, 20, -20> color White }

plane { y, 0 pigment { checker color White color Black } }

#declare DGPASCommand = "RESET"
#include "DGPAS.INC"

#declare DGPASObject = sphere { <0, 0, 0>, .5 pigment { color Blue } }

#declare DGPASCommand          = "VELOCITY_PARTICLE"
#declare DGPASStart_Point      = < 0,0.5, 0>
#declare DGPASInitial_Velocity = < 2,  0, 0>
#declare DGPASTime_Scale       = 5
#declare DGPASFinal_Time       = 5
#declare DGPASFold_X           = true
#declare DGPASFold_X_Min       = -3
#declare DGPASFold_X_Max       = 3
#include "DGPAS.INC"

#declare DGPASCommand          = "ACCEL_PARTICLE"
#declare DGPASStart_Point      = < 0,2.5, 0>
#declare DGPASInitial_Velocity = < 1,  0, 0>
#declare DGPASAcceleration     = < 1,  0, 0>
#include "DGPAS.INC"

