// --------------------------------------------------------
// Tutorial file for Dave G's Particle Animation System
//  See DGPAS.PDF for documentation
// --------------------------------------------------------

#include "colors.inc"

camera { location <0, 6, -8> look_at <0, 4, 0> }

light_source { <20, 20, -20> color White }

plane { y, 0 pigment { checker color White color Black } }

#declare DGPASCommand = "RESET"
#include "DGPAS.INC"

#declare DGPASObject = sphere { <0, 0, 0>, .5 pigment { color Blue } }

#declare DGPASCommand          = "BOUNCE_PARTICLE"
#declare DGPASBounce_Plane     = "Y"
#declare DGPASBounce_Point     = 0.5
#declare DGPASStart_Point      = < -3,  7, 0>
#declare DGPASInitial_Velocity = <  0,  0, 0.3>
#declare DGPASAcceleration     = <0.1, -1, 0>
#declare DGPASTime_Scale       = 12
#declare DGPASFinal_Time       = 12
#declare DGPASResilience       = 0.8
#include "DGPAS.INC"


