// --------------------------------------------------------
// Tutorial file for Dave G's Particle Animation System
//  See DGPAS.PDF for documentation
// --------------------------------------------------------


#include "colors.inc"

camera { location <0, 0, -15> look_at <0, 0, 5> }

light_source { <-6, 4, -20> color Gray50 }
light_source { < 6, -4, -20> color Gray50 }

box { < -8,-5.5,-0.5>, < -9, 5.5,15.5> pigment { color Yellow } }
box { < 8,-5.5,-0.5>, < 9, 5.5,15.5> pigment { color Yellow } }
box { <-9,5.5,-0.5>, < 9,6.5,15.5> pigment { color Yellow } }
box { <-9,-5.5,-0.5>, < 9,-6.5,15.5> pigment { color Yellow } }
box { <-9,-6.5,16.5>, <9,6.5,15.5> pigment { color Yellow } }

#declare DGPASCommand = "RESET"
#include "DGPAS.INC"

#declare DGPASObject = sphere { <0, 0, 0>, 0.5 pigment { color Red } }

#declare DGPASCommand          = "VELOCITY_PARTICLE"
#declare DGPASStart_Point      = <-2,2,3>
#declare DGPASInitial_Velocity = <-0.5, 0.6, 0.2>
#declare DGPASInitial_Time     = 0
#declare DGPASTime_Scale       = 250
#declare DGPASFinal_Time       = 250
#declare DGPASFold_X           = true
#declare DGPASFold_Y           = true
#declare DGPASFold_Z           = true
#declare DGPASFold_X_Min       = -7.5
#declare DGPASFold_X_Max       =  7.5
#declare DGPASFold_Y_Min       = -5.0
#declare DGPASFold_Y_Max       =  5.0
#declare DGPASFold_Z_Min       =  0.0
#declare DGPASFold_Z_Max       = 15.0

#include "DGPAS.INC"

