// --------------------------------------------------------
// Tutorial file for Dave G's TimeLine System
//  See DGTL.PDF for documentation
// --------------------------------------------------------

#include "colors.inc"

camera { location <0, 3, -6> look_at <0, 0, 0> }

light_source { <20, 20, -20> color White }

plane { y, 0 pigment { checker color White color Black } }

#declare DGTLSegment01 = 1
#declare DGTLSegment02 = 1
#declare DGTLSegment03 = 1
#declare DGTLSegment04 = 1

#include "DGTL.INC"

#switch (DGTLCurrent_Segment)
	#case (1)
		sphere { <-2,0.5,-1>, 0.5 pigment { color Green } }
	#break
	#case (2)
		sphere { <-1,0.5,-1>, 0.5 pigment { color Blue } }
	#break
	#case (3)
		sphere { <1,0.5,-1>, 0.5 pigment { color Red } }
	#break
	#case (4)
		sphere { <2,0.5,-1>, 0.5 pigment { color Brown } }
	#break
	#else
		sphere { <0,1,-1>, 1 pigment { color White } }
#end
