// --------------------------------------------------------
// Tutorial file for Dave G's Particle Animation System
//  See DGPAS.PDF for documentation
// --------------------------------------------------------

#include "colors.inc"

camera { location <0, 3, -6> look_at <0, 2, 0> }

light_source { <20, 20, -20> color White }

plane { y, 0 pigment { color Gray50 } }

#declare DGTLSegment01  = 1
#declare DGTLSegment02  = 1
#declare DGTLSegment03  = 1
#declare DGTLSegment04  = 1
#declare DGTLFrames_Per = 10

#include "DGTL.INC"

text {
	ttf "TIMROM.TTF", "   Total Frames", 0.2, 0
	translate <-4,1,1>
	pigment { color Green }
}
text {
	ttf "TIMROM.TTF", str(DGTLFrames,0,1), 0.2, 0
	translate <2.5,1,1>
	pigment { color Red }
}


text {
	ttf "TIMROM.TTF", "Current Frame", 0.2, 0
	translate <-4,2.5,1>
	pigment { color Green }
}

text {
	ttf "TIMROM.TTF", str(DGTLCurrent_Frame,0,1), 0.2, 0
	translate <2.5,2.5,1>
	pigment { color Red }
}

