// OBJECT EXPLODER: SAMPLE FILE 1
// ******************************
// This scene illustrates how adding turbulence to an explosion via the
// "exp_turb" variable affects the Object Exploder output.

// CAMERA AND LIGHTS
   camera {location <5, 10, -15> look_at <0, 0, 0> angle 50}
   light_source {<-10, 0, -50> rgb 1}
   light_source {<20, 40, 10> rgb 1}

// EXPLOSION PARAMETERS
   #declare explode_object = sphere {<0, 0, 0>, 1
      pigment {bozo color_map {[0 rgb <1, 0, 0>] [1 rgb <1, 1, 0>]}}
      finish {phong .3 phong_size 35}}

   #declare particle_texture = texture {
      pigment {bozo color_map {[0 rgb <.5, .2, .2>] [1 rgb <.5, .5, .2>]}}
      finish {phong .2 phong_size 25}}

   #declare explode_clock = .1
   #declare object_hollow = false

// FIRST OBJECT: NO TURBULENCE
   object {#include "Explode.inc" translate <-5, 0, 0>}

// SECOND OBJECT: LOW TURBULENCE
   #declare exp_turb = .1
   object {#include "Explode.inc"}

// THIRD OBJECT: HIGH TURBULENCE
   #declare exp_turb = 1
   object {#include "Explode.inc" translate <5, 0, 0>}
