// OBJECT EXPLODER: BREAKING GLASS ANIMATION
// *****************************************
// This animation shows an empty wineglass being smashed on a tiled
// floor.

// CAMERA AND LIGHTS
   camera {location <-20, 30, -50> look_at <0, 5, 0> angle 40}
   light_source {<30, 150, -150> rgb <.7, .5, .5>}
   light_source {<-50, 300, 100> rgb <.5, .6, .8>}

// SCENE DEFINITIONS
   #declare Glass = union {
      disc {<0, 0, 0>, y, 3}
      cone {<0, 0, 0>, 3, <0, 1, 0>, .5 open}
      cylinder {<0, 1, 0>, <0, 10, 0>, .5 open}
      sphere {<0, 0, 0>, 1
         scale <4, 5, 4> translate <0, 15, 0>
         clipped_by {box {<-4.5, 10, -4.5>, <4.5, 18, 4.5>}}}
      pigment {rgbf <1, 1, 1, .6>}
      finish {specular .6 roughness .05 refraction 1 ior 1.04 caustics 1}}
      
   #declare Tiled = slope_map {
      [0 <0, 1>]   [.05 <1, 1>]  [.05 <1, 0>]
      [.95 <1, 0>] [.95 <1, -1>] [1 <0, -1>]}

// TILED FLOOR
   plane {y, 0
      pigment {checker rgb <1, 1, 1>, rgb <.7, .7, .7> scale 10}
      normal {average normal_map {
         [1 gradient x 1 slope_map {Tiled}]
         [1 gradient z 1 slope_map {Tiled}]}
         scale 10}
      finish {phong .2 phong_size 2}}

   #declare explode_object = object {Glass rotate z * 80 translate <9, 4, 0>}

// THROW WINEGLASS AT THE FLOOR
   #switch (clock)
      #range (0, .4)
         object {explode_object translate <6, 20, 0> * (.4 - clock) * 2.5}
         #break

// EXPLOSION PARAMETERS
   #else
      #declare explode_clock = (clock - .4) * 1.7 * 4
      #declare object_corner1 = <-9, 0, -4>
      #declare object_corner2 = <9, 8, 4>
      #declare particle_res = <4, 3, 2>
      #declare exp_location = <0, 4, 0>
      #declare exp_strength = 5
      #declare exp_gravity = 5
      #declare exp_spin = .5
      #declare ground_plane = true
      #declare ground_reflection = 0
      #declare exp_turb = 1
      #declare scale_turb = .6
      #declare rotate_turb = .4
      #declare vel_turb = .5
      #declare dir_turb = .1
      #declare spin_turb = .4

// CREATE SMASHING WINEGLASS
      #include "Explode.inc"
   #end
