// OBJECT EXPLODER: EXPLODING MOON ANIMATION
// *****************************************
// This animation shows a moon exploding into a number of asteroids.
// Note: to preserve the starfield background this animation should NOT
//       be rendered with anti-aliasing enabled.

// CAMERA AND LIGHTS
   camera {location <0, 0, -7> look_at <0, 0, 0>}
   light_source {<10, 10, -50> rgb <1, 1, 1>}

// BACKGROUND
   sky_sphere {pigment {granite color_map {
      [0 rgb <.5, .7, 1>] [.1 rgb <0, 0, 0>]
      [.8 rgb <0, 0, 0>] [1 rgb <1, 1, 1>]}
      scale .01}}

// SCENE DEFINITIONS
   #declare Moon = sphere {<0, 0, 0>, 1
      pigment {bozo color_map {[0 rgb .4] [1 rgb .8]} scale .4}
      normal {bump_map {gif "map.gif" map_type 1 interpolate 2} bump_size 3}}

// ROTATE MOON FOR FIRST PART OF ANIMATION
   #switch (clock)
      #range (0, .25)
         object {Moon rotate y * clock * 120 rotate z * -20}
         #break

// EXPLOSION PARAMETERS
   #else
      #declare explode_clock = (clock - .25) * 4 / 3
      #declare explode_object = object {Moon rotate <0, 30, -20>}
      #declare object_centre = <0, 0, 0>
      #declare object_size = <2, 2, 2>
      #declare object_hollow = false
      #declare particle_object = sphere {<0,0,0>, .75}
      #declare particle_res = <4, 4, 4>
      #declare particle_texture = texture {
         pigment {bozo color_map {[0 rgb .4] [1 rgb .8]} scale .3}
         normal {bumps 2 scale .1}}
      #declare exp_location = <0, 0, 0>
      #declare exp_strength = 8
      #declare exp_spin = 1
      #declare exp_seed = 87632
      #declare exp_turb = 1
      #declare scale_turb = .5
      #declare rotate_turb = 1
      #declare vel_turb = .3
      #declare dir_turb = .4
      #declare spin_turb = .3

// CREATE EXPLODING MOON
      #include "Explode.inc"

// CREATE FIREBALL
      #declare FClock = pow (explode_clock, .8)
      disc {<0,0,0>, z, 1.5
         pigment {onion color_map {
            [0 rgbt <1 - (FClock * .5), 1 - (FClock * .5), .5, .4 + (FClock * .6)>]
            [.25 rgbt <1 - (FClock * .5), .5, FClock * .5, 1>]}
            scale 3
            warp {turbulence -FClock * .5 octaves 3 lambda 3}
            rotate FClock*30}
         finish {ambient 3 diffuse 0}
         no_shadow hollow
         scale 1 + (FClock * 8)}
   #end
