// OBJECT EXPLODER: EXPLODING TEAPOT ANIMATION
// *******************************************
// This animation shows a teapot exploding on a wooden table.

// CAMERA AND LIGHTS
   camera {location <5, 5, -15> look_at <0, 1, 0> angle 35}
   light_source {<5, 5, -20> rgb <1, 1, 1>}
   light_source {<-5, 20, 5> rgb <1, 1, 1>}

// SCENE DEFINITIONS
   #declare TeaPot = union {
      sphere {<0, 1, 0>, 1 scale <1.2, 1, 1.2>}
      sphere {<0, 0, 0>, 1 scale <.7, .2, .7> translate <0, .2, 0>}
      sphere {<0, 0, 0>, 1 scale <.8, .2, .8> translate <0, 1.8, 0>}
      sphere {<0, 2.1, 0>, .15}
      torus {.4, .1 rotate x * 90 translate <1.3, 1, 0>}
      cone {<-.8, .8, 0>, .3, <-1.8, 1.5, 0>, .1 open}
      pigment {rgb <.4, .8, 1>}
      finish {phong .4 phong_size 7}}

// WOODEN TABLE
   disc {<0, 0, 0>, y, 6
      pigment {onion pigment_map {
         [.3 wood color_map {[0 rgb <.8, .6, .4>] [1 rgb <.6, .4, .2>]}
            warp {turbulence .3 octaves 3 lambda 3}
            scale .2 rotate <0, 30, 0> translate x * 10
            scale 1 / 6]
         [1 rgb 0]}
         scale 6}
      finish {phong .3 phong_size 10 reflection .2 ambient .6 diffuse .4}}

// SHAKE TEAPOT FOR FIRST PART OF ANIMATION
   #switch (clock)
      #range (0, .5)
         #declare MClock = pow (clock * 2, 2)
         object {TeaPot translate vrotate (x * MClock * .2, y * 360 * MClock * 20)}
         #break

// EXPLOSION PARAMETERS
   #else
      #declare explode_clock = (clock - .5) * 7
      #declare explode_object = TeaPot
      #declare object_corner1 = <-1.9, 0, -1.2>
      #declare object_corner2 = <1.8, 2.3, 1.2>
      #declare object_hollow = true
      #declare particle_res = <5, 3, 3>
      #declare exp_location = <0, -2, 0>
      #declare exp_strength = 4
      #declare exp_gravity = 10
      #declare exp_spin = .5
      #declare exp_seed = 87632
      #declare ground_plane = true
      #declare ground_reflection = .6
      #declare max_bounces = 1
      #declare exp_turb = 1
      #declare scale_turb = 1
      #declare rotate_turb = 1
      #declare vel_turb = .3
      #declare dir_turb = .1
      #declare spin_turb = .5

// CREATE EXPLODING TEAPOT
      #include "Explode.inc"
   #end
