// LENS FLARE EXAMPLE 12
// *********************

// DEFINE CAMERA POSITION VECTORS
   #declare camera_location = <15, -10, 0>
   #declare camera_look_at = <15, -10, 1>
   camera {location camera_location look_at camera_look_at}

// CREATE ROTATING PLANET
   sphere {<0, 0, 0>, 10
      pigment {bozo color_map {
         [0 rgb <.2, .3, .6>]
         [1 rgb <.6, .8, 1>]}
         scale <5, 1, 5> turbulence .3 octaves 3 lambda 7}
      rotate <0, clock * -180, -45>
      translate <0, 0, 25>}

// CREATE SECONDARY LIGHT SOURCE
   light_source {<0,0,-100> rgb .2}

// CREATE STAR FIELD BACKGROUND
   sky_sphere {pigment {
      granite color_map {
         [.8 rgb 0] [1 rgb 1]}
      turbulence 1 scale .01}}

// CALCULATE ADJUSTED CLOCK VALUE FOR LENS FLARE
   #declare flare_clock = clock - .1

// CALCULATE LIGHT SOURCE AND LENS FLARE POSITIONS
   #declare flare_position = vrotate (<0, 0, 40>,
      <20, 90, 0> * flare_clock)

// CREATE PRIMARY (VISIBLE) LIGHT SOURCE
   light_source {flare_position rgb <1, 1, 1>}

// DETERMINE VISIBILITY OF LENS FLARE
   #switch (flare_clock)

// MAKE INVISIBLE FOR FIRST PART OF ANIMATION
   #range (-1, .1)
   #declare flare_brightness = 0
   #break

// INCREASE QUICKLY FOR NEXT PART OF ANIMATION
   #range (.1, .2)
   #declare flare_brightness = (flare_clock - .1) * 10 * 1.5
   #break

// USE CONSTANT BRIGHTNESS FOR REST OF ANIMATION
   #else
   #declare flare_brightness = 1.5
   #end

// CREATE LENS FLARE
   #include "LensFlar.inc"
