{   _______________________________________________________________________
  /                                                                         \
 |  Little graphics unit. Code again by Inopia. Have phun! PS: The little    |
 |  KickPcx2Screen thingie totally ignores the header, so don't be surprised |
 |  when it won't load your 1280x1024x16m PCX files......                    |
  \ _______________________________________________________________________ /
}
Unit GRUnit;

Interface

Uses VarUnit;

Procedure Set320X200;
Procedure SetText;
Procedure SetRGBColor(NR,R,G,B:BYTE);
Procedure MyMove(Var Src,Dst;Bigness:Word);
Procedure MyFill(Var Dst;Bigness:Word;color:byte);
Procedure Polygon(X1,Y1,X2,Y2,X3,Y3:integer;txt:vert4;c:integer);
Procedure Sline(x1,x2,y,tx1,tx2,ty1,ty2,c:integer);
Procedure KickPcx2Screen(Image:Pointer;var page);
Procedure Place_Polys;

Implementation

Procedure Set320X200; assembler;
Asm MOV AX,013H; INT 10h; End;

Procedure SetText; assembler;
Asm MOV AX,03h; INT 10h; End;

Procedure SetRGBColor(NR,R,G,B:BYTE); assembler;
asm
  MOV DX,03C8h
  MOV AL,NR
  OUT DX,al
  INC DX
  MOV AL,R
  OUT DX,AL
  MOV AL,G
  OUT DX,AL
  MOV AL,B
  OUT DX,AL
end;

Procedure MyMove(Var Src,Dst;Bigness:Word); AssEmbler;
Asm
  PUSH DS
  LDS SI,SRC
  LES DI,DST
  MOV CX,BIGNESS
  SHR CX,2
  DB  066h
  REP MOVSW
  POP DS
End;

Procedure MyFill(Var Dst;Bigness:Word;color:byte); AssEmbler;
Asm
  LES DI,DST
  MOV AL,COLOR
  MOV AH,AL
  PUSH AX
  PUSH AX
  DB  66h
  POP AX
  MOV CX,BIGNESS
  SHR CX,2
  DB  066h
  REP STOSW
End;

Procedure Sline(X1,X2,Y,TX1,TX2,TY1,TY2,C:Integer);
Var SX,SY,I : Integer;
Begin
  If X2=X1 Then Exit;
  If X1>X2 Then Begin
    I := X1;
    X1 := X2;
    X2 := I;
    I := TX1;
    TX1 := TX2;
    TX2 := I;
    I := TY1;
    TY1 := TY2;
    TY2 := I;
  End;
  SX := ((TX2-TX1) SHL 7) div (X2-X1);
  SY := ((TY2-TY1) SHL 7) div (X2-X1);
  If x1<1 then x1 := 1; If x1>318 then x1 := 318;
  If x2<1 then x2 := 1; If x2>318 then x2 := 318;
  For I := 0 to (X2-X1)+1 do buffer^[Y*320+I+X1] := emap^[(TY1+((I*SY) SHR 7))*256+TX1+((I*SX) SHR 7)]+c;
End;

Procedure KickPcx2Screen(Image:Pointer;var page);
Var PS,PO,s,o    : Word;
    ScreenCount  : longint;
    Data,Count,I : Byte;
    ImageCnt     : Word;
    palette      : array[0..255,0..2] of byte;
begin
  PS := Seg(Image^); PO := Ofs(Image^)+128;
  S := Seg(page); O := Ofs(page);
  Screencount := 0; ImageCnt := 0;
  repeat
    I := Mem[PS:PO]; Inc(PO);
    if I and 192 = 192 then Begin
      Count := I and 63;
      I := Mem[PS:PO]; Inc(PO);
      Data := I;
    End Else Begin Data := I; Count := 1; End;
    for I := 1 to Count do Begin
      Mem[S:O+ScreenCount] := data;
      Inc(ScreenCount);
    End;
  Until ScreenCount > 65534;
  Move(Mem[PS:PO+1],Palette,Sizeof(Palette));
  For I := 0 to 255 do Begin
    Palette[I,0] := Palette[I,0] div 4;
    Palette[I,1] := Palette[I,1] div 4;
    Palette[I,2] := Palette[I,2] div 4;
  End;
  for i := 0 to 255 do setrgbcolor(i,palette[i,0],palette[i,1],palette[i,2]);
end;


Procedure Polygon(X1,Y1,X2,Y2,X3,Y3:integer;txt:vert4;c:integer);
Var XValues                 : Array[0..199,0..1] of Integer;
    TXValues                : Array[0..199,0..1] of Integer;
    TYValues                : Array[0..199,0..1] of Integer;
    I, Y, Min, Max          : Integer;
    Step                    : ShortInt;
    Side, Number            : Byte;
    TX, TY, SX, SY,K,X      : Integer;
    TZ, SZ                  : Integer;
    TTX,TTY,STX,STY         : Integer;
    SX1,SX2,SX3,SY1,SY2,SY3 : Longint;
begin
  SX1 := TXT.VN[0].XT; SY1 := TXT.VN[0].YT;
  SX2 := TXT.VN[1].XT; SY2 := TXT.VN[1].YT;
  SX3 := TXT.VN[2].XT; SY3 := TXT.VN[2].YT;
  If (X1<0) and (X2<0) and (X3<0) then exit;
  If (X1>319) and (X2>319) and (X3>319) then exit;
  If (Y1<0) and (Y2<0) and (Y3<0) then exit;
  If (Y1>199) and (Y2>199) and (Y3>199) then exit;
  Min := Y1; if Y2 < Min then Min := Y2; if Y3 < Min then Min := Y3;
  Max := Y1; if Y2 > Max then Max := Y2; if Y3 > Max then Max := Y3;
  for Number := 0 to 3 do Begin
    if Number = 0 then Begin TX := X1; TY := Y1; TTX := SX1; TTY := SY1; SX := X2; SY := Y2; STX := SX2; STY := SY2; end;
    if Number = 1 then Begin TX := X2; TY := Y2; TTX := SX2; TTY := SY2; SX := X3; SY := Y3; STX := SX3; STY := SY3; end;
    if Number = 2 then Begin TX := X3; TY := Y3; TTX := SX3; TTY := SY3; SX := X1; SY := Y1; STX := SX1; STY := SY1; end;
    Step := Byte(TY<SY)*2-1;
    Y := TY; Side := Byte(TY<SY);
    if TY <> SY then Begin
      Repeat
        If (Y>0) and (Y<199) then begin
          XValues[Y,Side] := Integer(SX-TX)*(Y-TY) div (SY-TY)+TX;;
          TXValues[Y,Side] := Integer(STX-TTX)*(Y-TY) div (SY-TY)+TTX;
          TYValues[Y,Side] := Integer(STY-TTY)*(Y-TY) div (SY-TY)+TTY;
        end;
        Inc(Y,Step);
      Until Y = SY+Step;
    End Else If (Y>0) and (Y<199) then Begin
      XValues[Y,Side] := tx;
      TXValues[Y,Side] := TTX;
      TYValues[Y,Side] := TTY;
    End;
  End;
  for I := Min to Max-1 do if (i>0) and (i<199) then
    Sline(XValues[I,0],XValues[I,1],I,TXValues[I,0],TXValues[I,1],TYValues[I,0],TYValues[I,1],c);
End;

Procedure Place_Polys;
Begin
  for i := faces downto 0 do {if Fshow[sortedz[i]] then}
    Polygon(x[face[sortedz[i],0]],y[face[sortedz[i],0]],
            x[face[sortedz[i],1]],y[face[sortedz[i],1]],
            x[face[sortedz[i],2]],y[face[sortedz[i],2]],
            vns[sortedz[i]],0);
End;

Begin
End.