/*	
	POB-File-Format by Thomas Baier April/97


	Description:
	Defines some add pob tags and needed datatypes

	History:
	01.04.97	Version 0.8	First Version, all things implemented, 
					rarly tested

	Comments:

	To Do List:

*/


#define POB_FILESECTION_TAG 		(0x5050)

#define POB_POVRAYSECTION_TAG 		(0x5060)
#define POB_GLOBALSECTION_TAG 		(0x1000)
#define POB_ENVIRONMENTSECTION_TAG 	(0x1100)
#define POB_CAMERASECTION_TAG 		(0x1200)

#define POB_MATERIALSECTION_TAG 	(0x2300)

#define POB_OBJECTSECTION_TAG 		(0x3000)

#define TEXTUREREF_POB_TOKEN		(0x4001)
#define PIGMENTREF_POB_TOKEN		(0x4002)
#define NORMALREF_POB_TOKEN		(0x4003)
#define FINISHREF_POB_TOKEN		(0x4004)
#define HALOREF_POB_TOKEN		(0x4005)

#define SIMPLETEXTURE_POB_TOKEN		(0x4010)
#define LAYEREDTEXTURE_POB_TOKEN	(0x4011)
#define MATERIAL_MAPTEXTURE_POB_TOKEN	(0x4012)
#define CHECKERTEXTURE_POB_TOKEN	(0x4013)
#define BRICKTEXTURE_POB_TOKEN		(0x4014)
#define HEXAGONTEXTURE_POB_TOKEN	(0x4015)
#define PATTERNTEXTURE_POB_TOKEN	(0x4016)

#define SIMPLEPIGMENT_POB_TOKEN		(0x4020)
#define CHECKERPIGMENT_POB_TOKEN	(0x4021)
#define BRICKPIGMENT_POB_TOKEN		(0x4022)
#define HEXAGONPIGMENT_POB_TOKEN	(0x4023)
#define BITMAPPIGMENT_POB_TOKEN		(0x4024)
#define PATTERNPIGMENT_POB_TOKEN	(0x4025)

#define SIMPLENORMAL_POB_TOKEN		(0x4030)
#define CHECKERNORMAL_POB_TOKEN		(0x4031)
#define BRICKNORMAL_POB_TOKEN		(0x4032)
#define HEXAGONNORMAL_POB_TOKEN		(0x4033)
#define BITMAPNORMAL_POB_TOKEN		(0x4034)
#define PATTERNNORMAL_POB_TOKEN		(0x4035)

#define SIMPLEFINISH_POB_TOKEN		(0x4040)
#define SIMPLEHALO_POB_TOKEN		(0x4050)

#define PATTERN_MOD_POB_TOKEN		(0x4060)
#define WAVE_TYPE_POB_TOKEN		(0x4061)
#define CLASSIC_TURB_WARP_POB_TOKEN	(0x4062)
#define REPEAT_WARP_POB_TOKEN		(0x4063)
#define BLACK_HOLE_WARP_POB_TOKEN	(0x4064)

#define HALO_NO_HALO_POB_TOKEN		(0x4065)
#define MAPVALUE_POB_TOKEN		(0x4066)


#define FLAGS_POB_TOKEN			(0x4080)
#define BLOBCOMPONENT_POB_TOKEN		(0x4100)
#define BLOBMOD_POB_TOKEN		(0x4110)
#define BLOBSPHERE_POB_TOKEN		(0x4120)
#define BLOBCYLINDER_POB_TOKEN		(0x4130)
#define GROUP_POB_TOKEN			(0x4200)
#define GROUPMOD_POB_TOKEN		(0x4210)
#define MESHDATA_POB_TOKEN		(0x4300)
#define MESHMOD_POB_TOKEN		(0x4310)

#define POB_MODELLERSECTION_TAG 	(0x5070)


/* light types */

#define POB_POINT_SOURCE       (1)
#define POB_SPOT_SOURCE        (2)
#define POB_FILL_LIGHT_SOURCE  (3)
#define POB_CYLINDER_SOURCE    (4)


/* pigment map types */
#define POB_PIGMENT_COLORMAP 	(0)
#define POB_PIGMENT_PIGMENTMAP 	(1)
#define POB_PIGMENT_NOMAP 	(3)

/* normal map types */
#define POB_NORMAL_NOMAP 	(0)
#define POB_NORMAL_NORMALMAP 	(1)
#define POB_NORMAL_SLOPEMAP 	(2)


typedef unsigned char 	P_BYTE;
typedef unsigned short 	P_WORD;
typedef unsigned long 	P_DWORD;
typedef double 		P_DOUBLE;

typedef P_DOUBLE 	P_DVECTOR[3];
typedef P_DOUBLE P_MATRIX [4][4];


typedef struct 
{
	P_DWORD	start;
	P_DWORD	end;
	P_DWORD	length;
	P_WORD  tag;
} CHUNK;

char *get_stoken_str(unsigned int stoken_number);
