#include <conio.h>
#include <stdlib.h>

#include <pr.h>

#ifdef __3DFX__
#include <pr3dfx.h>
#include <glide.h>
#endif

#ifdef WIN32
#include <winutil.h>
#endif


/* Power Render Example 5

   Description:  Same as example 4, but uses two intersecting cubes with
                 zbuffering.
                 3Dfx only!
*/

                                             
PR_VIEWPORT viewport;                  /* Our viewport structure */
PR_CAMERA *camera;                     /* One camera */
PR_OBJECT *object_shape;               /* The shape loaded */
PR_ENTITY *cube1;                      /* First cube */
PR_ENTITY *cube2;                      /* Second cube */
PR_LIGHTLIST userlights;               /* Holds a list of lights */
PR_DWORD  device=0;                    /* Display device */
PR_DWORD animation_count;

void animation_timer (void)
{
 animation_count++;
}


void InitializeDevices (void)
{
  /* Attempt to find the device */

  #ifdef __3DFX__
  if ((device == DEVICE_3DFX) || (device == DEVICE_ANY))
    device = PR_Detect3Dfx ();
  #endif

  /* Attempt to initialize the device */
  #ifdef __3DFX__
  if (device == DEVICE_3DFX)
    {
     PR_Initialize3Dfx ();
     atexit (PR_Shutdown3Dfx);
    }
  else
    {
     printf ("3Dfx card not detected\n");
     exit (1);
    }
  #else
     wsetmode (3);
     printf ("This demo requires a 3Dfx card. \n");
     exit (1);
  #endif

}



void main (void)
{
PR_DWORD vwidth, vheight;
PR_REAL cenx, ceny, cenz;
PR_UDWORD BLACK;                       /* Color index/value for black */
PR_DWORD move_count;

  PR_Initialize (1000);                /* Maximum 1000 triangles per frame */

  device = DEVICE_3DFX;

  InitializeDevices ();

  PR_AllocMaterials (32);              /* Allocate the materials, */
  PR_AllocTextures (32);               /* textures, */
  PR_AllocShadeTables (2);             /* and shade tables */

  vwidth = PR_VideoModes[0].width;     /* Initialize the video mode */
  vheight = PR_VideoModes[0].height;
  PR_SetMode (vwidth, vheight, 60);

  PR_OpenViewport (&viewport, 0, 0, vwidth-1, vheight-1, VIEW_PLAIN);
  PR_SetViewport (&viewport);          /* Open a full screen viewport */

  /* Load the object */
  PR_SetTexturePath ("..\\data\\");
  PR_SetTablePath ("..\\data\\");
  object_shape = PR_LoadPRO ("..\\data\\cube3.pro", LOAD_NORMAL);
  PR_CenterObject (object_shape, &cenx, &ceny, &cenz);

  /* Create cube entities */
  cube1 = PR_CreateEntity (object_shape, "Cube 1");
  cube2 = PR_CreateEntity (object_shape, "Cube 2");
  PR_PositionEntity (cube1, -10, 0, -2);
  PR_PositionEntity (cube2, 10, 0, 0);

  /* Initialize the camera */
  camera = PR_AllocCamera ();
  PR_InitializeCamera (camera);
  PR_PositionCameraSource (camera, 0, 0, 400);
  PR_PositionCameraTarget (camera, 0, 0, 0);
  PR_SetCameraMode (camera, CAMFLAG_AIM_TARGET); 
  PR_SetActiveCamera (camera);

 /* Initialize the light */
  PR_AllocLights (&scenelights, 3);
  PR_AllocLights (&userlights, 3);
  PR_SetLightPosition (&userlights, 0, 0, 0, 400);
  PR_SetLightOn (&userlights, 0);
  PR_SetLightType (&userlights, 0, DIRECTIONAL_LIGHT);
  PR_SetLightColor (&userlights, 0, 1.0, 0.0, 0.0);
  PR_SetLightStrength (&userlights, 0, 1.0);

  PR_SetLightPosition (&userlights, 1, 0, 500, 400);
  PR_SetLightOn (&userlights, 1);
  PR_SetLightType (&userlights, 1, DIRECTIONAL_LIGHT);
  PR_SetLightColor (&userlights, 1, 0.0, 0.0, 1.0);
  PR_SetLightStrength (&userlights, 1, 1.0);

  PR_SetLightPosition (&userlights, 2, -500, 200, 400);
  PR_SetLightOn (&userlights, 2);
  PR_SetLightType (&userlights, 2, DIRECTIONAL_LIGHT);
  PR_SetLightColor (&userlights, 2, 0.0, 1.0, 0.0);
  PR_SetLightStrength (&userlights, 2, 1.0);
  userlights.NumLights = 3;     /* This sets how many lights are actually used */


  PR_OpenScreen (PR_BACKBUFFER);
  BLACK = PRGFX_MakeColor (0, 0, 0);

  installkbd ();
  animation_count = 0;
  winittimer ();
  wstarttimer (animation_timer, TICKS (60));

  /* main program loop */
  while (!kbdon[KEY_ESC])
    {
     #ifdef WIN32
       UpdateMessages ();
     #endif	 

     PR_NewFrame ();                   /* Begin a new frame */


     PRGFX_SetColor (BLACK);
     PRGFX_ClearScreen ();             /* Clear the last frame */

     PR_TransformLights (&userlights);

     move_count = animation_count;
     animation_count = 0;

     PR_RotateEntity (cube1, -1.2f * move_count,
                             0.15f * move_count,
                             -0.2f * move_count);  /* Rotate the entity */
     PR_TransformEntity (cube1);       /* Transform the entity */
     PR_RenderEntity (cube1);          /* Render the entity */

     PR_RotateEntity (cube2, 0.15f * move_count,
                             -1.2f * move_count,
                             0.7f * move_count);  /* Rotate the entity */

     PR_TransformEntity (cube2);       /* Transform the entity */
     PR_RenderEntity (cube2);          /* Render the entity */

     PR_RenderFrame ();                /* Draw the scene */

     PR_Flip (1);                      /* Show the background page */
    }

  /* Free all allocated memory */
  PR_FreeCamera (camera);
  PR_FreeEntity (cube1);
  PR_FreeEntity (cube2);
  PR_FreeObject (object_shape);
  PR_CloseViewport (&viewport);
  PR_DeleteAllShadeTables ();
  PR_DeleteAllTextures ();
  PR_DeleteAllMaterials ();
  PR_ShutDown ();

  uninstallkbd ();
  wstoptimer ();
  wdonetimer ();

#ifndef WIN32
  wsetmode (3);                        /* Go back to text mode */
#endif

}


