#include <conio.h>
#include <stdlib.h>

#include <pr.h>

#ifdef __3DFX__
#include <pr3dfx.h>
#include <glide.h>
#endif

#ifdef WIN32
#include <winutil.h>
#endif


/* Power Render Example 6

   Description:  Demonstrates mipmapping.
*/

                                             
PR_VIEWPORT viewport;                  /* Our viewport structure */
PR_CAMERA *camera;                     /* One camera */
PR_OBJECT *object_shape;               /* The shape loaded */
PR_ENTITY *entity;                     /* A single entity of the shape */
PR_DWORD  device=0;                    /* Display device */


void InitializeDevices (void)
{
  /* Attempt to find the device */

  #ifdef __3DFX__
  if ((device == DEVICE_3DFX) || (device == DEVICE_ANY))
    device = PR_Detect3Dfx ();
  #endif

#if !defined (MSGLIDE) && !defined (WTGLIDE)
  if ((device == DEVICE_SVGA) || (device == DEVICE_ANY))
    device = PR_DetectSVGA ();   

  if ((device == DEVICE_VGA) || (device == DEVICE_ANY))
    device = PR_DetectVGA ();   
#endif

  /* Attempt to initialize the device */
  #ifdef __3DFX__
  if (device == DEVICE_3DFX)
    {
     PR_Initialize3Dfx ();
     atexit (PR_Shutdown3Dfx);
    }
  #endif

#if !defined (MSGLIDE) && !defined (WTGLIDE)
  if (device == DEVICE_SVGA)
    {
     PR_InitializeSVGA ();
     atexit (PR_ShutdownSVGA);
    }
  else if (device == DEVICE_VGA)
    {
     PR_InitializeVGA ();
    }
#endif
}


#if defined (MSDD) || defined (WTDD)
void PR_RestoreAll (void)
{
HRESULT ddrval;

 ddrval = IDirectDrawSurface2_Restore (wgtpdds);

 if (ddrval != DD_OK)
   return;

  PR_LostSurface = 0;
}
#endif





void main (int argc, char *argv[])
{
PR_DWORD vwidth, vheight;
PR_REAL cenx, ceny, cenz;
PR_UDWORD BLACK;                       /* Color index/value for black */

#if defined (MSGLIDE) || defined (WTGLIDE)
  device = 'y';
#else
  #ifdef __3DFX__
  printf ("Use 3Dfx? (y/n)\n");
  device = getch ();
  #endif
#endif

  PR_Initialize (1000);                /* Maximum 1000 triangles per frame */

  if (device == 'y' || device == 'Y')
    device = DEVICE_3DFX;
  else
    device = DEVICE_SVGA;

  InitializeDevices ();

  PR_AllocMaterials (32);              /* Allocate the materials, */
  PR_AllocTextures (32);               /* textures, */
  PR_AllocShadeTables (2);             /* and shade tables */

  if (device != DEVICE_3DFX)
    {
     PR_SetMipMapState (TRUE);
     PR_SetMipMapShrink (TRUE);
     PR_SetMipMapDepth (MIP_LEVEL1, 300);
     PR_SetMipMapDepth (MIP_LEVEL2, 600);
     PR_SetMipMapDepth (MIP_LEVEL3, 900);
     PR_SetMipMapDepth (MIP_LEVEL4, 1200);
    }
  else
    PR_Settings.HardwareMipmaps = MIPMAP_ALL_LEVELS;


  vwidth = PR_VideoModes[0].width;     /* Initialize the video mode */
  vheight = PR_VideoModes[0].height;
  PR_SetMode (vwidth, vheight, 60);

  PR_OpenViewport (&viewport, 0, 0, vwidth-1, vheight-1, VIEW_PLAIN);
  PR_SetViewport (&viewport);          /* Open a full screen viewport */

  /* Load the object */
  PR_SetTexturePath ("..\\data\\");
  object_shape = PR_LoadPRO ("..\\data\\cubemip.pro", LOAD_NORMAL);
  PR_CenterObject (object_shape, &cenx, &ceny, &cenz);

#if !defined (MSGLIDE) && !defined (WTGLIDE)
  /* Set the palette from the textures loaded */
  wsetpalette (0, 255, global_palette);
#endif

  /* Create the main entity */
  entity = PR_CreateEntity (object_shape, "TEST ENTITY");


  camera = PR_AllocCamera ();          /* Initialize the camera */
  PR_InitializeCamera (camera);
  PR_PositionCameraSource (camera, 0, 0, 400);
  PR_PositionCameraTarget (camera, 0, 0, 0);
  PR_SetCameraMode (camera, CAMFLAG_AIM_TARGET); 
  PR_SetActiveCamera (camera);

  PR_OpenScreen (PR_BACKBUFFER);
  BLACK = PRGFX_MakeColor (0, 0, 0);

  installkbd ();

  /* main program loop */
  while (!kbdon[KEY_ESC])
    {
     #ifdef WIN32
       UpdateMessages ();
     #endif

     #if defined (MSDD) || defined (WTDD)
       if (PR_LostSurface)
         PR_RestoreAll ();
     #endif

     PR_OpenScreen (PR_BACKBUFFER);
     PR_NewFrame ();                   /* Begin a new frame */

     PRGFX_SetColor (BLACK);
     PRGFX_ClearScreen ();             /* Clear the last frame */

     if (kbdon[KEY_UP])
       PR_MoveEntity (entity, 0, 0, 10);

     if (kbdon[KEY_DOWN])
       PR_MoveEntity (entity, 0, 0, -10);


     PR_RotateEntity (entity, 0, 0.2, 0.1);/* Rotate the entity */
     PR_TransformEntity (entity);      /* Transform the entity */
     PR_RenderEntity (entity);         /* Render the entity */

     PR_RenderFrame ();                /* Draw the scene */

     PR_Flip (1);                      /* Show the background page */
    }

  /* Free all allocated memory */
  PR_FreeCamera (camera);
  PR_FreeEntity (entity);
  PR_FreeObject (object_shape);
  PR_CloseViewport (&viewport);
  PR_DeleteAllShadeTables ();
  PR_DeleteAllTextures ();
  PR_DeleteAllMaterials ();
  PR_ShutDown ();

  uninstallkbd ();

#ifndef WIN32
  wsetmode (3);                        /* Go back to text mode */
#endif
}

