/* Power Render Segment Interface */

#ifndef _PRSEG_
#define _PRSEG_

#ifdef __cplusplus
  extern "C" {
#endif


void PR_AddChildSegment (PR_SEGMENT *first, PR_SEGMENT *next);
/* -----------------------------------------------------------------------
   Function:   PR_AddChildSegment
   Purpose:    Adds a segment to the end of the children list
   Parameters: first - parent segment
               next - segment to add
   Return:     None
   ----------------------------------------------------------------------- */


PR_SEGMENT *PR_AllocSegment (void);
/* -----------------------------------------------------------------------
   Function:   PR_AllocSegment
   Purpose:    Allocates space for a segment
   Parameters: None
   Return:     Pointer to the new segment
   ----------------------------------------------------------------------- */


void PR_DeselectChildren (PR_ENTITY *entity, PR_DWORD segnum);
/* -----------------------------------------------------------------------
   Function:   PR_DeselectChildren
   Purpose:    Deselects the children of a segment
   Parameters: entity - Entity containing the segment
               segnum - Segment number to deselect 
   Return:     None
   ----------------------------------------------------------------------- */


void PR_DeselectSegment (PR_ENTITY *entity, PR_DWORD segnum);
/* -----------------------------------------------------------------------
   Function:   PR_DeselectSegment
   Purpose:    Deselects a segment
   Parameters: entity - Entity containing the segment
               segnum - Segment number to deselect 
   Return:     None
   ----------------------------------------------------------------------- */


PR_SEGMENT *PR_FindSegment (PR_ENTITY *entity, char *name);
/* -----------------------------------------------------------------------
   Function:   PR_FindSegment
   Purpose:    Finds a segment given its name
   Parameters: entity - Entity containing the segment
               name - Name of the segment
   Return:     Pointer to the segment within the shape definition
   ----------------------------------------------------------------------- */


void PR_FreeSegment (PR_SEGMENT *seg);
/* -----------------------------------------------------------------------
   Function:   PR_FreeSegment
   Purpose:    Frees a segment
   Parameters: seg - Pointer to the segment to free
   Return:     None
   ----------------------------------------------------------------------- */


void PR_MoveSegment (PR_ENTITY *entity, PR_DWORD segnum,
                     PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_MoveSegment
   Purpose:    Moves the position of an segment, in world space relative to
               its previous position
   Parameters: entity - Entity containing the segment
               segnum - Segment number
               x,y,z - Amount to move
   Return:     None
   ----------------------------------------------------------------------- */


void PR_PositionSegment (PR_ENTITY *entity, PR_DWORD segnum,
                     PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_PositionSegment
   Purpose:    Sets the position of a segment relative to the center of
               the entity
   Parameters: entity - Entity containing the segment
               segnum - Segment number
               x,y,z  - Relative distance from original position
   Return:     None
   ----------------------------------------------------------------------- */



void PR_RemoveChildSegment (PR_SEGMENT *first, PR_SEGMENT *next);
/* -----------------------------------------------------------------------
   Function:   PR_RemoveChildSegment
   Purpose:    Removes a segment from the children list
   Parameters: first - Pointer to the previous segment
               next  - Pointer to the segment to remove from the list 
   Return:     None
   ----------------------------------------------------------------------- */


void PR_RotateSegment (PR_ENTITY *entity, PR_DWORD segnum,
                       PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_RotateSegment
   Purpose:    Rotates a segment relative to its current position
   Parameters: entity - Entity containing the segment
               segnum - Segment number to rotate
               x,y,z  - Rotation amount in degrees 
   Return:     None
   ----------------------------------------------------------------------- */


void PR_RotateSegmentAbs (PR_ENTITY *entity, PR_DWORD segnum,
                          PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_RotateSegment
   Purpose:    Sets the absolute rotation of a segment 
   Parameters: entity - Entity containing the segment
               segnum - Segment number to rotate
               x,y,z  - Rotation amount in degrees 
   Return:     None
   ----------------------------------------------------------------------- */


void PR_ScaleSegmentAbs (PR_ENTITY *entity, PR_DWORD segnum,
                         PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_ScaleSegmentAbs
   Purpose:    Scales a segment
   Parameters: entity - Entity containing the segment
               segnum - Segment number
               x,y,z  - Scale parameters
   Return:     None
   ----------------------------------------------------------------------- */


void PR_SelectChildren (PR_ENTITY *entity, PR_DWORD segnum);
/* -----------------------------------------------------------------------
   Function:   PR_SelectChildren
   Purpose:    Selects the children of a segment
   Parameters: entity - Entity containing the segment
               segnum - Segment number of parent segment
   Return:     None
   ----------------------------------------------------------------------- */


void PR_SelectSegment (PR_ENTITY *entity, PR_DWORD segnum);
/* -----------------------------------------------------------------------
   Function:   PR_SelectSegment
   Purpose:    Selects a segment
   Parameters: entity - Entity containing the segment
               segnum - Segment number to select
   Return:
   ----------------------------------------------------------------------- */


void PR_TransformSegment (PR_ENTITY *entity, PR_SEGMENT *cur_seg,
                          PR_MATRIX ent_mat, PR_MATRIX norm_mat,
                          PR_MATRIX main_transform);
/* -----------------------------------------------------------------------
   Function:   PR_TransformSegment
   Purpose:    Transforms the points in a segment from object to view space 
   Parameters: entity - Entity containing the segment
               cur_seg - Pointer to the segment
               ent_mat - Entity transformation matrix
               norm_mat - Normal matrix (no translation or scaling)
               main_transform - Accumulated matrix up to this point in the
                   hierarchy
   Return:     None
   ----------------------------------------------------------------------- */


void PR_TransformSprite (PR_ENTITY *entity, PR_SEGMENT *cur_seg,
                         PR_MATRIX ent_mat, PR_MATRIX norm_mat,
                         PR_MATRIX main_transform);
/* -----------------------------------------------------------------------
   Function:   PR_TransformSprite
   Purpose:    Transforms the points in a segment from object to view space 
   Parameters: entity - Entity containing the segment
               cur_seg - Pointer to the segment
               ent_mat - Entity transformation matrix
               norm_mat - Normal matrix (no translation or scaling)
               main_transform - Accumulated matrix up to this point in the
                   hierarchy
   Return:     None
   ----------------------------------------------------------------------- */


void PR_TransformVertexList (PR_VERTEX *vlist, PR_VERTEX_DATA *vlistdata,
                PR_DWORD numvert, PR_MATRIX transform_mat);
/* -----------------------------------------------------------------------
   Function:   PR_TransformVertexList
   Purpose:    Transforms and projects the vertices 
   Parameters: vlist - Pointer to the original vertices
               vlist_data - Pointer to the vertex data, where the results are stored
               numvert - Number of vertices in the list
               transform_mat - Transformation matrix
   Return:     None
   ----------------------------------------------------------------------- */


PR_VERTEX *PR_GetVertexPointer (PR_VERTEX *vlist, PR_DWORD vertnum);
PR_DWORD PR_GetVertexNumber (PR_VERTEX *vlist, PR_VERTEX *vert);

#ifdef __cplusplus
}
#endif

#endif
