/* Power Render Statistics Interface */

#ifndef _PRSTAT_
#define _PRSTAT_

#ifdef __cplusplus
  extern "C" {
#endif

/* Global Variables */
extern PR_DWORD PR_DrawElements;
extern PR_DWORD PR_ScansDrawn;
extern PR_DWORD PR_PixelsDrawn;


/* Function Prototypes */
PR_DWORD PR_StatElementsDrawn (void);
/* -----------------------------------------------------------------------
   Function:   PR_StatElementsDrawn
   Purpose:    Returns the number of elements (triangles) drawn by the
               rendering routines 
   Parameters: None
   Return:     Number of elements drawn in the last frame
   ----------------------------------------------------------------------- */


PR_DWORD PR_StatPixelsDrawn (void);
/* -----------------------------------------------------------------------
   Function:   PR_StatPixelsDrawn
   Purpose:    Returns the number of pixels drawn by the triangle routines 
   Parameters: None
   Return:     Number of pixels drawn in the last frame
   ----------------------------------------------------------------------- */


PR_DWORD PR_StatScansDrawn (void);
/* -----------------------------------------------------------------------
   Function:   PR_StatScansDrawn
   Purpose:    Returns the number of scans drawn by the triangle routines 
   Parameters: None
   Return:     Number of scans drawn in the last frame
   ----------------------------------------------------------------------- */



#ifdef __cplusplus
}
#endif

#endif
