#ifndef _PRTEXTURE_            
#define _PRTEXTURE_     /* Mark this header already included */

#ifdef __cplusplus
 extern "C" {
#endif


/* Texture image definition */
typedef struct {
 char *           filename;
 PR_UCHAR         most_common_color;
 block            image;
 PR_DWORD         width;
 PR_DWORD         height;
 PR_REAL          xscale, yscale;       /* Scaling factor for UV coordinates */
} PR_TEXTURE;


#define IMAGE_UNKNOWN 0
#define IMAGE_PCX 1
//#define IMAGE_GIF 2   /* Removed */
#define IMAGE_BLK 3
#define IMAGE_PAK 4
#define IMAGE_LBM 5
#define IMAGE_BMP 6
#define IMAGE_3DF 7

/* Texture formats */
#define TEXTURE_RGB_565             0
#define TEXTURE_ARGB_1555           1

#define TEXTURE_RGB_332             2
#define TEXTURE_ARGB_8332           3
#define TEXTURE_ARGB_4444           4

#define TEXTURE_YIQ_422             5
#define TEXTURE_AYIQ_8422           6

#define TEXTURE_INTENSITY_8         7
#define TEXTURE_ALPHA_8             8
#define TEXTURE_ALPHA_INTENSITY_44  9
#define TEXTURE_ALPHA_INTENSITY_88  10

#define TEXTURE_P_8                 11
#define TEXTURE_AP_88               12

#define TEXTURE_NORMAL 0
#define TEXTURE_XRAY 1

extern PR_TEXTURE *PR_WorldTextures;
extern PR_DWORD PR_NumTextures;
extern PR_DWORD PR_TextureFormat;

extern PR_UCHAR quantize_textures;
extern color global_palette[256];

/* Extension to WGT's image commands */
block wloadgif (char *filename, color *pal);



PR_DWORD PR_AddTextureVGA (char *filename, block image);
/* -----------------------------------------------------------------------
   Function:   PR_AddTextureVGA
   Purpose:    Adds a texture to the PR_WorldTextures array
   Parameters: filename - Filename of the texture (must be present)
               image - 8 bit texture image
   Return:     Texture number
   ----------------------------------------------------------------------- */


void PR_AllocTexturesVGA (PR_DWORD maxtexture);
/* -----------------------------------------------------------------------
   Function:   PR_AllocTexturesVGA
   Purpose:    Allocates room for a list of textures
   Parameters: maxtexture - Number of textures positions to allocate
   Return:     None
   ----------------------------------------------------------------------- */


void PR_DeleteAllTexturesVGA (void);
/* -----------------------------------------------------------------------
   Function:   PR_DeleteAllTexturesVGA
   Purpose:    Deletes all the textures from the PR_WorldTextures array
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PR_DeleteTexture (char *filename);
/* -----------------------------------------------------------------------
   Function:   PR_DeleteTexture
   Purpose:    Deletes a texture from the PR_WorldTextures array
   Parameters: filename - filename of the texture to delete
   Return:     TEXTURE_NOT_FOUND or TEXTURE_DELETED
   ----------------------------------------------------------------------- */


PR_UCHAR PR_FindMostCommonColor (PR_DWORD texnum);
/* -----------------------------------------------------------------------
   Function:   PR_FindMostCommonColor 
   Purpose:    Finds the most common color in a texture
   Parameters: texnum - Texture number
   Return:     Most common color in the texture
   ----------------------------------------------------------------------- */


PR_DWORD PR_FindTexture (char *filename);
/* -----------------------------------------------------------------------
   Function:   PR_FindTexture
   Purpose:    Finds the texture number given its filename
   Parameters: filename - Filename of the texture to find
   Return:     TEXTURE_NOT_FOUND if the file is not in the PR_WorldTextures
               array, or the image number in the array if the file has been
               loaded already.
   ----------------------------------------------------------------------- */


PR_DWORD PR_GetImageType (char *filename);
/* -----------------------------------------------------------------------
   Function:   PR_GetImageType
   Purpose:    Returns the file type of an image, based on the extension 
   Parameters: filename - Filename of the image
   Return:     IMAGE_PCX, IMAGE_GIF, IMAGE_BLK, IMAGE_PAK, IMAGE_LBM,
               IMAGE_BMP, IMAGE_3DF
   ----------------------------------------------------------------------- */


PR_DWORD PR_LoadTextureVGA (char *filename);
/* -----------------------------------------------------------------------
   Function:   PR_LoadTextureVGA
   Purpose:    Loads the texture if it hasn't been already
   Parameters: filename - Filename of the texture to load
   Return:     Texture number
   ----------------------------------------------------------------------- */


void PR_SetTextureFormat (PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PR_SetTextureMode
   Purpose:    Sets the texture format mode
   Parameters: mode - Mode type
   Return:     None
   ----------------------------------------------------------------------- */

void PR_SetTexturePath (char *pathname);
/* -----------------------------------------------------------------------
   Function:   PR_SetTexturePath
   Purpose:    Sets the path prefix for textures
   Parameters: pathname - Path to use for textures
   Return:     None
   ----------------------------------------------------------------------- */


#ifdef __cplusplus
}
#endif

#endif



