/* Power Render Types */

#ifndef _PRTYPES_
#define _PRTYPES_

#ifdef __cplusplus
  extern "C" {
#endif

/* Constants */

/* Polygon Sorting */
#define FLAG_SUBSEG            2
#define FLAG_NOTRANSFORM       4
#define FLAG_SELECTED          8
#define FLAG_NORENDER         16
#define FLAG_NORMALS          32
#define FLAG_VISIBLE          64
#define FLAG_ALWAYS_VISIBLE  128
#define FLAG_SPRITE          256
#define FLAG_LOOP_ANIMATION  512

#define FLAG_SET 0
#define FLAG_CLEAR 1
#define FLAG_COPY 2

#define CAMFLAG_ANGLE_BASED     0
#define CAMFLAG_AIM_TARGET      1
#define CAMFLAG_FREEMATRIX      2
#define CAMFLAG_TARGET_SEGMENT  4
#define CAMFLAG_LOOP_ANIMATION  8

#define VFLAG_BEHIND       1
#define VFLAG_BELOW        2
#define VFLAG_ABOVE        4
#define VFLAG_LEFT         8
#define VFLAG_RIGHT       16
#define VFLAG_BEFORE      32
#define VFLAG_CLIPPED    128
#define VFLAG_FIXTEX     256


#define FFLAG_VISIBLE_NOW   1
#define FFLAG_FRONT_VISIBLE 2
#define FFLAG_BACK_VISIBLE  4
#define FFLAG_SELECTED      8
#define FFLAG_CLEAR_VISIBLE 254
#define FFLAG_FOGGED        32

#define VISIBLE 0
#define INVISIBLE 1

#define RENORMALIZE 2000
#define EPSILON 1.0E-6 			/* a tiny number */

typedef PR_REAL PR_MATRIX[16];

/* Structures */
/* ----------------------
   PR_POINT
   ---------------------- */
typedef struct coord
 {
  PR_REAL               x;
  PR_REAL               y;
  PR_REAL               z;
 } PR_POINT;


/* ----------------------
   PR_VERTEX_DATA
   ---------------------- */
typedef struct
 {
  PR_REAL               sx, sy;         /* Screen coordinates (after projection) */
  PR_REAL               vz;             /* View z coordinate */
  PR_REAL               r, g, b;        /* Color of vertex */
  PR_WORD               dotproduct;
  PR_UWORD              flags;          
  PR_REAL               a;
  PR_REAL               ooz;            /* One over Z */
  PR_REAL               s0, t0, oow1;
  PR_REAL               vx, t1, vy;
 } PR_VERTEX_DATA;


/* ----------------------
   PR_VERTEX
   ---------------------- */
typedef struct
 {
  PR_REAL               x, y, z;        /* Local coordinates */
  PR_WORD               nx, ny, nz;     /* Normal angles */
  PR_VERTEX_DATA *      vdata;          /* Pointer to the corresponding data */        
  PR_WORD               wnx, wny, wnz;  /* Rotated angles */
 } PR_VERTEX;



/* ----------------------
   PR_VERTEX_DATA_DWORD
   ---------------------- */
typedef struct
 {
  PR_DWORD              sx, sy;         /* Screen coordinates (after projection) */
  PR_REAL               vz;             /* View z coordinate */
  PR_REAL               r, g, b;        /* Color of vertex */
  PR_WORD               dotproduct;
  PR_UWORD              flags;          
  PR_REAL               a;
  PR_REAL               ooz;            /* One over Z */
  PR_REAL               s0, t0, oow1;
  PR_DWORD              vx;
  PR_REAL               t1;
  PR_DWORD              vy;
 } PR_VERTEX_DATA_DWORD;
 /* Used for fast integer compares with clipping check */



/* ----------------------
   PR_FACE_DATA
   ---------------------- */
typedef struct          /* 16.16 fixed point for software rendering */
 {
  PR_DWORD              u[3];           /* u coordinates */  
  PR_DWORD              v[3];           /* v coordinates */  
  PR_DWORD              col[3];         /* shade values  */  
 } PR_FACE_DATA;


/* ----------------------
   PR_FACE_DATA_REAL
   ---------------------- */
typedef struct          /* Used for 3D hardware */
 {
  PR_REAL               u[3];           /* u coordinates */  
  PR_REAL               v[3];           /* v coordinates */  
  PR_REAL               col[3];         /* shade values  */  
 } PR_FACE_DATA_REAL;


/* ----------------------
   PR_FACE
   ---------------------- */
typedef struct
 {
  PR_UWORD              material;       /* Defines what kind of face this is */
  PR_UWORD              backmaterial;   /* Defines the back material */

  PR_VERTEX *           vertex1;
  PR_VERTEX *           vertex2;        /* Second and third vertices are only used */
  PR_VERTEX *           vertex3;        /* for triangle elements */

  PR_FACE_DATA          face_data;      /* Used for texture and shading values */

  PR_WORD               nx, ny, nz;     /* Normal angles */
  PR_BYTE               flags;
  PR_WORD               dotprod;
 } PR_FACE;              /* A 3D face */



/* ----------------------
   PR_ORIENTATION
   ---------------------- */
typedef struct
 {
  PR_POINT              location;
  PR_POINT              scale;
  PR_POINT              rot;
  PR_POINT              direction;      /* Normalized Direction */
  PR_MATRIX             rot_mat;        /* Accumulated Rotation Matrix */
  PR_DWORD              renormalize;    /* Countdown for normalization */
 } PR_ORIENTATION;


/* ----------------------
   PR_BOUNDING_INFO
   ---------------------- */
typedef struct 
 {
  PR_REAL               minx, maxx;
  PR_REAL               miny, maxy;
  PR_REAL               minz, maxz;
  PR_POINT              box[9];         /* 4 corners plus the center vertex */
  PR_POINT              tbox[9];        /* transformed vertices */
  PR_REAL               radius;
 } PR_BOUNDINGINFO;


/* ----------------------
   PR_BSPNODE (not used)
   ---------------------- */
typedef struct
 {
  PR_DWORD              frontface;       /* Upper 16 bits : Segment number */
  PR_DWORD              backface;        /* Lower 16 bits : Face number    */
 } PR_BSPNODE;



/* ----------------------
   PR_QUATERNION
   ---------------------- */
typedef struct {
  PR_POINT vector;
  PR_REAL  rotation;
} PR_QUATERNION;



/* ----------------------
   PR_LIGHT
   ---------------------- */
typedef struct {
  PR_DWORD               type;           /* Type of light */
  PR_REAL                x, y, z;        /* Coordinate of light */
  PR_REAL                vx, vy, vz;     /* Rotated Coordinate of light */
  PR_REAL                strength;       /* Strength of light (0-1.0) */
  PR_REAL                falloff;        /* Falloff value for distant lights */
  PR_REAL                falloffdiv;     /* Falloff divisor */

  PR_DWORD               nx, ny, nz;     /* Normalized vector between light */
                                         /* and object */

  PR_REAL                distance;       /* Distance from work object */
  PR_DWORD               on;             /* 1 if light is active */

  PR_REAL                r, g, b;        /* 24 bit color value */
  PR_DWORD               mode;           /* Additive or subtractive */
} PR_LIGHT;


/* ----------------------
   PR_LIGHTLIST
   ---------------------- */
typedef struct {
  PR_DWORD NumLights;
  PR_DWORD MaxLights;
  PR_LIGHT *LightList;
} PR_LIGHTLIST;




#define KF_SPLINE_USE_TENSION          1
#define KF_SPLINE_USE_CONTINUITY       2
#define KF_SPLINE_USE_BIAS             4
#define KF_SPLINE_USE_EASE_TO          8
#define KF_SPLINE_USE_EASE_FROM        16
#define KF_LINEAR_KEY                  128

/* ----------------------
   PRKF_KEYHDR
   ---------------------- */
typedef struct
 {
  PR_DWORD frame_number;           /* the frame number where the key occurs */
  PR_UWORD spline_term_flags;      /* a set of bits that determine which spline
                                      terms are present */
  PR_REAL  spline_tension;         /* spline tension value ranges from -1.0 to
                                      1.0.  Only present if bit 0 set. */
  PR_REAL  spline_continuity;      /* spline continuity value ranges from -1.0
                                      to 1.0.  Only present if bit 2 set. */
  PR_REAL  spline_bias;            /* spline bias value ranges from 1.0 to 1.0.
                                      Only present if bit 2 set. */
  PR_REAL  ease_to;                /* ease to value ranges from 0.0 to 1.0.
                                      Only present if bit 3 set. */
  PR_REAL  ease_from;              /* ease from value ranges from 0.0 to 1.0.
                                      Only present if bit 4 set. */
 } PRKF_KEYHDR;


/* ----------------------
   PRKF_CAMKEY
   ---------------------- */
typedef struct
 {
  PRKF_KEYHDR   key_header;

  PR_POINT src_info;            /* Source location */
  PR_POINT dst_info;            /* Target location */

  PR_REAL fov;                  /* Field of view */
  PR_REAL tilt;                 /* Tilt angle */

 } PRKF_CAMKEY;


/* ----------------------
   PRKF_ROTKEY
   ---------------------- */
typedef struct
 {
  PRKF_KEYHDR   key_header;
  PR_QUATERNION rot_info;

  PR_MATRIX rot_mat;            /* Rotation matrix up to this point */
  PR_QUATERNION rot_quat;       /* Rotation quaternion up to this point */
 } PRKF_ROTKEY;


/* ----------------------
   PRKF_POSKEY
   ---------------------- */
typedef struct
 {
  PRKF_KEYHDR   key_header;
  PR_POINT pos_info;

  PR_MATRIX pos_mat;            /* Translation matrix up to this point */
 } PRKF_POSKEY;


/* ----------------------
   PRKF_SCLKEY
   ---------------------- */
typedef struct
 {
  PRKF_KEYHDR   key_header;
  PR_POINT scale_info;

  PR_MATRIX scl_mat;            /* Scaling matrix up to this point */
 } PRKF_SCLKEY;




/* ----------------------
   PR_SEGMENT
   ---------------------- */
typedef struct
 {
  char *                name;
  PR_DWORD              segment_number;

  PR_DWORD              num_faces;
  PR_DWORD              num_vertices;
 
  PR_FACE *             face_list;
  PR_VERTEX *           vertex_list;
  PR_VERTEX_DATA *      vertex_data;

  void *                children;
  void *                next;
  void *                parent;
  PR_DWORD              level;

  PR_BOUNDINGINFO       bbox;

  PR_BSPNODE *          bspnode_list;            

  PR_LIGHTLIST          seglights;

  PR_MATRIX             seg_transform;
  PR_MATRIX             normal_transform;
  PR_DWORD              flags;

  /* Keyframe animation */
  PR_POINT              pivot;
  PR_MATRIX             localtoworld;

  PR_DWORD              num_rot_keys;
  PRKF_ROTKEY           *rot_keys;
  PR_DWORD              num_pos_keys;
  PRKF_POSKEY           *pos_keys;
  PR_DWORD              num_scl_keys;
  PRKF_SCLKEY           *scl_keys;

 } PR_SEGMENT;



/* ----------------------
   PR_OBJECT
   ---------------------- */
typedef struct
 {
  char *                name;

  PR_SEGMENT *          segment_list;
  PR_DWORD              num_segments;
  PR_BOUNDINGINFO       bbox;

  /* Animation */
  PR_DWORD num_frames;

 } PR_OBJECT;



/* ----------------------
   PR_ENTITY
   ---------------------- */
typedef struct
 {
  char *name;

  PR_ORIENTATION        orientation;
  PR_DWORD              flags;
  
  PR_OBJECT             *shape;

  PR_ORIENTATION        *segment_orientation;
  PR_DWORD              *segment_flags;

  PR_DWORD              userdata[32];

 } PR_ENTITY;


/* ----------------------
   PR_CAMERA
   ---------------------- */
typedef struct
 {
  char *                name;
  PR_POINT              source;         /* camera position */
  PR_POINT              dest;           /* point to look at */
  PR_REAL               tilt_angle;     /* Tilt angle (in degrees) */
  PR_REAL               distance;       /* Used without targets */
  PR_POINT              up;             /* View up vector */
  PR_POINT              direction;      /* Normalized Direction */
  PR_POINT              rotation;       /* Used for cameras without a target */
  PR_BYTE               flags;          /* Camera Flags */
  void *                next;           /* Pointer to next camera in list */

  PR_REAL               aspect_ratio;
  PR_REAL               fov;
  PR_REAL               nearclip;
  PR_REAL               farclip;

  /* Animation */
  PR_ENTITY *           ent;
  PR_DWORD              target_segment;

  PR_DWORD              num_frames;     /* Maximum frame number */
  PR_DWORD              num_cam_keys;   /* Number of camera keys */
  PRKF_CAMKEY           *cam_keys;      

 } PR_CAMERA;


/* Polygon drawing structure */
typedef struct
 {
  PR_RPOINT             renderpoly[3];
  PR_DWORD              material;
  PR_BYTE               flags;
 } PR_RENDERSTRUCT;


#ifdef __cplusplus
}
#endif

#endif
