#include <stdlib.h>
#include <direct.h>
#include <string.h>

#include <pr.h>
#include <prgui.h>

#ifdef MSGLIDE
#include <pr3dfx.h>
#include <windows.h>
#endif


/*

       /=========\ /========\ ||        || /========  /=======\
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||   ||   || ||         ||      //
       |=========/ ||      || ||   ||   || |=======   |=====<<
       ||          ||      || ||   ||   || ||         ||      \\
       ||          ||      || ||   ||   || ||         ||       ||
       ||          ||      || ||   ||   || ||         ||       ||
       ||          \========/ \==========/ \========= ||       ||

--------------------------------<===>----------------------------------

    /=======\   /========= |\     || |======\  /========= /=======\
    ||      ||  ||         ||\    || ||    \ \ ||         ||      ||
    ||      ||  ||         || \   || ||     || ||         ||      ||
    ||      ||  ||         ||  \  || ||     || ||         ||      ||
    ||      //  ||         ||   \ || ||     || ||         ||      //
    |======<<   |======    ||\   \|| ||     || |======    |======<<
    ||      \\  ||         || \   || ||     || ||         ||      \\
    ||       || ||         ||  \  || ||     || ||         ||       ||
    ||       || ||         ||   \ || ||    / / ||         ||       ||
    ||       || |========= ||    \|| |======/  |========= ||       ||

Object Centering Utility

Centers the vertices of an object around the origin.  This should not
be used with objects that use hierarchies and different pivots.

 Revision History:
 June 15, 1997: Created

*/

char outfile[80];               /* Name of the output file */
PR_OBJECT *object1;
PR_REAL cenx, ceny, cenz;

void main (int argc, char *argv[])
{
  PRGUI_InitPath (argv[0]);


  if (argc < 3)
    {
     PR_FatalError (
                "CENTPRO Utility    version "
                PR_VERSION_NUMBER
                "\n"
		"Copyright 1997 Egerter Software\n\n"
		"Usage: \n"
        "CENTPRO file1.PRO file2.PRO\n", "CENTPRO");
    }

  printf ("CENTPRO Utility    version ");
  printf (PR_VERSION_NUMBER);
  printf ("\nCopyright 1997 Egerter Software\n\n");

#ifdef MSGLIDE
  PR_Detect3Dfx ();
  PR_Initialize3Dfx ();
#else
  PR_DetectVGA();
  PR_InitializeVGA ();
#endif

  PR_AllocMaterials (512);
  PR_AllocTextures (255);
  PR_AllocShadeTables (32);

  object1 = PR_LoadPRO (argv[1], LOAD_NORMAL);
  if (object1 == NULL)
     PR_FatalError ("An error has occurred when loading the file.\n", "CENTPRO");
     
  PR_CenterObject (object1, &cenx, &ceny, &cenz);

  PR_SavePRO (argv[2], object1, SAVE_ALL_MATERIALS);
}



