#include <stdlib.h>
#include <direct.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>

#include <pr.h>
#include <prgui.h>

#if defined (MSGLIDE) || defined (WTGLIDE)
 #include <glide.h>
 #include <pr3dfx.h>
 #include "winutil.h"
 #include <windows.h>
#elif defined (WIN32)
 #include "winutil.h"
 #include <windows.h>
#else
 #ifdef __3DFX__
  #include <pr3dfx.h>
  #include <glide.h>
  #include <fxgui.h>
 #endif

 #ifdef __MYST__
  #include <msidos.h>
  #include <prmyst.h>
  #include <mystgui.h>
 #endif
#endif


/*

       /=========\ /========\ ||        || /========  /=======\
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||   ||   || ||         ||      //
       |=========/ ||      || ||   ||   || |=======   |=====<<
       ||          ||      || ||   ||   || ||         ||      \\
       ||          ||      || ||   ||   || ||         ||       ||
       ||          ||      || ||   ||   || ||         ||       ||
       ||          \========/ \==========/ \========= ||       ||

--------------------------------<===>----------------------------------

    /=======\   /========= |\     || |======\  /========= /=======\
    ||      ||  ||         ||\    || ||    \ \ ||         ||      ||
    ||      ||  ||         || \   || ||     || ||         ||      ||
    ||      ||  ||         ||  \  || ||     || ||         ||      ||
    ||      //  ||         ||   \ || ||     || ||         ||      //
    |======<<   |======    ||\   \|| ||     || |======    |======<<
    ||      \\  ||         || \   || ||     || ||         ||      \\
    ||       || ||         ||  \  || ||     || ||         ||       ||
    ||       || ||         ||   \ || ||    / / ||         ||       ||
    ||       || |========= ||    \|| |======/  |========= ||       ||

Object Material Editor

Allows you to change the materials listed in a PRO file

 Revision History:
 July 28, 1996: Created
*/

char workname[40];
char objectfile[80];               /* Name of the object */
PR_OBJECT *object;                 /* Shape definition of the PRO file */

PR_DWORD device;
PR_DWORD cenx, ceny, cenz;
PR_DWORD start_screen, end_screen;

#define MATERIALMODE 0
#define TEXTUREMODE 1
#define TABLEMODE 2
PR_DWORD editmode = 0;

PR_DWORD matnum = 0;
PR_DWORD texnum = 0;
PR_DWORD tabnum = 0;

PR_DWORD maxtex;         /* Number of textures for this object */
PR_DWORD maxtab;         /* Number of table for this object */
PR_DWORD maxmat;         /* Number of materials for this object */

PR_MATERIAL *mater;
PR_TEXTURE  *tex;
PR_TABLE    *tab;

char legalname[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz12234567890_ .";

/* Keyboard defines */
#define ESC 1

/* Button positions */
#define MATERIALS 639-210,1,639-140,20
#define TEXTURES  639-140,1,639-70,20
#define TABLES    639-70,1,639,20

#define MATNUMDISPW 40,40
#define MATNUMDISP 180,40
#define MATNAMEDISPW 91,60
#define METHODDISPW 47,80
#define TEXTUREDISPW 42,100
#define BASEDISPW 65,120
#define SHADESDISPW 85,140
#define SHADETABDISPW 59,160
#define ENVMAPDISPW 34,180
#define ENVAXISDISPW 32,200
#define MIPMAPDISPW 76,220
#define MIPMAT1DISPW 23,240
#define MIPMAT2DISPW 21,260
#define MIPMAT3DISPW 21,280
#define MIPMAT4DISPW 20,300
#define MIPMSH1DISPW 323,240
#define MIPMSH2DISPW 321,260
#define MIPMSH3DISPW 321,280
#define MIPMSH4DISPW 320,300

#define MATMINUS 140,38,160,50
#define MATPLUS 220,38,240,50
#define MATNAME 380,58,420,70
#define MATMETHMINUS 140,78,160,90
#define MATMETHPLUS 380,78,400,90
#define MATTEXMINUS 140,98,160,110
#define MATTEXPLUS 340,98,360,110
#define MATBASEMINUS 140,118,160,130
#define MATBASEPLUS 220,118,240,130
#define MATSHADEMINUS 140,138,160,150
#define MATSHADEPLUS 220,138,240,150
#define MATTABLEMINUS 140,158,160,170
#define MATTABLEPLUS 340,158,360,170
#define ENVMAPBUT 140,178,170,190
#define ENVAXISBUT 140,198,170,210
#define MIPMAPBUT 140,218,170,230

#define MATMIP1MINUS 140,238,160,250
#define MATMIP1PLUS 220,238,240,250
#define MATMIP2MINUS 140,258,160,270
#define MATMIP2PLUS 220,258,240,270
#define MATMIP3MINUS 140,278,160,290
#define MATMIP3PLUS 220,278,240,290
#define MATMIP4MINUS 140,298,160,310
#define MATMIP4PLUS 220,298,240,310

#define MATMSH1MINUS 440,238,460,250
#define MATMSH1PLUS 520,238,540,250
#define MATMSH2MINUS 440,258,460,270
#define MATMSH2PLUS 520,258,540,270
#define MATMSH3MINUS 440,278,460,290
#define MATMSH3PLUS 520,278,540,290
#define MATMSH4MINUS 440,298,460,310
#define MATMSH4PLUS 520,298,540,310

#define COLRDISPW 155-50,332
#define COLRMINUS 165-50,330,185-50,342
#define COLRDISP  201-50,333
#define COLRPLUS  235-50,330,255-50,342

#define COLGDISPW 285-50,332
#define COLGMINUS 295-50,330,315-50,342
#define COLGDISP  331-50,333
#define COLGPLUS  365-50,330,385-50,342

#define COLBDISPW 415-50,332
#define COLBMINUS 425-50,330,445-50,342
#define COLBDISP  461-50,333
#define COLBPLUS  495-50,330,515-50,342

#define COLADISPW 545-50,332
#define COLAMINUS 555-50,330,575-50,342
#define COLADISP  591-50,333
#define COLAPLUS  625-50,330,645-50,342


#define TEX_NUMDISPW 20,40
#define TEX_FILEDISPW 56,60

#define TEXMINUS 140,38,160,50
#define TEXPLUS 220,38,240,50
#define TEXNAME 380,58,420,70

#define TAB_NUMDISPW 30,40
#define TAB_FILEDISPW 56,60

#define TABMINUS 140,38,160,50
#define TABPLUS 220,38,240,50
#define TABNAME 380,58,420,70

#define SAVE 140,367,200,388
#define QUIT 440,367,500,388
#define ADD 130,5,180,20
#define DELETEBUT 200,5,250,20



void Fix_EnvMap (PR_OBJECT *obj)
{
PR_SEGMENT *segptr;
PR_MATERIAL *matptr;
PR_FACE *faceptr;
PR_DWORD seg, face;
  
  for (seg = 0; seg < obj->num_segments; seg++)
    { /* For every segment */
     segptr = &obj->segment_list[seg];
     segptr->flags &= ~FLAG_NORMALS;    /* Clear out the normals flag */

     for (face = 0; face < segptr->num_faces; face++)
       { /* For every face */

        faceptr = &segptr->face_list[face];
        matptr = &PR_ObjectMaterialList[faceptr->material];


        if (matptr->environment_map)
          segptr->flags |= FLAG_NORMALS;

        matptr = &PR_ObjectMaterialList[faceptr->backmaterial];
        if (matptr->environment_map)
          segptr->flags |= FLAG_NORMALS;
       }
    }

}







void Show_MatNum (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (175, 39, 205, 50);
     PRGFX_Clip (0, 0, 639, 479);
     PRGUI_printf (180, 40, "%i", matnum);
    }
}


void Show_MatName (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (140, 59, 365, 70);
     PRGUI_printf (140, 60, "%s", mater->name);
    }
}


void Show_MatMethod (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (170, 79, 365, 90);

     PRGUI_printf (180, 80, "%s", PR_ReturnMethodName (mater->render_method));
    }
}


void Show_MatTexNum (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (175, 99, 325, 110);
     PRGUI_printf (180, 100, "%i (%s)", mater->texture_number,
                 PR_WorldTextures[mater->texture_number].filename);
    }
}


void Show_MatBase (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (175, 119, 205, 130);
     PRGUI_printf (180, 120, "%i", mater->base_color);
    }
}


void Show_MatShade (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (175, 139, 205, 150);
     PRGUI_printf (180, 140, "%i", mater->render_shades);
    }
}


void Show_MatTable (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (170, 159, 325, 170);
     PRGUI_printf (180, 160, "%i (%s)", mater->shadetable,
                                     PR_ShadeTables[mater->shadetable].name);
    }
}


void Show_MatEnvMap (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     if (mater->environment_map)
       PRGUI_textbutton (ENVMAPBUT, "Yes");
     else
       PRGUI_textbutton (ENVMAPBUT, "No");
    }
}


void Show_MatEnvAxis (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     if (mater->environment_axis == 0)
       PRGUI_textbutton (ENVAXISBUT, "X");
     else if (mater->environment_axis == 1)
       PRGUI_textbutton (ENVAXISBUT, "Y");
     else
       PRGUI_textbutton (ENVAXISBUT, "Z");
    }
}


void Show_MatMipMap (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     if (mater->MipMap)
       PRGUI_textbutton (MIPMAPBUT, "Yes");
     else
       PRGUI_textbutton (MIPMAPBUT, "No");
    }
}


void Show_MatMipMap1 (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (175, 239, 205, 250);
     PRGUI_printf (180, 240, "%i", mater->MipMaterial1);
    }
}


void Show_MatMipMap2 (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (175, 259, 205, 270);
     PRGUI_printf (180, 260, "%i", mater->MipMaterial2);
    }
}


void Show_MatMipMap3 (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (175, 279, 205, 290);
     PRGUI_printf (180, 280, "%i", mater->MipMaterial3);
    }
}


void Show_MatMipMap4 (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (175, 299, 205, 310);
     PRGUI_printf (180, 300, "%i", mater->MipMaterial4);
    }
}


void Show_MatMipShift1 (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (475, 239, 505, 250);
     PRGUI_printf (480, 240, "%i", mater->MipShift1);
    }
}


void Show_MatMipShift2 (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (475, 259, 505, 270);
     PRGUI_printf (480, 260, "%i", mater->MipShift2);
    }
}


void Show_MatMipShift3 (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (475, 279, 505, 290);
     PRGUI_printf (480, 280, "%i", mater->MipShift3);
    }
}

void Show_MatMipShift4 (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (475, 299, 505, 310);
     PRGUI_printf (480, 300, "%i", mater->MipShift4);
    }
}                                             


void Show_TexNum (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (175, 39, 205, 50);
     PRGUI_printf (180, 40, "%i", texnum);
    }
}


void Show_TexName (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (140, 59, 365, 70);
     if (tex->filename != NULL)
       PRGUI_printf (140, 60, "%s", tex->filename);
     else
       PRGUI_printf (140, 60, "EMPTY");
    }
}


void Show_TabNum (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (175, 39, 205, 50);
     PRGUI_printf (180, 40, "%i", tabnum);
    }
}


void Show_TabName (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (140, 59, 365, 70);
     if (tab->name != NULL)
       PRGUI_printf (140, 60, "%s", tab->name);
     else
       PRGUI_printf (140, 60, "EMPTY");
    }
}


void Show_ColR (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (195-50, 332, 225-50, 343);
     PRGUI_printf (COLRDISP, "%3.0f", mater->r);
    }
}


void Show_ColG (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (325-50, 332, 355-50, 343);
     PRGUI_printf (COLGDISP, "%3.0f", mater->g);
    }
}


void Show_ColB (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (455-50, 332, 485-50, 343);
     PRGUI_printf (COLBDISP, "%3.0f", mater->b);
    }
}


void Show_ColA (void)
{
PR_DWORD i;

  for (i = start_screen; i <= end_screen; i++)
    {
     PR_OpenScreen (i);

     PRGFX_SetColor (GUI_WHITE);
     PRGFX_Bar (585-50, 332, 615-50, 343);
     PRGUI_printf (COLADISP, "%3.0f", mater->a);
    }
}


extern char origpath[_MAX_DIR];
extern char userpath[_MAX_DIR];

PR_DWORD firstdraw = 1;
void InitMenu (void)
/* Draw the initial menu */
{
block logo;
color pal[256];
PR_DWORD i;
PR_DWORD ss, es;

  PRGFX_SetTextForeground (GUI_GREY1);
  PRGFX_SetTextBackground (GUI_GREY3);
  PRGFX_SetTextTransparent (TEXTFG);

  if (PR_OutputDevice.pages == 1)
    {
     ss = PR_FRONTBUFFER;
     es = PR_FRONTBUFFER;
    }
  else 
    {
     ss = PR_FRONTBUFFER;
     es = PR_BACKBUFFER;
    }



  for (i = ss; i <= es; i++)
    {
     PR_OpenScreen (i);

     start_screen = i;
     end_screen = i;

     if (firstdraw)
       {
        mater = &PR_ObjectMaterialList[matnum];
        tex = &PR_WorldTextures[texnum];
        tab = &PR_ShadeTables[tabnum];

        PRGFX_Clip (0, 0, 639, 479);
        PRGFX_SetColor (GUI_BLACK);
        PRGFX_ClearScreen ();

        PRGFX_SetColor (GUI_GREY1);
        PRGFX_Bar (0, 377, 639, 479-67);
        PRGFX_SetColor (GUI_GREY2);
        PRGFX_Bar (0, 357, 639, 479-77);

        PRGUI_GoStartPath ();
        setlib ("guidata.prl");
        logo = wloadpcx ("prbwlogo.pcx", pal);
        if (logo == NULL)
          PR_FatalError ("Cannot find the Power Render logo file.", "initmenu");
        PRGFX_Clip (0, 0, 639, 479);
        PR_BeginScreen ();
        PRGFX_PutBlock8bit (115, 479-67, logo, pal, 1);
        PR_EndScreen ();
        wfreeblock (logo);


        gui_font = wloadfont ("guifont.wfn");

        PRGUI_textbutton (SAVE, "SAVE");
        PRGUI_textbutton (QUIT, "QUIT");

        setlib (NULL);
        PRGUI_GoUserPath ();
       }

     PRGUI_Button (1, 1, 638, 356);


     PRGFX_SetTextForeground (GUI_GREY1);
     PRGUI_printf (10, 5,  "EDITMAT 1.0");
     PRGUI_printf (10, 25, "File");
     PRGUI_printf (60, 25, ":");
     PRGUI_printf (70, 25, "%s", objectfile);
     PRGUI_textbutton (ADD, "Add");
     PRGUI_textbutton (DELETEBUT, "Delete");

     // Modes 
     PRGUI_textbutton (MATERIALS, "Materials");
     PRGUI_textbutton (TEXTURES, "Textures");
     PRGUI_textbutton (TABLES, "Tables");
     PRGUI_printf (459, 25, "%i", maxmat);
     PRGUI_printf (529, 25, "%i", maxtex);
     PRGUI_printf (599, 25, "%i", maxtab);
  
     if (editmode == MATERIALMODE)
       {

        PRGFX_SetTextForeground (GUI_RED);
        PRGUI_printf (260,10, "MATERIAL MODE");

        PRGFX_SetTextForeground (GUI_GREY1);
        PRGUI_printf (MATNUMDISPW, "Material Number:");
        PRGUI_printf (MATNAMEDISPW, "Name:");
        PRGUI_printf (METHODDISPW, "Render Method:");
        PRGUI_printf (TEXTUREDISPW, "Texture Number:");
        PRGUI_printf (BASEDISPW, "Base Color:");
        PRGUI_printf (SHADESDISPW, "Shades:");
        PRGUI_printf (SHADETABDISPW, "Shade Table:");
        PRGUI_printf (ENVMAPDISPW, "Environment Map:");
        PRGUI_printf (ENVAXISDISPW, "Environment Axis:");
        PRGUI_printf (MIPMAPDISPW, "Mip Map:");
        PRGUI_printf (MIPMAT1DISPW, "Mip Map Material 1:");
        PRGUI_printf (MIPMAT2DISPW, "Mip Map Material 2:");
        PRGUI_printf (MIPMAT3DISPW, "Mip Map Material 3:");
        PRGUI_printf (MIPMAT4DISPW, "Mip Map Material 4:");
        PRGUI_printf (MIPMSH1DISPW, "Mip Map Shift 1:");
        PRGUI_printf (MIPMSH2DISPW, "Mip Map Shift 2:");
        PRGUI_printf (MIPMSH3DISPW, "Mip Map Shift 3:");
        PRGUI_printf (MIPMSH4DISPW, "Mip Map Shift 4:");
        PRGUI_printf (COLRDISPW, "R");
        PRGUI_printf (COLGDISPW, "G");
        PRGUI_printf (COLBDISPW, "B");
        PRGUI_printf (COLADISPW, "A");

        PRGUI_textbutton (MATPLUS, "+");
        PRGUI_textbutton (MATMINUS, "-");
        PRGUI_textbutton (MATNAME, "EDIT");
        PRGUI_textbutton (MATMETHPLUS, "+");
        PRGUI_textbutton (MATMETHMINUS, "-");
        PRGUI_textbutton (MATTEXPLUS, "+");
        PRGUI_textbutton (MATTEXMINUS, "-");
        PRGUI_textbutton (MATBASEPLUS, "+");
        PRGUI_textbutton (MATBASEMINUS, "-");
        PRGUI_textbutton (MATSHADEPLUS, "+");
        PRGUI_textbutton (MATSHADEMINUS, "-");
        PRGUI_textbutton (MATTABLEPLUS, "+");
        PRGUI_textbutton (MATTABLEMINUS, "-");

        PRGUI_textbutton (MATMIP1PLUS, "+");
        PRGUI_textbutton (MATMIP1MINUS, "-");
        PRGUI_textbutton (MATMIP2PLUS, "+");
        PRGUI_textbutton (MATMIP2MINUS, "-");
        PRGUI_textbutton (MATMIP3PLUS, "+");
        PRGUI_textbutton (MATMIP3MINUS, "-");
        PRGUI_textbutton (MATMIP4PLUS, "+");
        PRGUI_textbutton (MATMIP4MINUS, "-");

        PRGUI_textbutton (MATMSH1PLUS, "+");
        PRGUI_textbutton (MATMSH1MINUS, "-");
        PRGUI_textbutton (MATMSH2PLUS, "+");
        PRGUI_textbutton (MATMSH2MINUS, "-");
        PRGUI_textbutton (MATMSH3PLUS, "+");
        PRGUI_textbutton (MATMSH3MINUS, "-");
        PRGUI_textbutton (MATMSH4PLUS, "+");
        PRGUI_textbutton (MATMSH4MINUS, "-");

        PRGUI_textbutton (COLRPLUS, "+");
        PRGUI_textbutton (COLRMINUS, "-");
        Show_ColR ();

        PRGUI_textbutton (COLGPLUS, "+");
        PRGUI_textbutton (COLGMINUS, "-");
        Show_ColG ();

        PRGUI_textbutton (COLBPLUS, "+");
        PRGUI_textbutton (COLBMINUS, "-");
        Show_ColB ();

        PRGUI_textbutton (COLAPLUS, "+");
        PRGUI_textbutton (COLAMINUS, "-");
        Show_ColA ();

        Show_MatNum ();
        Show_MatName ();
        Show_MatMethod ();
        Show_MatTexNum ();
        Show_MatBase ();
        Show_MatShade ();
        Show_MatTable ();
        Show_MatEnvMap ();
        Show_MatEnvAxis ();

        Show_MatMipMap ();
        Show_MatMipMap1 ();
        Show_MatMipMap2 ();
        Show_MatMipMap3 ();
        Show_MatMipMap4 ();

        Show_MatMipShift1 ();
        Show_MatMipShift2 ();
        Show_MatMipShift3 ();
        Show_MatMipShift4 (); 
       }
     else if (editmode == TEXTUREMODE)
       {
        PRGFX_SetTextForeground (GUI_RED);
        PRGUI_printf (260,10, "TEXTURE MODE");

        PRGFX_SetTextForeground (GUI_GREY1);
        PRGUI_printf (TEX_NUMDISPW, "Texture Number:");
        PRGUI_printf (TEX_FILEDISPW, "Filename:");

        PRGUI_textbutton (TEXPLUS, "+");
        PRGUI_textbutton (TEXMINUS, "-");
        PRGUI_textbutton (TEXNAME, "EDIT");

        Show_TexNum ();
        Show_TexName ();
       }
     else if (editmode == TABLEMODE)
       {
        PRGFX_SetTextForeground (GUI_RED);
        PRGUI_printf (260,10, "TABLE MODE");

        PRGFX_SetTextForeground (GUI_GREY1);
        PRGUI_printf (TAB_NUMDISPW, "Table Number:");
        PRGUI_printf (TAB_FILEDISPW, "Filename:");

        PRGUI_textbutton (TABPLUS, "+");
        PRGUI_textbutton (TABMINUS, "-");
        PRGUI_textbutton (TABNAME, "EDIT");

        Show_TabNum ();
        Show_TabName ();
       }

   
  }

  if (PR_OutputDevice.pages == 1)
    {
     start_screen = PR_FRONTBUFFER;
     end_screen = PR_FRONTBUFFER;
    }
  else 
    {
     start_screen = PR_FRONTBUFFER;
     end_screen = PR_BACKBUFFER;
    }

//  PR_Flip(1);

  if (firstdraw)
    firstdraw = 0;

  PR_OpenScreen (PR_FRONTBUFFER);
}


void AddNewMaterial (void)
{
PR_DWORD num;
PR_DWORD found = -1;

  num = 0;
  for (num = 0; num < 512; num++)
    {
     if (PR_ObjectMaterialList[num].name[0] == '\0')
       {
        found = num;
        break;
       }
    }

  if (found != -1)
    {
     matnum = num;
     mater = &PR_ObjectMaterialList[matnum];
     memset (mater, 0, sizeof (PR_MATERIAL));
     strcpy (mater->name, "New");
     if (num >= maxmat)
       maxmat = num+1;
     InitMenu ();
    }
}


void AddNewTexture (void)
{
PR_DWORD num;
PR_DWORD found = -1;

  num = 0;
  for (num = 0; num < 256; num++)
    {
     if (PR_WorldTextures[num].filename == NULL)
       {
        found = num;
        break;
       }
    }

  if (found != -1)
    {
     texnum = num;
     tex = &PR_WorldTextures[texnum];
     memset (tex, 0, sizeof (PR_TEXTURE));
     tex->filename = strdup ("New");
     if (num >= maxtex)
       maxtex = num+1;
     InitMenu ();
    }
}



void AddNewTable (void)
{
PR_DWORD num;
PR_DWORD found = -1;

  num = 0;
  for (num = 0; num < 32; num++)
    {
     if (PR_ShadeTables[num].name == NULL)
       {
        found = num;
        break;
       }
    }

  if (found != -1)
    {
     tabnum = num;
     tab = &PR_ShadeTables[tabnum];
     memset (tab, 0, sizeof (PR_TABLE));
     tab->name = strdup ("New");
     if (num >= maxtab)
       maxtab = num+1;
     InitMenu ();
    }
}


#if defined (MSDD) || defined (WTDD)
void PR_RestoreAll (void)
{
HRESULT ddrval;

 ddrval = IDirectDrawSurface2_Restore (wgtpdds);

 if (ddrval != DD_OK)
   return;

  firstdraw = 1;
  InitMenu ();
  PR_LostSurface = 0;
}
#endif



void program_loop (void)
/* Controls the user input */
{
PR_DWORD choice;
PR_DWORD quit;

  quit = 0;
  PRGUI_ShowMouse ();

  while (!quit)
   {
#ifdef WIN32
          UpdateMessages ();
#endif

#if defined (MSDD) || defined (WTDD)
   if (PR_LostSurface)
     PR_RestoreAll ();
#endif

    PRGUI_DrawMouse ();

    if ((PRGUI_HitButton (MATERIALS)) && (editmode != MATERIALMODE))
      {
       PRGUI_HideMouse ();
       editmode = MATERIALMODE;
       InitMenu ();
       PRGUI_ShowMouse ();
      }
    else if ((PRGUI_HitButton (TEXTURES)) && (editmode != TEXTUREMODE))
      {
       PRGUI_HideMouse ();
       editmode = TEXTUREMODE;
       InitMenu ();
       PRGUI_ShowMouse ();
      }
    else if ((PRGUI_HitButton (TABLES)) && (editmode != TABLEMODE))
      {
       PRGUI_HideMouse ();
       editmode = TABLEMODE;
       InitMenu ();
       PRGUI_ShowMouse ();
      }


    if (editmode == MATERIALMODE)
      {
       if ((PRGUI_HitButton (MATMINUS)) && (matnum > 0))
         {
          matnum--;
          mater = &PR_ObjectMaterialList[matnum];
          PRGUI_HideMouse ();
          InitMenu ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATPLUS)) && (matnum < maxmat-1))
         {
          matnum++;
          mater = &PR_ObjectMaterialList[matnum];
          PRGUI_HideMouse ();
          InitMenu ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMETHMINUS)) && (mater->render_method > 0))
         {
          mater->render_method--;
          PRGUI_HideMouse ();
          Show_MatMethod ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMETHPLUS)) && (mater->render_method < MAXMETHOD-1))
         {
          mater->render_method++;
          PRGUI_HideMouse ();
          Show_MatMethod ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATTEXMINUS)) && (mater->texture_number > PR_Settings.FirstTexture))
         {
          mater->texture_number--;
          PRGUI_HideMouse ();
          Show_MatTexNum ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATTEXPLUS)) && (mater->texture_number < maxtex-1 + PR_Settings.FirstTexture))
         {
          mater->texture_number++;
          PRGUI_HideMouse ();
          Show_MatTexNum ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATBASEMINUS)) && (mater->base_color > 0))
         {
          mater->base_color--;
          PRGUI_HideMouse ();
          Show_MatBase ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (1);
         }
       else if ((PRGUI_HitButton (MATBASEPLUS)) && (mater->base_color < 255))
         {
          PR_Flip (1);
          mater->base_color++;
          PRGUI_HideMouse ();
          Show_MatBase ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (1);
         }
       else if ((PRGUI_HitButton (MATSHADEMINUS)) && (mater->render_shades > 0))
         {
          mater->render_shades--;
          PRGUI_HideMouse ();
          Show_MatShade ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (1);
         }
       else if ((PRGUI_HitButton (MATSHADEPLUS)) && (mater->render_shades < 255))
         {
          mater->render_shades++;
          PRGUI_HideMouse ();
          Show_MatShade ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (1);
         }
       else if ((PRGUI_HitButton (MATTABLEMINUS)) && (mater->shadetable > 0))
         {
          mater->shadetable--;
          PRGUI_HideMouse ();
          Show_MatTable ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATTABLEPLUS)) && (mater->shadetable < maxtab-1))
         {
          mater->shadetable++;
          PRGUI_HideMouse ();
          Show_MatTable ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if (PRGUI_HitButton (ENVMAPBUT))
         {
          mater->environment_map = !mater->environment_map;
          PRGUI_HideMouse ();
          Show_MatEnvMap ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if (PRGUI_HitButton (ENVAXISBUT))
         {
          mater->environment_axis++;
          if (mater->environment_axis > 2)
            mater->environment_axis = 0;
          PRGUI_HideMouse ();
          Show_MatEnvAxis ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if (PRGUI_HitButton (MIPMAPBUT))
         {
          mater->MipMap = !mater->MipMap;
          PRGUI_HideMouse ();
          Show_MatMipMap ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMIP1MINUS)) && (mater->MipMaterial1 > 0))
         {
          mater->MipMaterial1--;
          PRGUI_HideMouse ();
          Show_MatMipMap1 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMIP1PLUS)) && (mater->MipMaterial1 < maxmat-1))
         {
          mater->MipMaterial1++;
          PRGUI_HideMouse ();
          Show_MatMipMap1 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMIP2MINUS)) && (mater->MipMaterial2 > 0))
         {
          mater->MipMaterial2--;
          PRGUI_HideMouse ();
          Show_MatMipMap2 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMIP2PLUS)) && (mater->MipMaterial2 < maxmat-1))
         {
          mater->MipMaterial2++;
          PRGUI_HideMouse ();
          Show_MatMipMap2 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMIP3MINUS)) && (mater->MipMaterial3 > 0))
         {
          mater->MipMaterial3--;
          PRGUI_HideMouse ();
          Show_MatMipMap3 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMIP3PLUS)) && (mater->MipMaterial3 < maxmat-1))
         {
          mater->MipMaterial3++;
          PRGUI_HideMouse ();
          Show_MatMipMap3 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMIP4MINUS)) && (mater->MipMaterial4 > 0))
         {
          mater->MipMaterial4--;
          PRGUI_HideMouse ();
          Show_MatMipMap4 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMIP4PLUS)) && (mater->MipMaterial4 < maxmat-1))
         {
          mater->MipMaterial4++;
          PRGUI_HideMouse ();
          Show_MatMipMap4 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMSH1MINUS)) && (mater->MipShift1 > 0))
         {
          mater->MipShift1--;
          PRGUI_HideMouse ();
          Show_MatMipShift1 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMSH1PLUS)) && (mater->MipShift1 < 15))
         {
          mater->MipShift1++;
          PRGUI_HideMouse ();
          Show_MatMipShift1 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMSH2MINUS)) && (mater->MipShift2 > 0))
         {
          mater->MipShift2--;
          PRGUI_HideMouse ();
          Show_MatMipShift2 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMSH2PLUS)) && (mater->MipShift2 < 15))
         {
          mater->MipShift2++;
          PRGUI_HideMouse ();
          Show_MatMipShift2 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMSH3MINUS)) && (mater->MipShift3 > 0))
         {
          mater->MipShift3--;
          PRGUI_HideMouse ();
          Show_MatMipShift3 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMSH3PLUS)) && (mater->MipShift3 < 15))
         {
          mater->MipShift3++;
          PRGUI_HideMouse ();
          Show_MatMipShift3 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMSH4MINUS)) && (mater->MipShift4 > 0))
         {
          mater->MipShift4--;
          PRGUI_HideMouse ();
          Show_MatMipShift4 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (MATMSH4PLUS)) && (mater->MipShift4 < 15))
         {
          mater->MipShift4++;
          PRGUI_HideMouse ();
          Show_MatMipShift4 ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (COLRMINUS)) && (mater->r > 0))
         {
          mater->r--;
          PRGUI_HideMouse ();
          Show_ColR ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (1);
         }
       else if ((PRGUI_HitButton (COLRPLUS)) && (mater->r < 255))
         {
          mater->r++;
          PRGUI_HideMouse ();
          Show_ColR ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (1);
         }
       else if ((PRGUI_HitButton (COLGMINUS)) && (mater->g > 0))
         {
          mater->g--;
          PRGUI_HideMouse ();
          Show_ColG ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (1);
         }
       else if ((PRGUI_HitButton (COLGPLUS)) && (mater->g < 255))
         {
          mater->g++;
          PRGUI_HideMouse ();
          Show_ColG ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (1);
         }
       else if ((PRGUI_HitButton (COLBMINUS)) && (mater->b > 0))
         {
          mater->b--;
          PRGUI_HideMouse ();
          Show_ColB ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (1);
         }
       else if ((PRGUI_HitButton (COLBPLUS)) && (mater->b < 255))
         {
          mater->b++;
          PRGUI_HideMouse ();
          Show_ColB ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (1);
         }
       else if ((PRGUI_HitButton (COLAMINUS)) && (mater->a > 0))
         {
          mater->a--;
          PRGUI_HideMouse ();
          Show_ColA ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (1);
         }
       else if ((PRGUI_HitButton (COLAPLUS)) && (mater->a < 255))
         {
          mater->a++;
          PRGUI_HideMouse ();
          Show_ColA ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (1);
         }
       else if ( (PRGUI_HitButton (ADD)) ||
                 ((PRGUI_HitButton (MATNAME)) && (mater->name == NULL)))
         {
          PR_OpenScreen (PR_FRONTBUFFER);
          choice = !PRGUI_ChoiceDialog ("Are you sure you want to ADD",
                        "a new material?", NULL, "Yes", "No");
          if (choice)
            {
             PRGUI_HideMouse ();
             AddNewMaterial ();
             PRGUI_ShowMouse ();
            }
          noclick ();
         }
       else if (PRGUI_HitButton (MATNAME))
         {
          PRGUI_HideMouse ();
          uninstallkbd ();
          PRGUI_editstring (140, 59, 365, 70, mater->name, legalname, 22);
          installkbd ();
          PRGUI_ShowMouse ();
          noclick ();
         }
       else if (PRGUI_HitButton (DELETEBUT))
         {
          PR_OpenScreen (PR_FRONTBUFFER);
          choice = !PRGUI_ChoiceDialog ("Are you sure you want to DELETE",
                        "this material?", NULL, "Yes", "No");
          if (choice)
            {
             PRGUI_HideMouse ();

             memset (mater, 0, sizeof (PR_MATERIAL));
             InitMenu ();
             PRGUI_ShowMouse ();
            }
          noclick ();
         }


      } /* material mode */
    else if (editmode == TEXTUREMODE)
      {
       if ((PRGUI_HitButton (TEXMINUS)) && (texnum > PR_Settings.FirstTexture))
         {
          texnum--;
          tex = &PR_WorldTextures[texnum];
          PRGUI_HideMouse ();
          InitMenu ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (TEXPLUS)) && (texnum < maxtex-1 + PR_Settings.FirstTexture))
         {
          texnum++;
          tex = &PR_WorldTextures[texnum];
          PRGUI_HideMouse ();
          InitMenu ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ( (PRGUI_HitButton (ADD)) ||
                 ((PRGUI_HitButton (TEXNAME)) && (tex->filename == NULL)))
         {
          PR_OpenScreen (PR_FRONTBUFFER);
          choice = !PRGUI_ChoiceDialog ("Are you sure you want to ADD",
                        "a new texture?", NULL, "Yes", "No");
          if (choice)
            {
             PRGUI_HideMouse ();
             AddNewTexture ();
             PRGUI_ShowMouse ();
            }
          noclick ();
         }
       else if (PRGUI_HitButton (TEXNAME))
         {
          PRGUI_HideMouse ();
          uninstallkbd ();
          strcpy (workname, tex->filename);
          PRGUI_editstring (140, 59, 365, 70, workname, legalname, 12);
          free (tex->filename);
          tex->filename = strdup (workname);

          installkbd ();
          PRGUI_ShowMouse ();
          noclick ();
         }
       else if (PRGUI_HitButton (DELETEBUT))
         {
          PR_OpenScreen (PR_FRONTBUFFER);
          choice = !PRGUI_ChoiceDialog ("Are you sure you want to DELETE",
                        "this texture?", NULL, "Yes", "No");
          if (choice)
            {
             PRGUI_HideMouse ();
             free (tex->filename);
             memset (tex, 0, sizeof (PR_TEXTURE));
             InitMenu ();
             PRGUI_ShowMouse ();
            }
          noclick ();
         }


       }
    else if (editmode == TABLEMODE)
      {
       if ((PRGUI_HitButton (TABMINUS)) && (tabnum > 0))
         {
          tabnum--;
          tab = &PR_ShadeTables[tabnum];
          PRGUI_HideMouse ();
          InitMenu ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ((PRGUI_HitButton (TABPLUS)) && (tabnum < maxtab-1))
         {
          tabnum++;
          tab = &PR_ShadeTables[tabnum];
          PRGUI_HideMouse ();
          InitMenu ();
          PRGUI_ShowMouse ();
          if (mouse.but == 1)
            noclick ();
          else
            PRGUI_WaitTicks (3);
         }
       else if ( (PRGUI_HitButton (ADD)) ||
                 ((PRGUI_HitButton (TABNAME)) && (tab->name == NULL)))
         {
          PR_OpenScreen (PR_FRONTBUFFER);
          choice = !PRGUI_ChoiceDialog ("Are you sure you want to ADD",
                        "a new shade table?", NULL, "Yes", "No");
          if (choice)
            {
             PRGUI_HideMouse ();
             AddNewTable ();
             PRGUI_ShowMouse ();
            }
          noclick ();
         }
       else if (PRGUI_HitButton (TABNAME))
         {
          PRGUI_HideMouse ();
          uninstallkbd ();
          strcpy (workname, tab->name);
          PRGUI_editstring (140, 59, 365, 70, workname, legalname, 12);
          free (tab->name);
          tab->name = strdup (workname);

          installkbd ();
          PRGUI_ShowMouse ();
          noclick ();
         }
       else if (PRGUI_HitButton (DELETEBUT))
         {
          PR_OpenScreen (PR_FRONTBUFFER);
          choice = !PRGUI_ChoiceDialog ("Are you sure you want to DELETE",
                        "this shade table?", NULL, "Yes", "No");
          if (choice)
            {
             PRGUI_HideMouse ();
             free (tab->name);
             memset (tab, 0, sizeof (PR_TABLE));
             InitMenu ();
             PRGUI_ShowMouse ();
            }
          noclick ();
         }


       }

    if (PRGUI_HitButton (QUIT))
      {
       PR_OpenScreen (PR_FRONTBUFFER);
       quit = !PRGUI_ChoiceDialog ("Are you sure you want to quit?",
                     NULL, NULL, "Yes", "No");
       noclick ();
      }
    else if (PRGUI_HitButton (SAVE))
      {
       PR_OpenScreen (PR_FRONTBUFFER);
       choice = !PRGUI_ChoiceDialog ("Are you sure you want to save your changes?",
                     "(Data may be lost)", NULL, "Yes", "No");
       if (choice)
         {
          Fix_EnvMap (object);
          PRGUI_GoUserPath ();
          PR_SavePRO (objectfile, object, SAVE_ALL_MATERIALS);
         }
       noclick ();
      }


     }

  PRGUI_HideMouse ();
}



void InitializeDevices (void)
{
#ifdef __MYST__
  if ((device == DEVICE_MYSTIQUE) || (device == DEVICE_ANY))
    device = PR_DetectMystique ();
#endif

#ifdef __3DFX__
  if ((device == DEVICE_3DFX) || (device == DEVICE_ANY))
    device = PR_Detect3Dfx ();
#endif

#if !defined (MSGLIDE) && !defined (WTGLIDE)
  if ((device == DEVICE_SVGA) || (device == DEVICE_ANY))
    device = PR_DetectSVGA ();   /* Attempt to find the device */

  if ((device == DEVICE_VGA) || (device == DEVICE_ANY))
    device = PR_DetectVGA ();   /* Attempt to find the device */
#endif

#ifdef __MYST__
  if (device == DEVICE_MYSTIQUE)
    {
     PR_InitializeMystique ();
     atexit (PR_ShutdownMystique);
    }
#endif


#ifdef __3DFX__
  if (device == DEVICE_3DFX)
    {
     PR_Initialize3Dfx ();
     atexit (PR_Shutdown3Dfx);
    }
#endif

#if !defined (MSGLIDE) && !defined (WTGLIDE)
  if (device == DEVICE_SVGA)
    {
     PR_InitializeSVGA ();
     atexit (PR_ShutdownSVGA);
    }
  else if (device == DEVICE_VGA)
    {
     PR_InitializeVGA ();
     atexit (PR_ShutdownVGA);
    }
#endif

}





void main (int argc, char *argv[])
{
//  PR_SetDebugFile ("debug", REPORT_ERRORS | REPORT_ACTIONS);
  PRGUI_InitPath (argv[0]);

  
  
  if (argc < 2)
    {
         PR_FatalError ("EDITMAT Utility    version "
                        PR_VERSION_NUMBER
                        "\nCopyright 1997 Egerter Software\n\n"
                        "Usage: \n"
                        "EDITMAT filename.PRO\n", "EDITMAT");
    }

  printf ("EDITMAT Utility    version ");
  printf (PR_VERSION_NUMBER);
  printf ("\nCopyright 1997 Egerter Software\n\n");

#ifndef WIN32
  while (kbhit ())
    getch ();

#if defined (__3DFX__) || defined (__MYST__)
  printf ("Use 3D hardware? (y/n)\n");
  device = getch ();
#endif
#endif

  PR_Initialize (7500);

#if defined (MSGLIDE) || defined (WTGLIDE)
  device = DEVICE_3DFX;
#else
#if defined (__3DFX__) || defined (__MYST__)
  if (device == 'y' || device == 'Y')
    device = DEVICE_ANY;
  else
#endif
    device = DEVICE_SVGA;
#endif

  InitializeDevices ();

  PR_AllocMaterials (512);
  PR_AllocShadeTables (32);
  PR_AllocTextures (256);

  PRGUI_GoStartPath ();
  setlib ("guidata.prl");

#if defined (MSGLIDE) || defined (WTGLIDE)
    PRGUI_Initialize3Dfx ();
#else
#ifdef __3DFX__
  if (device == DEVICE_3DFX)
    PRGUI_Initialize3Dfx ();
  else
#endif
#ifdef __MYST__
  if (device == DEVICE_MYSTIQUE)
    PRGUI_InitializeMystique ();
  else
#endif
    PRGUI_InitializeSVGA ();
#endif

  PRGUI_GoUserPath ();
  setlib (NULL);

  strcpy (objectfile, argv[1]);

  object = PR_LoadPRO (argv[1], LOAD_NORMAL);
  if (object == NULL)
    PR_FatalError ("An error has occurred when loading the PRO file.", "EDITMAT");

  maxmat = LPRO_ImportMaterialCount;
  maxtex = LPRO_ImportTextureCount;
  maxtab = LPRO_ImportTableCount;

  PRGUI_InitTimer ();
  texnum = PR_Settings.FirstTexture;

  installkbd ();
  InitMenu ();

  program_loop ();

  uninstallkbd ();
  PRGUI_DeinitTimer ();
}



