#include <stdlib.h>
#include <direct.h>
#include <string.h>

#include <pr.h>
#include <prgui.h>

#if defined (MSGLIDE) || defined (WTGLIDE)
#include <pr3dfx.h>
#include <windows.h>
#endif


/*

       /=========\ /========\ ||        || /========  /=======\
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||   ||   || ||         ||      //
       |=========/ ||      || ||   ||   || |=======   |=====<<
       ||          ||      || ||   ||   || ||         ||      \\
       ||          ||      || ||   ||   || ||         ||       ||
       ||          ||      || ||   ||   || ||         ||       ||
       ||          \========/ \==========/ \========= ||       ||

--------------------------------<===>----------------------------------

    /=======\   /========= |\     || |======\  /========= /=======\
    ||      ||  ||         ||\    || ||    \ \ ||         ||      ||
    ||      ||  ||         || \   || ||     || ||         ||      ||
    ||      ||  ||         ||  \  || ||     || ||         ||      ||
    ||      //  ||         ||   \ || ||     || ||         ||      //
    |======<<   |======    ||\   \|| ||     || |======    |======<<
    ||      \\  ||         || \   || ||     || ||         ||      \\
    ||       || ||         ||  \  || ||     || ||         ||       ||
    ||       || ||         ||   \ || ||    / / ||         ||       ||
    ||       || |========= ||    \|| |======/  |========= ||       ||

Object Flag Setting Utility

Sets the flags for every face in the object.  Used for setting
front/back visibility.

 Revision History:
 October 6, 1996: Created

*/

char outfile[80];               /* Name of the output file */
PR_OBJECT *object1;


void main (int argc, char *argv[])
{
PR_DWORD flags;

  PRGUI_InitPath (argv[0]);


  if (argc < 3)
    {
     PR_FatalError (
                "Objflag Utility    version "
                PR_VERSION_NUMBER
                "\nCopyright 1997 Egerter Software\n\n"
		"Usage: \n"
        "Objflag file1.PRO file2.PRO\n", "OBJFLAG");
    }

  printf ("Objflag Utility    version ");
  printf (PR_VERSION_NUMBER);
  printf ("\nCopyright 1997 Egerter Software\n\n");

  flags = 0;
  #ifdef WIN32
     if (MessageBox(NULL, "Front Visible?",
                 "OBJFLAG", MB_YESNO) == IDYES)
		flags = 1;
	 if (MessageBox(NULL, "Back Visible?",
                 "OBJFLAG", MB_YESNO) == IDYES)
		flags += 2;
  #else
  printf ("Choose (1) Front visible\n"
          "       (2) Back visible\n"
          "       (3) Front and back visible\n"
          "           Any other number to abort\n");
  scanf ("%i", &flags);
  #endif

  PR_Initialize (50);

#if defined (MSGLIDE) || defined (WTGLIDE)
  PR_Detect3Dfx ();
  PR_Initialize3Dfx ();
#else
  PR_DetectVGA();
  PR_InitializeVGA ();
#endif

  PR_AllocMaterials (512);
  PR_AllocTextures (255);
  PR_AllocShadeTables (32);

  object1 = PR_LoadPRO (argv[1], LOAD_NORMAL);
  if (object1 == NULL)
     PR_FatalError ("An error has occurred when loading the file.\n", "OBJFLAG");
     
  if (flags == 1)
    {
     flags = FFLAG_FRONT_VISIBLE;
    }
  else if (flags == 2)
    {
     flags = FFLAG_BACK_VISIBLE;
    }
  else if (flags == 3)
    {
     flags = FFLAG_FRONT_VISIBLE | FFLAG_BACK_VISIBLE;
    }
  else
    {
     printf ("Invalid option.  Aborting...\n");
     exit (1);
    }

  PR_SetObjectFaceFlags (object1, flags,
                         FLAG_COPY);
  /* Sets the flags of all faces within an object */

  PR_SavePRO (argv[2], object1, SAVE_ALL_MATERIALS);
}



