#include <stdlib.h>
#include <stdio.h>

#include <conio.h>
#include <ctype.h>

#include <pr.h>
#include <prgui.h>

#ifdef WIN32
 #include <windows.h>
#endif


/*

       /=========\ /========\ ||        || /========  /=======\
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||   ||   || ||         ||      //
       |=========/ ||      || ||   ||   || |=======   |=====<<
       ||          ||      || ||   ||   || ||         ||      \\
       ||          ||      || ||   ||   || ||         ||       ||
       ||          ||      || ||   ||   || ||         ||       ||
       ||          \========/ \==========/ \========= ||       ||

--------------------------------<===>----------------------------------

    /=======\   /========= |\     || |======\  /========= /=======\
    ||      ||  ||         ||\    || ||    \ \ ||         ||      ||
    ||      ||  ||         || \   || ||     || ||         ||      ||
    ||      ||  ||         ||  \  || ||     || ||         ||      ||
    ||      //  ||         ||   \ || ||     || ||         ||      //
    |======<<   |======    ||\   \|| ||     || |======    |======<<
    ||      \\  ||         || \   || ||     || ||         ||      \\
    ||       || ||         ||  \  || ||     || ||         ||       ||
    ||       || ||         ||   \ || ||    / / ||         ||       ||
    ||       || |========= ||    \|| |======/  |========= ||       ||

Save Mesh Utility

Saves the vertices from a PRO file without texture information.

 Revision History:
 Aug 6, 1996: Created

*/

char outfile[80];               /* Name of the output file */
PR_OBJECT *object1;
PR_DWORD choice;

void PR_SaveMesh (PR_OBJECT *obj, char *filename)
{
FILE *out;
PR_DWORD segnum;
PR_SEGMENT *seg;

  out = fopen (filename, "wb");
  if (out == NULL)
    {
     printf ("Could not create %s\n", filename);
     exit (1);
    }

  fwrite (&obj->num_segments, sizeof (PR_DWORD), 1, out);
  for (segnum = 0; segnum < obj->num_segments; segnum++)
    {
     seg = obj->segment_list;
     fwrite (&seg->num_vertices, sizeof (PR_DWORD), 1, out);
     fwrite (seg->vertex_list, sizeof (PR_VERTEX) * seg->num_vertices, 1, out);
    }

  fclose (out);
}



void main (int argc, char *argv[])
{

  PRGUI_InitPath (argv[0]);

  if (argc < 3)
    {
	 PR_FatalError (
                "SAVEMESH Utility    version "
                PR_VERSION_NUMBER
                "\nCopyright 1997 Egerter Software\n\n"
		"Usage: \n"
        "SAVEMESH filename.PRO mesh.PRM\n", "SAVEMESH");
    }

  printf ("SAVEMESH Utility    version ");
  printf (PR_VERSION_NUMBER);
  printf ("\nCopyright 1997 Egerter Software\n\n");

  if (PRGUI_FileExists (argv[2]))
    {
     #ifdef WIN32
     if (MessageBox(NULL, "The file already exists! Overwrite?\n",
                 "SAVEMESH", MB_OKCANCEL) != IDOK)
		exit (1);
	 #else
    
	 printf ("%s already exists! Overwrite? (Y/N)\n",
            argv[2]);
     do {
       choice = toupper (getch ());
     } while (choice != 'N' && choice != 'Y');

     if (choice == 'N')
       exit (1);
	#endif
    }

  PR_Initialize (50);

#if defined (MSGLIDE) || defined (WTGLIDE)
  PR_Detect3Dfx();
  PR_Initialize3Dfx ();
#else
  PR_DetectVGA();
  PR_InitializeVGA ();
#endif

  PR_AllocMaterials (512);
  PR_AllocTextures (255);
  PR_AllocShadeTables (32);

  object1 = PR_LoadPRO (argv[1], LOAD_NORMAL);
  if (object1 == NULL)
    PR_FatalError ("An error has occurred when loading the file.\n", "SAVEMESH");
     
  
  PR_SaveMesh (object1, argv[2]);
  printf ("%s mesh saved as %s", argv[1], argv[2]);
}



