#ifndef _PRGUI_            
#define _PRGUI_           /* Mark this header already included */

#ifdef __cplusplus
 extern "C" {
#endif

/* Custom mouse handler variables */
extern PR_DWORD mouse_xscale;
extern PR_DWORD mouse_yscale;
extern PR_DWORD mouse_last_event_x;
extern PR_DWORD mouse_last_event_y;
extern PR_DWORD mouse_cursor_handle;
extern PR_DWORD mouse_width;
extern PR_DWORD mouse_height;
extern PR_DWORD mouse_size;
extern block mouse_preserve[2];
extern block mouse_cursor;
extern PR_UCHAR mouse_cursor_on;
#define STANDARD_CURSOR "mcurs1.blk"

extern PR_DWORD GUI_BLACK;
extern PR_DWORD GUI_GREY1;
extern PR_DWORD GUI_GREY2;
extern PR_DWORD GUI_GREY3;
extern PR_DWORD GUI_WHITE;
extern PR_DWORD GUI_RED;

extern wgtfont gui_font;
extern color gui_palette[256];

/* Directory Services */
extern char origpath[_MAX_DIR];
extern char userpath[_MAX_DIR];
extern unsigned origdisk;
extern unsigned userdisk;
extern char path[_MAX_PATH];
extern char drive[_MAX_DRIVE],dir[_MAX_DIR],name[_MAX_FNAME],ext[_MAX_EXT];

/* Timer services */
extern PR_DWORD timer_ticks;




void PRGUI_Button (PR_DWORD x1, PR_DWORD y1, PR_DWORD x2, PR_DWORD y2);
/* -----------------------------------------------------------------------
   Function:   PRGUI_Button
   Purpose:    Draws a 3D button in SVGA mode
   Parameters: x1,y1,x2,y1 - Rectagular button region
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PRGUI_ChoiceDialog (char *line1, char *line2, char *line3,
                             char *opt1, char *opt2);
/* -----------------------------------------------------------------------
   Function:   PRGUI_ChoiceDialog
   Purpose:    Display a dialog where the user can pick from two choices 
   Parameters: line1 - First line in box
               line2 - Second line in box
               line3 - Third line in box
               opt1 - Option box string 1
               opt2 - Option box string 2
   Return:     0 for choice one
               1 for choice two
   ----------------------------------------------------------------------- */


void PRGUI_DeinitTimer (void);
/* -----------------------------------------------------------------------
   Function:   PRGUI_DeinitTimer
   Purpose:    Deinitializes the timer services 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_DrawMouseVGA (void);
/* -----------------------------------------------------------------------
   Function:   PRGUI_DrawMouseVGA
   Purpose:    Updates the cursor image 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_DrawMouseSVGA (void);
/* -----------------------------------------------------------------------
   Function:   PRGUI_DrawMouseSVGA
   Purpose:    Updates the cursor image 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_editstring (PR_DWORD x1, PR_DWORD y1, PR_DWORD x2,
                       PR_DWORD y2, char *string, char *legal,
                       PR_DWORD maxlength);
/* -----------------------------------------------------------------------
   Function:   PRGUI_editstring
   Purpose:    Edits a string using arrow keys, insert, home, etc 
   Parameters: x1,y1,x2,y2 - Rectangular edit box
               string - Original string
               legal - Contains all legal characters when typing
               maxlength - Maximum length of string
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_Error (char *string);
/* -----------------------------------------------------------------------
   Function:   PRGUI_Error
   Purpose:    Returns to text mode, prints an error message and halts 
   Parameters: string - Error string to print
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PRGUI_FileExists (char *filename);
/* -----------------------------------------------------------------------
   Function:   PRGUI_FileExists
   Purpose:    Checks if a file exists on the disk
   Parameters: filename - Name of the file to check
   Return:     TRUE if a file exists 
   ----------------------------------------------------------------------- */


void PRGUI_GoStartPath (void);
/* -----------------------------------------------------------------------
   Function:   PRGUI_GoStartPath
   Purpose:    Changes to the directory where the program started from 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_GoUserPath (void);
/* -----------------------------------------------------------------------
   Function:   PRGUUI_GoUserPath
   Purpose:    Returns to the drive and path where the user's data is 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_HideMouseVGA (void);
/* -----------------------------------------------------------------------
   Function:   PRGUI_HideMouseVGA
   Purpose:    Turns the cursor image off 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_HideMouseSVGA (void);
/* -----------------------------------------------------------------------
   Function:   PRGUI_HideMouseSVGA
   Purpose:    Turns the cursor image off 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PRGUI_HitButton (PR_DWORD x1, PR_DWORD y1, PR_DWORD x2, PR_DWORD y2);
/* -----------------------------------------------------------------------
   Function:   PRGUI_HitButton
   Purpose:    Returns true if you clicked in a region 
   Parameters: x1,y1,x2,y2 - Rectangular button region
   Return:     TRUE or FALSE
   ----------------------------------------------------------------------- */


void PRGUI_InitPath (char *startpath);
/* -----------------------------------------------------------------------
   Function:   PRGUI_InitPath
   Purpose:    Remembers the path where the program was run 
   Parameters: startpath - Starting path of program
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_InitializeSVGA (void);
/* -----------------------------------------------------------------------
   Function:   PRGUI_InitializeSVGA
   Purpose:    Initializes to 640x480x256 and starts the custom mouse driver 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_InitMouseVGA (void);
/* -----------------------------------------------------------------------
   Function:   PRGUI_InitMouseVGA
   Purpose:    Initializes the custom SVGA mouse handler 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_InitTimer (void);
/* -----------------------------------------------------------------------
   Function:   PRGUI_InitTimer
   Purpose:    Initializes the timer services  (70Hz)
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_LoadCursorVGA (char *filename);
/* -----------------------------------------------------------------------
   Function:   PRGUI_LoadCursorVGA
   Purpose:    Loads the image of the mouse cursor (can be any size) 
   Parameters: filename - Name of .BLK file for cursor
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_printf (PR_DWORD x, PR_DWORD y, char *fmt, ...);
/* -----------------------------------------------------------------------
   Function:   PRGUI_printf
   Purpose:    Prints using a custom font in SVGA 
   Parameters: x,y - Location on screen
               fmt - Formatting string
               ... - parameters
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_ReadMouse (PR_WORD *mx, PR_WORD *my);
/* -----------------------------------------------------------------------
   Function:   PRGUI_ReadMouse
   Purpose:    Returns the coordinates of the mouse 
   Parameters: mx, my - Pointer to mouse coordinates
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_SetUserPath (void);
/* -----------------------------------------------------------------------
   Function:   PRGUI_SetUserPath
   Purpose:    Changes the user path to the current path 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_ShowMouseVGA (void);
/* -----------------------------------------------------------------------
   Function:   PRGUI_ShowMouseVGA
   Purpose:    Turns the cursor image on 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_ShowMouseSVGA (void);
/* -----------------------------------------------------------------------
   Function:   PRGUI_ShowMouseSVGA
   Purpose:    Turns the cursor image on 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */

                              
void PRGUI_ShutdownSVGA (void);
/* -----------------------------------------------------------------------
   Function:   PRGUI_ShutdownSVGA
   Purpose:    Deinitializes to text mode and shuts off the custom
               mouse interrupt
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_textbutton (PR_DWORD x1, PR_DWORD y1, PR_DWORD x2, PR_DWORD y2,
                       char *string);
/* -----------------------------------------------------------------------
   Function:   PRGUI_textbutton
   Purpose:    Draws a 3D button with a string in the center 
   Parameters: x1,y1,x2,y2 - Rectangular region
               string - String to show centered in the box
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_WaitTicks (PR_DWORD count);
/* -----------------------------------------------------------------------
   Function:   PRGUI_WaitTicks
   Purpose:    Waits for the given number of ticks to pass 
   Parameters: count - Number of ticks
   Return:     None
   ----------------------------------------------------------------------- */


void PRGUI_WaitTicksWithBreak (PR_DWORD count);
/* -----------------------------------------------------------------------
   Function:   PRGUI_WaitTicksWithBreak
   Purpose:    Waits for the given number of ticks to pass, or until a key
               is hit
   Parameters: count - Number of ticks
   Return:     None
   ----------------------------------------------------------------------- */



/* Virtual Functions */
#define PRGUI_InitMouse (*PRVIRT_InitMouse)
extern void (*PRVIRT_InitMouse)(void);

#define PRGUI_DrawMouse (*PRVIRT_DrawMouse)
extern void (*PRVIRT_DrawMouse)(void);

#define PRGUI_ShowMouse (*PRVIRT_ShowMouse)
extern void (*PRVIRT_ShowMouse)(void);

#define PRGUI_HideMouse (*PRVIRT_HideMouse)
extern void (*PRVIRT_HideMouse)(void);

#define PRGUI_LoadCursor (*PRVIRT_LoadCursor)
extern void (*PRVIRT_LoadCursor)(char *filename);

#ifdef __cplusplus
}
#endif

#endif



