#ifndef _PRVIRT_            
#define _PRVIRT_         /* Mark this header already included */

#ifdef __cplusplus
 extern "C" {
#endif


void PR_InitializeVGA (void);
void PR_InitializeSVGA (void);
void PR_InitializeDDraw (void);
/* -----------------------------------------------------------------------
   Function:   PR_InitializeDDraw
   Purpose:    Initialize the virtual functions for DirectDraw
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


#define PR_SetMode (*PRVIRT_SetMode)
extern PR_DWORD (*PRVIRT_SetMode)(PR_DWORD width, PR_DWORD height, PR_DWORD refrate);

#define PR_BeginScreen (*PRVIRT_BeginScreen)
extern void (*PRVIRT_BeginScreen)(void);

#define PR_EndScreen (*PRVIRT_EndScreen)
extern void (*PRVIRT_EndScreen)(void);

#define PR_OpenScreen (*PRVIRT_OpenScreen)
extern void (*PRVIRT_OpenScreen)(PR_DWORD screen);

#define PRGFX_ClearScreen (*PRVIRT_ClearScreen)
extern void (*PRVIRT_ClearScreen)(void);

#define PR_RenderFrame (*PRVIRT_RenderFrame)
extern void (*PRVIRT_RenderFrame)(void);

#define PRGFX_Clip (*PRVIRT_Clip)
extern void (*PRVIRT_Clip)(PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);

#define PRGFX_SetColor (*PRVIRT_SetColor)
extern void (*PRVIRT_SetColor)(PR_DWORD col);

#define PRGFX_Bar (*PRVIRT_Bar)
extern void (*PRVIRT_Bar)(PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);

#define PRGFX_Rectangle (*PRVIRT_Rectangle)
extern void (*PRVIRT_Rectangle)(PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);

#define PRGFX_Line (*PRVIRT_Line)
extern void (*PRVIRT_Line)(PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);

#define PRGFX_VLine (*PRVIRT_VLine)
extern void (*PRVIRT_VLine)(PR_DWORD x0, PR_DWORD y0, PR_DWORD y1);

#define PRGFX_HLine (*PRVIRT_HLine)
extern void (*PRVIRT_HLine)(PR_DWORD x0, PR_DWORD x1, PR_DWORD y0);

#define PRGFX_OutTextXY (*PRVIRT_OutTextXY)
extern void (*PRVIRT_OutTextXY)(PR_DWORD x, PR_DWORD y, wgtfont font, char *string);

#define PRGFX_MakeColor (*PRVIRT_MakeColor)
extern PR_UDWORD (*PRVIRT_MakeColor)(PR_DWORD r, PR_DWORD g, PR_DWORD b);

#define PRGFX_NewBlock (*PRVIRT_NewBlock)
extern block (*PRVIRT_NewBlock)(PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);

#define PRGFX_PutBlock (*PRVIRT_PutBlock)
extern void (*PRVIRT_PutBlock)(PR_DWORD x, PR_DWORD y, PR_DWORD width, PR_DWORD height, block buffer);

#define PRGFX_PutBlock8bit (*PRVIRT_PutBlock8bit)
extern void (*PRVIRT_PutBlock8bit) (PR_DWORD x, PR_DWORD y, block src,
                                    color *pal, PR_DWORD method);

#define PR_Flip (*PRVIRT_Flip)
extern void (*PRVIRT_Flip)(PR_DWORD retrace);

#define PR_AddTexture (*PRVIRT_AddTexture)
extern PR_DWORD (*PRVIRT_AddTexture)(char *filename, block image);

#define PR_AllocTextures (*PRVIRT_AllocTextures)
extern void (*PRVIRT_AllocTextures)(PR_DWORD maxtexture);

#define PR_DeleteAllTextures (*PRVIRT_DeleteAllTextures)
extern void (*PRVIRT_DeleteAllTextures)(void);

#define PR_LoadTexture (*PRVIRT_LoadTexture)
extern PR_DWORD (*PRVIRT_LoadTexture)(char *filename);

#define PRGFX_PutTexture (*PRVIRT_PutTexture)
extern void (*PRVIRT_PutTexture)(PR_DWORD x0, PR_DWORD y0, PR_DWORD texnum, PR_DWORD mode);

#define PRGFX_ResizeTexture (*PRVIRT_ResizeTexture)
extern void (*PRVIRT_ResizeTexture)(PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1,
                                    PR_DWORD texnum, PR_DWORD mode);

#define PR_AddElement (*PRVIRT_AddElement)
extern void (*PRVIRT_AddElement)(PR_FACE *elemptr, PR_VERTEX *pointlist,
                        PR_VERTEX_DATA *pointdata, PR_DWORD count);

#define PR_ComputeVertexLighting (*PRVIRT_ComputeVertexLighting)
extern void (*PRVIRT_ComputeVertexLighting)(PR_VERTEX *vptr1,
                               PR_VERTEX *vptr2, 
                               PR_VERTEX *vptr3,
                               PR_VERTEX_DATA *vptr1data,
                               PR_VERTEX_DATA *vptr2data,
                               PR_VERTEX_DATA *vptr3data,
                               PR_RPOINT *renderpoly1,
                               PR_RPOINT *renderpoly2,
                               PR_RPOINT *renderpoly3,
                               PR_FACE *elemptr,
                               PR_MATERIAL *mat,
                               PR_UCHAR MipShift);

#define PR_SetFogColor (*PRVIRT_SetFogColor)
extern void (*PRVIRT_SetFogColor)(PR_DWORD col);

#define PR_SetFogState (*PRVIRT_SetFogState)
extern void (*PRVIRT_SetFogState)(PR_DWORD state);

#define PR_SetFogRange (*PRVIRT_SetFogRange)
extern void (*PRVIRT_SetFogRange)(PR_REAL near_dist, PR_REAL far_dist);


#ifdef __cplusplus
}
#endif

#endif

