#ifndef _WGT95_
#define _WGT95_

/* 
   WordUp Graphics Toolkit 95 Header File
   WATCOM C/C++ Windows 95
   
   Copyright 1997 Egerter Software
*/

#include <stdio.h>
#include <ddraw.h>

#ifdef __cplusplus
 extern "C" {
#endif

typedef IDirectDrawSurface2 * block;
typedef unsigned char * wgtfont;
typedef unsigned short * wgtmap;

/* Text grid settings */
#define TEXTGRID_OFF 0
#define TEXTGRID_ON 1

/* Text transparency settings */
#define TEXTFG 0
#define TEXTBG 1
#define TEXTFGBG 2

/* Image transfer operations */
#define NORMAL 0
#define XRAY 1

/* Flip block operations */
#define VERTICAL 0
#define HORIZONTAL 1

/* Shading operations */
#define SHADE_NORMAL 0
#define SHADE_XRAY 1
#define SHADE_SHADOW 2
#define SHADE_TRANSLUCENT 3
#define SHADE_MONO 4


typedef struct {
  short xres;
  short yres;
  short videomode;
  int   videobanksize;
  short (*bankswitch)(short);
  short screenwidth;
  short screenheight;
} WGT_SYS_STRUCT;

extern WGT_SYS_STRUCT WGT_SYS;

/* A single palette register definition */
typedef struct 
{
  unsigned char r,g,b;
} color;

/* Polygon point definition */
typedef struct
{
  short x,y;   /* Coordinate on the screen */
  short sx,sy; /* Coordinate on the texture if texture is used,
                  otherwise sx = color point */
               /* sx is used for Gouraud shading as well (color of the point) */
} tpolypoint;

/* WGTLIB variables */
extern int lfpos;
extern FILE *libf;                  /* Pointer to library file */  

extern HANDLE libfMapping;          /* Memory mapped file */
extern LPBYTE libfBits;             /* Pointer to memory mapped space */

extern short lresult;
extern int   lsize;
extern char  password[16];
extern char  *wgtlibrary;
extern int   diagnostics_level;

/* Clipping boundaries */
extern short bx,by,tx,ty;

/* Current drawing color */
extern unsigned char currentcolor;

/* Software cursor flashing speed */
extern short curspeed;

/* Software cursor coordinates */
extern short xc,yc;

/* Pointer to the active drawing page */
extern LPBYTE abuf;
extern IDirectDraw2 *wgtpdd;                 /* DirectDraw object */
extern block wgtbltdest;                     /* Active blt destination */

extern IDirectDrawPalette * wgtddpal;  /* Primary Palette */
extern IDirectDrawSurface2 * wgtpdds;   /* DirectDraw primary surface */

#define WGTAPI PASCAL
void WGTAPI putxray (void *dst, void *src, int len);

/* Maintain WGT 5.1 compatibility */
#define TICKS(hz) (hz)
typedef void (*wtimerproc)(void);
extern volatile int    wtimer_time;


/* Function Prototypes */
void   WGTAPI log_message(char *msg);
int    WGTAPI wFileLength (HANDLE hf);
short  WGTAPI checkpassword (char *temp);
void   WGTAPI findfile (char *filename);
void * WGTAPI lib2buf (char *filename);
void   WGTAPI readheader (void);
void   WGTAPI setlib (char *libraryname);
void   WGTAPI setpassword (char *password);
void   WGTAPI vga256 (void);
char   WGTAPI vgadetected (void);
block  WGTAPI wallocblock (int width, int height);
void   WGTAPI wbar (int x1, int y1, int x2, int y2);
void   WGTAPI wbezier (tpolypoint *rawpts, int numraw,
                       tpolypoint *curvepts, int numcurve);
void   WGTAPI wbutt (int x1, int y1, int x2, int y2);
void   WGTAPI wcircle (int x_center, int y_center, int radius);
void   WGTAPI wclip (int x1, int y1, int x2, int y2);
void   WGTAPI wclosescreen (void);
void   WGTAPI wcls (unsigned char col);
void   WGTAPI wclsfill (unsigned char col);
void   WGTAPI wcolrotate (unsigned char start, unsigned char finish,
                          int dir, color *pal);
void   WGTAPI wcopyscreen (int x1, int y1, int x2, int y2,
                 block source, int destx, int desty, block destination);
void   WGTAPI wdissolve (block sourceimage, short *pattern, int speed);
void   WGTAPI wdonetimer (void);
void   WGTAPI wellipse (int x_center, int y_center, int x_radius,
                        int y_radius);
void   WGTAPI wfade_between (unsigned char start, unsigned char finish, int speed,
                      color *pal1, color *pal2);
void   WGTAPI wfade_between_once (unsigned char start, unsigned char finish,
                      color *pal1, color *pal2);
void   WGTAPI wfade_in (unsigned char start, unsigned char finish, int speed,
                 color *pal);
void   WGTAPI wfade_in_once (unsigned char start, unsigned char finish, 
                      color *pal, color *temppal);
void   WGTAPI wfade_out (unsigned char start, unsigned char finish, int speed,
                  color *pal);
void   WGTAPI wfade_out_once (unsigned char start, unsigned char finish,
                       color *pal);
void   WGTAPI wfastputpixel (int x, int y);
void   WGTAPI wfill_circle (int x, int y, int radius);
void   WGTAPI wfill_ellipse (int x_center, int y_center, int x_radius,
                             int y_radius);
void   WGTAPI wflashcursor (void);
void   WGTAPI wfline (int x1, int y1, int x2, int y2);
void   WGTAPI wflipblock (block image, int direction);
void   WGTAPI wfreeblock (block image);
void   WGTAPI wfreefont (wgtfont font);
void   WGTAPI wfreesprites (block *image_array, int start, int end);
void   WGTAPI wgetblockdimensions (block ptr, short *width, short *height);
short  WGTAPI wgetblockheight (block image);
LPBYTE WGTAPI wgetblocksurface (block image, long *pitch);
short  WGTAPI wgetblockwidth (block image);
unsigned char WGTAPI wgetpixel (int x, int y);
short  WGTAPI wgettextheight (char *string, wgtfont font);
short  WGTAPI wgettextwidth (char *string, wgtfont font);
void   WGTAPI wgtprintf (int x, int y, wgtfont font, char *fmt, ... );
void   WGTAPI whline (int x1, int x2, int y);
void   WGTAPI winittimer (void);
void   WGTAPI wline (int x1, int y1, int x2, int y2);
block  WGTAPI wloadblock (char *filename);
block  WGTAPI wloadbmp (char *filename, color *pal);
block  WGTAPI wloadcel (char *filename, color *pal);
wgtfont WGTAPI wloadfont (char *filename);
block  WGTAPI wloadiff (char *filename, color *pal);
block  WGTAPI wloadpak (char *filename);
void   WGTAPI wloadpalette (char *filename, color *pal);
block  WGTAPI wloadpcx (char *filename, color *pal);
short  WGTAPI wloadsprites (color *pal, char *filename, block *image_array,
                            int start, int end);
block  WGTAPI wnewblock (int x1, int y1, int x2, int y2);
void   WGTAPI wnormscreen (void);
void   WGTAPI wopenscreen (void);
short  WGTAPI woutchar (int asc, int xc, int yc, wgtfont pr);
void   WGTAPI wouttextxy (int x, int y, wgtfont font, char *string);
void   WGTAPI wputblock (int x, int y, block image, int method);
void   WGTAPI wputblock_shade (int x, int y, block image,
                               unsigned char *shadetable, int mode);
void   WGTAPI wputpixel (int x, int y);
void   WGTAPI wreadpalette (unsigned char start, unsigned char finish,
                            color *pal);
void   WGTAPI wrectangle (int x1, int y1, int x2, int y2);
void   WGTAPI wregionfill (int x, int y);
void   WGTAPI wremap (color *pal1, block image, color *pal2);
void   WGTAPI wresize (int x1, int y1, int x2, int y2, block image,
                int mode);
void   WGTAPI wresize_column (int x, int y, int y2, block image,
                       int column, int mode);
void   WGTAPI wresize_shade (int x1, int y1, int x2, int y2,
                             block image, unsigned char *shadetable,
                             int mode);
short  WGTAPI wsaveblock (char *filename, block image);
short  WGTAPI wsavebmp (char *filename, block image, color *pal);
short  WGTAPI wsavecel (char *filename, block image, color *pal);
short  WGTAPI wsavepak (char *filename, block image);
void   WGTAPI wsavepalette (char *filename, color *pal);
short  WGTAPI wsavepcx (char *filename, block image, color *pal);
short  WGTAPI wsavesprites (color *pal, char *filename, block *image_array,
                            int start, int end);
void   WGTAPI wsetcolor (int col);
void   WGTAPI wsetcursor (int start, int end);
HRESULT WGTAPI wsetmode (DWORD dwWidth, DWORD dwHeight, DWORD dwBPP, DWORD dwRefreshRate, DWORD dwFlags);
void   WGTAPI wsetpalette (int start, int finish, color *pal);
void   WGTAPI wsetrgb (unsigned char num, unsigned char red,
                       unsigned char green, unsigned char blue, color *pal);
void   WGTAPI wsetscreen (block image);
void   WGTAPI wsettimerspeed (int speed);
void   WGTAPI wskew (int x, int y, block image, int degrees);
void   WGTAPI wsline (int x1, int y1, int x2, int y2, int *y_array);
void   WGTAPI wstarttimer (wtimerproc timer, int speed);
void   WGTAPI wstoptimer (void);
void   WGTAPI wstring (int x, int y, char *string, char *legal,
                       int maxlength);
void   WGTAPI wstyleline (int x, int y, int x2, int y2,
                          unsigned short style);
void   WGTAPI wtextbackground (unsigned char col);
void   WGTAPI wtextcolor (unsigned char col);
void   WGTAPI wtextgrid (int state);
void   WGTAPI wtexttransparent (int mode);
void   WGTAPI wunlocksurface (block image);
void   WGTAPI wvertres (int x1, int y1, int y2, block image);
void   WGTAPI wwarp (int x1, int x2, int *top, int *bot,
                     block image, int mode);
void   WGTAPI wwipe (int x1, int y1, int x2, int y2, block image);
void   WGTAPI wxorbox (int x, int y, int x2, int y2,
                       int col);

void WGTAPI wgt_init_log (void);
void WGTAPI wgt_log_message (char *msg, ... );
LPSTR WGTAPI getErrorString( HRESULT ddrval );

#define DEBUG_LINE wgt_log_message("Source %s   Line %d", __FILE__, __LINE__);


#ifdef __cplusplus
}
#endif

#endif



