//
// Written by: Robert C. Pendleton
// 
// Copyright 1993, 1994 by Robert C. Pendleton, all right reserved
//
// Non-commercial use by individuals is permitted.
//
//

#ifndef _3D_H_
#define _3D_H_

#include "fixed.h"
#include "ptypes.h"

//----------------------------------------------
//
// matrix and vector type definitions
//

typedef struct {
    fp14 x, y, z, w;
} point4;

typedef struct {
    fp14 x, y, z;
} point3;

typedef struct {
    fp14 x, y;
} point2;

typedef struct {
    fp14 el[3][3];
} matrix3x3;

typedef struct {
    fp14 el[4][3];
} matrix4x3;

//----------------------------------------------
//
// Utility routines
//

extern void printMat4x3(char *label, matrix4x3 *m);
extern void printPoint3(char *label, point3 *p);
extern void printPoint2(char *label, point2 *p);

//----------------------------------------------
//
// 3d graphics routines
//

#define project(newpt, oldpt)                               \
    {                                                       \
        fp14 _zinv_ = fpInv((oldpt).z);                     \
        (newpt).x = fpMul((oldpt).x, _zinv_) + sXCenter;    \
        (newpt).y = fpMul((oldpt).y, _zinv_) + sYCenter;    \
    }

#define transform(trans, newpt, oldpt)               \
    (newpt).x = fpMul((oldpt).x, (trans).el[0][0]) + \
                fpMul((oldpt).y, (trans).el[1][0]) + \
                fpMul((oldpt).z, (trans).el[2][0]) + \
                (trans).el[3][0];                    \
                                                     \
    (newpt).y = fpMul((oldpt).x, (trans).el[0][1]) + \
                fpMul((oldpt).y, (trans).el[1][1]) + \
                fpMul((oldpt).z, (trans).el[2][1]) + \
                (trans).el[3][1];                    \
                                                     \
    (newpt).z = fpMul((oldpt).x, (trans).el[0][2]) + \
                fpMul((oldpt).y, (trans).el[1][2]) + \
                fpMul((oldpt).z, (trans).el[2][2]) + \
                (trans).el[3][2];

extern matrix4x3 *identity(matrix4x3 *m);

extern matrix4x3 *rotatex(matrix4x3 *m, int32 angle);

extern matrix4x3 *rotatey(matrix4x3 *m, int32 angle);

extern matrix4x3 *rotatez(matrix4x3 *m, int32 angle);

extern matrix4x3 *scale(matrix4x3 *m, 
                        fp14 scaleX, 
                        fp14 scaleY, 
                        fp14 scaleZ);

extern matrix4x3 *translate(matrix4x3 *m, 
                            fp14 transX, 
                            fp14 transY, 
                            fp14 transZ);

//----------------------------------------------
//
// Viewport structures and routines
//

// set by the last call to view

extern fp14 sXCenter;
extern fp14 sYCenter;
extern fp14 sXScale;
extern fp14 sYScale;

extern matrix4x3 *view(matrix4x3 *m, 
                       fp14 scrWidth, fp14 scrHeight, 
                       fp14 wLeft, fp14 wRight, fp14 wTop, fp14 wBottom, 
                       fp14 eyeDist);

#endif
