//
// Written by: Robert C. Pendleton
// 
// Copyright 1993 by Robert C. Pendleton, all right reserved
//
// Non-commercial use by individuals is permitted.
//
//

#include <stdio.h>
#include <stdlib.h>

#include "fixed.h"

//----------------------------------------------
//
// 18.14 fixed point sine and cosine tables.
//
// These tables assume that there are 1024 "degrees"
// in a circle.
//

fp14 sine[] =
{
      0,    100,    201,    301,    402,    502,    603,    703,
    803,    904,   1004,   1105,   1205,   1305,   1405,   1505,
   1605,   1705,   1805,   1905,   2005,   2105,   2204,   2304,
   2404,   2503,   2602,   2701,   2801,   2900,   2998,   3097,
   3196,   3294,   3393,   3491,   3589,   3687,   3785,   3883,
   3980,   4078,   4175,   4272,   4369,   4466,   4563,   4659,
   4756,   4852,   4948,   5043,   5139,   5234,   5329,   5424,
   5519,   5614,   5708,   5802,   5896,   5990,   6083,   6176,
   6269,   6362,   6455,   6547,   6639,   6731,   6822,   6914,
   7005,   7095,   7186,   7276,   7366,   7456,   7545,   7634,
   7723,   7811,   7900,   7988,   8075,   8162,   8249,   8336,
   8423,   8509,   8594,   8680,   8765,   8850,   8934,   9018,
   9102,   9185,   9268,   9351,   9434,   9516,   9597,   9679,
   9759,   9840,   9920,  10000,  10079,  10159,  10237,  10315,
  10393,  10471,  10548,  10625,  10701,  10777,  10853,  10928,
  11002,  11077,  11150,  11224,  11297,  11370,  11442,  11513,
  11585,  11656,  11726,  11796,  11866,  11935,  12003,  12072,
  12139,  12207,  12273,  12340,  12406,  12471,  12536,  12600,
  12665,  12728,  12791,  12854,  12916,  12977,  13038,  13099,
  13159,  13219,  13278,  13337,  13395,  13452,  13510,  13566,
  13622,  13678,  13733,  13788,  13842,  13895,  13948,  14001,
  14053,  14104,  14155,  14205,  14255,  14304,  14353,  14401,
  14449,  14496,  14543,  14589,  14634,  14679,  14723,  14767,
  14810,  14853,  14895,  14937,  14978,  15018,  15058,  15098,
  15136,  15175,  15212,  15249,  15286,  15322,  15357,  15392,
  15426,  15459,  15492,  15525,  15557,  15588,  15618,  15649,
  15678,  15707,  15735,  15763,  15790,  15817,  15842,  15868,
  15892,  15917,  15940,  15963,  15985,  16007,  16028,  16049,
  16069,  16088,  16107,  16125,  16142,  16159,  16175,  16191,
  16206,  16221,  16234,  16248,  16260,  16272,  16284,  16294,
  16305,  16314,  16323,  16331,  16339,  16346,  16353,  16359,
  16364,  16368,  16372,  16376,  16379,  16381,  16382,  16383,
  16384,  16383,  16382,  16381,  16379,  16376,  16372,  16368,
  16364,  16359,  16353,  16346,  16339,  16331,  16323,  16314,
  16305,  16294,  16284,  16272,  16260,  16248,  16234,  16221,
  16206,  16191,  16175,  16159,  16142,  16125,  16107,  16088,
  16069,  16049,  16028,  16007,  15985,  15963,  15940,  15917,
  15892,  15868,  15842,  15817,  15790,  15763,  15735,  15707,
  15678,  15649,  15618,  15588,  15557,  15525,  15492,  15459,
  15426,  15392,  15357,  15322,  15286,  15249,  15212,  15175,
  15136,  15098,  15058,  15018,  14978,  14937,  14895,  14853,
  14810,  14767,  14723,  14679,  14634,  14589,  14543,  14496,
  14449,  14401,  14353,  14304,  14255,  14205,  14155,  14104,
  14053,  14001,  13948,  13895,  13842,  13788,  13733,  13678,
  13622,  13566,  13510,  13452,  13395,  13337,  13278,  13219,
  13159,  13099,  13038,  12977,  12916,  12854,  12791,  12728,
  12665,  12600,  12536,  12471,  12406,  12340,  12273,  12207,
  12139,  12072,  12003,  11935,  11866,  11796,  11726,  11656,
  11585,  11513,  11442,  11370,  11297,  11224,  11150,  11077,
  11002,  10928,  10853,  10777,  10701,  10625,  10548,  10471,
  10393,  10315,  10237,  10159,  10079,  10000,   9920,   9840,
   9759,   9679,   9597,   9516,   9434,   9351,   9268,   9185,
   9102,   9018,   8934,   8850,   8765,   8680,   8594,   8509,
   8423,   8336,   8249,   8162,   8075,   7988,   7900,   7811,
   7723,   7634,   7545,   7456,   7366,   7276,   7186,   7095,
   7005,   6914,   6822,   6731,   6639,   6547,   6455,   6362,
   6269,   6176,   6083,   5990,   5896,   5802,   5708,   5614,
   5519,   5424,   5329,   5234,   5139,   5043,   4948,   4852,
   4756,   4659,   4563,   4466,   4369,   4272,   4175,   4078,
   3980,   3883,   3785,   3687,   3589,   3491,   3393,   3294,
   3196,   3097,   2998,   2900,   2801,   2701,   2602,   2503,
   2404,   2304,   2204,   2105,   2005,   1905,   1805,   1705,
   1605,   1505,   1405,   1305,   1205,   1105,   1004,    904,
    803,    703,    603,    502,    402,    301,    201,    100,
      0,   -100,   -201,   -301,   -402,   -502,   -603,   -703,
   -803,   -904,  -1004,  -1105,  -1205,  -1305,  -1405,  -1505,
  -1605,  -1705,  -1805,  -1905,  -2005,  -2105,  -2204,  -2304,
  -2404,  -2503,  -2602,  -2701,  -2801,  -2900,  -2998,  -3097,
  -3196,  -3294,  -3393,  -3491,  -3589,  -3687,  -3785,  -3883,
  -3980,  -4078,  -4175,  -4272,  -4369,  -4466,  -4563,  -4659,
  -4756,  -4852,  -4948,  -5043,  -5139,  -5234,  -5329,  -5424,
  -5519,  -5614,  -5708,  -5802,  -5896,  -5990,  -6083,  -6176,
  -6269,  -6362,  -6455,  -6547,  -6639,  -6731,  -6822,  -6914,
  -7005,  -7095,  -7186,  -7276,  -7366,  -7456,  -7545,  -7634,
  -7723,  -7811,  -7900,  -7988,  -8075,  -8162,  -8249,  -8336,
  -8423,  -8509,  -8594,  -8680,  -8765,  -8850,  -8934,  -9018,
  -9102,  -9185,  -9268,  -9351,  -9434,  -9516,  -9597,  -9679,
  -9759,  -9840,  -9920, -10000, -10079, -10159, -10237, -10315,
 -10393, -10471, -10548, -10625, -10701, -10777, -10853, -10928,
 -11002, -11077, -11150, -11224, -11297, -11370, -11442, -11513,
 -11585, -11656, -11726, -11796, -11866, -11935, -12003, -12072,
 -12139, -12207, -12273, -12340, -12406, -12471, -12536, -12600,
 -12665, -12728, -12791, -12854, -12916, -12977, -13038, -13099,
 -13159, -13219, -13278, -13337, -13395, -13452, -13510, -13566,
 -13622, -13678, -13733, -13788, -13842, -13895, -13948, -14001,
 -14053, -14104, -14155, -14205, -14255, -14304, -14353, -14401,
 -14449, -14496, -14543, -14589, -14634, -14679, -14723, -14767,
 -14810, -14853, -14895, -14937, -14978, -15018, -15058, -15098,
 -15136, -15175, -15212, -15249, -15286, -15322, -15357, -15392,
 -15426, -15459, -15492, -15525, -15557, -15588, -15618, -15649,
 -15678, -15707, -15735, -15763, -15790, -15817, -15842, -15868,
 -15892, -15917, -15940, -15963, -15985, -16007, -16028, -16049,
 -16069, -16088, -16107, -16125, -16142, -16159, -16175, -16191,
 -16206, -16221, -16234, -16248, -16260, -16272, -16284, -16294,
 -16305, -16314, -16323, -16331, -16339, -16346, -16353, -16359,
 -16364, -16368, -16372, -16376, -16379, -16381, -16382, -16383,
 -16384, -16383, -16382, -16381, -16379, -16376, -16372, -16368,
 -16364, -16359, -16353, -16346, -16339, -16331, -16323, -16314,
 -16305, -16294, -16284, -16272, -16260, -16248, -16234, -16221,
 -16206, -16191, -16175, -16159, -16142, -16125, -16107, -16088,
 -16069, -16049, -16028, -16007, -15985, -15963, -15940, -15917,
 -15892, -15868, -15842, -15817, -15790, -15763, -15735, -15707,
 -15678, -15649, -15618, -15588, -15557, -15525, -15492, -15459,
 -15426, -15392, -15357, -15322, -15286, -15249, -15212, -15175,
 -15136, -15098, -15058, -15018, -14978, -14937, -14895, -14853,
 -14810, -14767, -14723, -14679, -14634, -14589, -14543, -14496,
 -14449, -14401, -14353, -14304, -14255, -14205, -14155, -14104,
 -14053, -14001, -13948, -13895, -13842, -13788, -13733, -13678,
 -13622, -13566, -13510, -13452, -13395, -13337, -13278, -13219,
 -13159, -13099, -13038, -12977, -12916, -12854, -12791, -12728,
 -12665, -12600, -12536, -12471, -12406, -12340, -12273, -12207,
 -12139, -12072, -12003, -11935, -11866, -11796, -11726, -11656,
 -11585, -11513, -11442, -11370, -11297, -11224, -11150, -11077,
 -11002, -10928, -10853, -10777, -10701, -10625, -10548, -10471,
 -10393, -10315, -10237, -10159, -10079, -10000,  -9920,  -9840,
  -9759,  -9679,  -9597,  -9516,  -9434,  -9351,  -9268,  -9185,
  -9102,  -9018,  -8934,  -8850,  -8765,  -8680,  -8594,  -8509,
  -8423,  -8336,  -8249,  -8162,  -8075,  -7988,  -7900,  -7811,
  -7723,  -7634,  -7545,  -7456,  -7366,  -7276,  -7186,  -7095,
  -7005,  -6914,  -6822,  -6731,  -6639,  -6547,  -6455,  -6362,
  -6269,  -6176,  -6083,  -5990,  -5896,  -5802,  -5708,  -5614,
  -5519,  -5424,  -5329,  -5234,  -5139,  -5043,  -4948,  -4852,
  -4756,  -4659,  -4563,  -4466,  -4369,  -4272,  -4175,  -4078,
  -3980,  -3883,  -3785,  -3687,  -3589,  -3491,  -3393,  -3294,
  -3196,  -3097,  -2998,  -2900,  -2801,  -2701,  -2602,  -2503,
  -2404,  -2304,  -2204,  -2105,  -2005,  -1905,  -1805,  -1705,
  -1605,  -1505,  -1405,  -1305,  -1205,  -1105,  -1004,   -904,
   -803,   -703,   -603,   -502,   -402,   -301,   -201,   -100,
};

fp14 cosine[] =
{
  16384,  16383,  16382,  16381,  16379,  16376,  16372,  16368,
  16364,  16359,  16353,  16346,  16339,  16331,  16323,  16314,
  16305,  16294,  16284,  16272,  16260,  16248,  16234,  16221,
  16206,  16191,  16175,  16159,  16142,  16125,  16107,  16088,
  16069,  16049,  16028,  16007,  15985,  15963,  15940,  15917,
  15892,  15868,  15842,  15817,  15790,  15763,  15735,  15707,
  15678,  15649,  15618,  15588,  15557,  15525,  15492,  15459,
  15426,  15392,  15357,  15322,  15286,  15249,  15212,  15175,
  15136,  15098,  15058,  15018,  14978,  14937,  14895,  14853,
  14810,  14767,  14723,  14679,  14634,  14589,  14543,  14496,
  14449,  14401,  14353,  14304,  14255,  14205,  14155,  14104,
  14053,  14001,  13948,  13895,  13842,  13788,  13733,  13678,
  13622,  13566,  13510,  13452,  13395,  13337,  13278,  13219,
  13159,  13099,  13038,  12977,  12916,  12854,  12791,  12728,
  12665,  12600,  12536,  12471,  12406,  12340,  12273,  12207,
  12139,  12072,  12003,  11935,  11866,  11796,  11726,  11656,
  11585,  11513,  11442,  11370,  11297,  11224,  11150,  11077,
  11002,  10928,  10853,  10777,  10701,  10625,  10548,  10471,
  10393,  10315,  10237,  10159,  10079,  10000,   9920,   9840,
   9759,   9679,   9597,   9516,   9434,   9351,   9268,   9185,
   9102,   9018,   8934,   8850,   8765,   8680,   8594,   8509,
   8423,   8336,   8249,   8162,   8075,   7988,   7900,   7811,
   7723,   7634,   7545,   7456,   7366,   7276,   7186,   7095,
   7005,   6914,   6822,   6731,   6639,   6547,   6455,   6362,
   6269,   6176,   6083,   5990,   5896,   5802,   5708,   5614,
   5519,   5424,   5329,   5234,   5139,   5043,   4948,   4852,
   4756,   4659,   4563,   4466,   4369,   4272,   4175,   4078,
   3980,   3883,   3785,   3687,   3589,   3491,   3393,   3294,
   3196,   3097,   2998,   2900,   2801,   2701,   2602,   2503,
   2404,   2304,   2204,   2105,   2005,   1905,   1805,   1705,
   1605,   1505,   1405,   1305,   1205,   1105,   1004,    904,
    803,    703,    603,    502,    402,    301,    201,    100,
      0,   -100,   -201,   -301,   -402,   -502,   -603,   -703,
   -803,   -904,  -1004,  -1105,  -1205,  -1305,  -1405,  -1505,
  -1605,  -1705,  -1805,  -1905,  -2005,  -2105,  -2204,  -2304,
  -2404,  -2503,  -2602,  -2701,  -2801,  -2900,  -2998,  -3097,
  -3196,  -3294,  -3393,  -3491,  -3589,  -3687,  -3785,  -3883,
  -3980,  -4078,  -4175,  -4272,  -4369,  -4466,  -4563,  -4659,
  -4756,  -4852,  -4948,  -5043,  -5139,  -5234,  -5329,  -5424,
  -5519,  -5614,  -5708,  -5802,  -5896,  -5990,  -6083,  -6176,
  -6269,  -6362,  -6455,  -6547,  -6639,  -6731,  -6822,  -6914,
  -7005,  -7095,  -7186,  -7276,  -7366,  -7456,  -7545,  -7634,
  -7723,  -7811,  -7900,  -7988,  -8075,  -8162,  -8249,  -8336,
  -8423,  -8509,  -8594,  -8680,  -8765,  -8850,  -8934,  -9018,
  -9102,  -9185,  -9268,  -9351,  -9434,  -9516,  -9597,  -9679,
  -9759,  -9840,  -9920, -10000, -10079, -10159, -10237, -10315,
 -10393, -10471, -10548, -10625, -10701, -10777, -10853, -10928,
 -11002, -11077, -11150, -11224, -11297, -11370, -11442, -11513,
 -11585, -11656, -11726, -11796, -11866, -11935, -12003, -12072,
 -12139, -12207, -12273, -12340, -12406, -12471, -12536, -12600,
 -12665, -12728, -12791, -12854, -12916, -12977, -13038, -13099,
 -13159, -13219, -13278, -13337, -13395, -13452, -13510, -13566,
 -13622, -13678, -13733, -13788, -13842, -13895, -13948, -14001,
 -14053, -14104, -14155, -14205, -14255, -14304, -14353, -14401,
 -14449, -14496, -14543, -14589, -14634, -14679, -14723, -14767,
 -14810, -14853, -14895, -14937, -14978, -15018, -15058, -15098,
 -15136, -15175, -15212, -15249, -15286, -15322, -15357, -15392,
 -15426, -15459, -15492, -15525, -15557, -15588, -15618, -15649,
 -15678, -15707, -15735, -15763, -15790, -15817, -15842, -15868,
 -15892, -15917, -15940, -15963, -15985, -16007, -16028, -16049,
 -16069, -16088, -16107, -16125, -16142, -16159, -16175, -16191,
 -16206, -16221, -16234, -16248, -16260, -16272, -16284, -16294,
 -16305, -16314, -16323, -16331, -16339, -16346, -16353, -16359,
 -16364, -16368, -16372, -16376, -16379, -16381, -16382, -16383,
 -16384, -16383, -16382, -16381, -16379, -16376, -16372, -16368,
 -16364, -16359, -16353, -16346, -16339, -16331, -16323, -16314,
 -16305, -16294, -16284, -16272, -16260, -16248, -16234, -16221,
 -16206, -16191, -16175, -16159, -16142, -16125, -16107, -16088,
 -16069, -16049, -16028, -16007, -15985, -15963, -15940, -15917,
 -15892, -15868, -15842, -15817, -15790, -15763, -15735, -15707,
 -15678, -15649, -15618, -15588, -15557, -15525, -15492, -15459,
 -15426, -15392, -15357, -15322, -15286, -15249, -15212, -15175,
 -15136, -15098, -15058, -15018, -14978, -14937, -14895, -14853,
 -14810, -14767, -14723, -14679, -14634, -14589, -14543, -14496,
 -14449, -14401, -14353, -14304, -14255, -14205, -14155, -14104,
 -14053, -14001, -13948, -13895, -13842, -13788, -13733, -13678,
 -13622, -13566, -13510, -13452, -13395, -13337, -13278, -13219,
 -13159, -13099, -13038, -12977, -12916, -12854, -12791, -12728,
 -12665, -12600, -12536, -12471, -12406, -12340, -12273, -12207,
 -12139, -12072, -12003, -11935, -11866, -11796, -11726, -11656,
 -11585, -11513, -11442, -11370, -11297, -11224, -11150, -11077,
 -11002, -10928, -10853, -10777, -10701, -10625, -10548, -10471,
 -10393, -10315, -10237, -10159, -10079, -10000,  -9920,  -9840,
  -9759,  -9679,  -9597,  -9516,  -9434,  -9351,  -9268,  -9185,
  -9102,  -9018,  -8934,  -8850,  -8765,  -8680,  -8594,  -8509,
  -8423,  -8336,  -8249,  -8162,  -8075,  -7988,  -7900,  -7811,
  -7723,  -7634,  -7545,  -7456,  -7366,  -7276,  -7186,  -7095,
  -7005,  -6914,  -6822,  -6731,  -6639,  -6547,  -6455,  -6362,
  -6269,  -6176,  -6083,  -5990,  -5896,  -5802,  -5708,  -5614,
  -5519,  -5424,  -5329,  -5234,  -5139,  -5043,  -4948,  -4852,
  -4756,  -4659,  -4563,  -4466,  -4369,  -4272,  -4175,  -4078,
  -3980,  -3883,  -3785,  -3687,  -3589,  -3491,  -3393,  -3294,
  -3196,  -3097,  -2998,  -2900,  -2801,  -2701,  -2602,  -2503,
  -2404,  -2304,  -2204,  -2105,  -2005,  -1905,  -1805,  -1705,
  -1605,  -1505,  -1405,  -1305,  -1205,  -1105,  -1004,   -904,
   -803,   -703,   -603,   -502,   -402,   -301,   -201,   -100,
      0,    100,    201,    301,    402,    502,    603,    703,
    803,    904,   1004,   1105,   1205,   1305,   1405,   1505,
   1605,   1705,   1805,   1905,   2005,   2105,   2204,   2304,
   2404,   2503,   2602,   2701,   2801,   2900,   2998,   3097,
   3196,   3294,   3393,   3491,   3589,   3687,   3785,   3883,
   3980,   4078,   4175,   4272,   4369,   4466,   4563,   4659,
   4756,   4852,   4948,   5043,   5139,   5234,   5329,   5424,
   5519,   5614,   5708,   5802,   5896,   5990,   6083,   6176,
   6269,   6362,   6455,   6547,   6639,   6731,   6822,   6914,
   7005,   7095,   7186,   7276,   7366,   7456,   7545,   7634,
   7723,   7811,   7900,   7988,   8075,   8162,   8249,   8336,
   8423,   8509,   8594,   8680,   8765,   8850,   8934,   9018,
   9102,   9185,   9268,   9351,   9434,   9516,   9597,   9679,
   9759,   9840,   9920,  10000,  10079,  10159,  10237,  10315,
  10393,  10471,  10548,  10625,  10701,  10777,  10853,  10928,
  11002,  11077,  11150,  11224,  11297,  11370,  11442,  11513,
  11585,  11656,  11726,  11796,  11866,  11935,  12003,  12072,
  12139,  12207,  12273,  12340,  12406,  12471,  12536,  12600,
  12665,  12728,  12791,  12854,  12916,  12977,  13038,  13099,
  13159,  13219,  13278,  13337,  13395,  13452,  13510,  13566,
  13622,  13678,  13733,  13788,  13842,  13895,  13948,  14001,
  14053,  14104,  14155,  14205,  14255,  14304,  14353,  14401,
  14449,  14496,  14543,  14589,  14634,  14679,  14723,  14767,
  14810,  14853,  14895,  14937,  14978,  15018,  15058,  15098,
  15136,  15175,  15212,  15249,  15286,  15322,  15357,  15392,
  15426,  15459,  15492,  15525,  15557,  15588,  15618,  15649,
  15678,  15707,  15735,  15763,  15790,  15817,  15842,  15868,
  15892,  15917,  15940,  15963,  15985,  16007,  16028,  16049,
  16069,  16088,  16107,  16125,  16142,  16159,  16175,  16191,
  16206,  16221,  16234,  16248,  16260,  16272,  16284,  16294,
  16305,  16314,  16323,  16331,  16339,  16346,  16353,  16359,
  16364,  16368,  16372,  16376,  16379,  16381,  16382,  16383,
};
//----------------------------------------------
//
// Integer square root. Take the square root of an integer.
//

#define step(shift) \
    if((0x40000000l >> shift) + root <= value)          \
    {                                                   \
        value -= (0x40000000l >> shift) + root;         \
        root = (root >> 1) | (0x40000000l >> shift);    \
    }                                                   \
    else                                                \
    {                                                   \
        root = root >> 1;                               \
    }

long 
iSqrt(long value)
{
    long root = 0;

    step( 0);
    step( 2);
    step( 4);
    step( 6);
    step( 8);
    step(10);
    step(12);
    step(14);
    step(16);
    step(18);
    step(20);
    step(22);
    step(24);
    step(26);
    step(28);
    step(30);

    // round to the nearest integer, cuts max error in half

    if(root < value)
    {
        ++root;
    }

    return root;
}

//----------------------------------------------
//
// fixed point square root routines.
//

//
// slow but very accurate
//
fp14
fpSqrt1(fp14 value)
{
    fp14 root;
    fp14 next;

    if (value < int2fp(1))
    {
        return 0;
    }

    next = value >> 2;

    do
    {
        root = next;
        next = (next + fpDiv(value, next)) >> 1;
    } while (root != next);

    return root;
}

//----------------------------------------------
//
// The sqrt(a * b) = sqrt(a) * sqrt(b) and
// fixed point numbers are scaled integers
// you can take the square root of a fixed 
// point number by taking the square root of
// the integer representation of the number
// and then dividing by the square root of the
// scale factor.
//
// For fixed point formats with an even number
// of fractional bits the division can be done
// with a simple shift operation.
//

//
// fast but not as accurate as Newton iteration
//
fp14
fpSqrt2(fp14 value)
{
    long root = 0;

    step( 0);
    step( 2);
    step( 4);
    step( 6);
    step( 8);
    step(10);
    step(12);
    step(14);
    step(16);
    step(18);
    step(20);
    step(22);
    step(24);
    step(26);
    step(28);
    step(30);

    // round to the nearest integer, cuts max error in half

    if(root < value)
    {
        ++root;
    }

    root <<= 7;

    return root;
}

