//
// Written by: Robert C. Pendleton
// 
// Copyright 1993 by Robert C. Pendleton, all right reserved
//
// Non-commercial use by individuals is permitted.
//
//

#ifndef _FIXED_H_
#define _FIXED_H_

//----------------------------------------------
//
// handy macros
//

#define max(a,b) (((a) > (b)) ? (a) : (b))
#define min(a,b) (((a) < (b)) ? (a) : (b))
#define abs(a) (((a)<0) ? -(a) : (a))
#define sign(a) (((a)<0) ? -1 : (a)>0 ? 1 : 0)

//----------------------------------------------
//
// Integer math
//

//----------------------------------------------
//
// Multiply to 32 bit numbers giving a 64 bit
// result then divide the 64 bit number by a 32 
// bit value and return the result.
//

long
mulDiv(long value, long mulBy, long divBy);
#pragma aux mulDiv = \
    "imul   ecx" \
    "idiv   ebx" \
    parm [eax] [ecx] [ebx]\
    modify [edx] \
    value [eax];

extern long iSqrt(long value);

//----------------------------------------------
//
// fixed point math
//

typedef long fp14;

//----------------------------------------------
//
// handy fixed point constants
//

#define fpZero int2fp(0)
#define fpOne int2fp(1)
#define fpTwo int2fp(2)
#define fpHalf (1 << 13)

//----------------------------------------------
//
// Divide two 18.14 fixed point numbers giving
// a 18.14 fixed point result.
//

fp14
fpDiv(fp14 d1, fp14 d2);
#pragma aux fpDiv = \
    "cdq" \
    "shld   edx, eax, 14" \
    "sal    eax,14" \
    "idiv   ebx" \
    parm [eax] [ebx]\
    modify [edx] \
    value [eax];

//----------------------------------------------
//
// Fixed point inverse, need to find a better way.
//

#define fpInv(x)    fpDiv(fpOne, x)

//----------------------------------------------
//
// Divide two 18.14 fixed point numbers giving
// a 18.14 fixed point result.
//

fp14
fpMul(fp14 m1, fp14 m2);
#pragma aux fpMul = \
    "imul   ebx" \
    "shrd   eax, edx, 14" \
    parm [eax] [ebx]\
    modify [edx]\
    value [eax];

//----------------------------------------------
//
// Add and subtract fixed point numbers. :-)
//

#define fpAdd(a1, a2) ((a1) + (a2))
#define fpSub(s1, s2) ((s1) - (s2))

//----------------------------------------------
//
// Convert an integer to n N.14 fixed point 
// number and back.
//

#define int2fp(x) ((x) << 14)
#define fp2int(x) ((x) >> 14)

//----------------------------------------------
//
// Get the fractional part of an N.14 fixed point
// number.

#define fpFract(x) ((x) & 0x00003fff)

//----------------------------------------------
//
// Get the integer part of an N.14 fixed point
// number.

#define fpTrunc(x) ((x) & 0xffffc000)

//----------------------------------------------
//
// Round an N.14 fixed point number.
//

#define fpRound(x) (fpTrunc((x) + fpHalf))

//----------------------------------------------
//
// Convert a N.14 fixed point number to a
// double and back. Handy for printing and for 
// those times when you really do want to work
// with floating point values.
//

#define fp2float(x) (((double)(x)) / (1 << 14))
#define float2fp(x) ((fp14) (((double)x) * (1 << 14)))

//----------------------------------------------
//
// Table based fixed point sine and cosine 
// functions.
//

extern fp14 sine[];
extern fp14 cosine[];

#define fpSin(x) (sine[(x) & 0x3ff])
#define fpCos(x) (cosine[(x) & 0x3ff])

#define fpSqrt(x) fpSqrt2(x)
extern fp14 fpSqrt1(fp14 value);
extern fp14 fpSqrt2(fp14 value);

#endif
