//
// Written by: Robert C. Pendleton
// 
// Copyright 1993 by Robert C. Pendleton, all right reserved
//
// Non-commercial use by individuals is permitted.
//
//
#include <time.h>
#include <stdlib.h>
#include <stdio.h>

#include <dos.h>
#include <conio.h>

#include "fixed.h"
#include "tg.h"
#include "3d.h"
#include "pcx.h"

#define exchange(type, a, b)    \
{               \
    type _t_;   \
    _t_ = a;    \
    a = b;      \
    b = _t_;    \
}

/*-------------------------------------------------------------------*/

typedef struct
{
    fp14 x, y, z;
    fp14 u, v;
} point;

typedef struct
{
    fp14 x, z;
    fp14 u, v;
} edgeRec;

int
adjust(fp14 val)
{
    if (fpFract(val) == fpHalf)
    {
        val++;
    }

    return fp2int(val + fpHalf);
}

static char texture[128][128];

void
makeTexture(int type)
{
    int x, y;
    color palette[256];
    long width;
    long height;
    unsigned char *image;

    switch(type)
    {
    case 0:
        for (y = 0; y < 128; y++)
        {
            for (x = 0; x < 128; x++)
            {
                texture[y][x] = 1;
                if ((x & 0x4) && (y & 0x4))
                {
                    texture[y][x] = 2;
                }
                else if (x & 0x4)
                {
                    texture[y][x] = 3;
                }
            }
        }
        break;

    case 1:
        if (!loadPcx("til1.pcx", &width, &height, &palette, &image))
        {
            exit(0);
        }

        
        for (y = 0; y < 128; y++)
        {
            for (x = 0; x < 128; x++)
            {
                texture[y][x] = *(image + x);
            }
            image += width;
        }
        break;
    }
}

#ifdef COMMENT
static fp14 oa, ob, oc;
static fp14 ha, hb, hc;
static fp14 va, vb, vc;
#else
static float oa, ob, oc;
static float ha, hb, hc;
static float va, vb, vc;
#endif

void
span(int y, edgeRec *pt1, edgeRec *pt2)
{
    fp14 z, dz;
    fp14 u, du;
    fp14 v, dv;
    fp14 fdx;

    int idx, ix1, ix2;

    if (pt2->x < pt1->x)
    {
        exchange(edgeRec *, pt1, pt2);
    }

    ix1 = adjust(pt1->x);
    ix2 = adjust(pt2->x);
    idx = ix2 - ix1;

    if (idx == 0)
    {
        return;
    }

    idx = max(2, idx - 1);
    fdx = int2fp(idx);

    z = pt1->z;
    dz = fpDiv((pt2->z - pt1->z), fdx); 

    u = pt1->u + fpHalf;
    du = fpDiv((pt2->u - pt1->u), fdx); 

    v = pt1->v + fpHalf;
    dv = fpDiv((pt2->v - pt1->v), fdx); 

    do
    {
        if (ix1 >= 0 && ix1 < width)
        {
            setPixel(ix1, y, 5);
        }

        ix1++;

        z += dz;

        u += du;
        v += dv;
    } while (ix1 < ix2);
}

void
tspan(int y, edgeRec *pt1, edgeRec *pt2)
{
    fp14 fdx;
    int idx, ix1, ix2;

    float a, b, c;
    float u, v;
    int iu, iv;

    float sx, sy;

    if (pt2->x < pt1->x)
    {
        exchange(edgeRec *, pt1, pt2);
    }

    ix1 = adjust(pt1->x);
    ix2 = adjust(pt2->x);
    idx = ix2 - ix1;

    if (idx == 0)
    {
        return;
    }

    idx = max(2, idx - 1);
    fdx = int2fp(idx);

    sx = fp2float(sXCenter);
    sy = fp2float(sYCenter);

    a = oa + 
        (ha * (ix1 - sx)) + 
        (va * (y - sy));

    b = ob + 
        (hb * (ix1 - sx)) + 
        (vb * (y - sy));

    c = oc + 
        (hc * (ix1 - sx)) + 
        (vc * (y - sy));

    do
    {
        if (ix1 >= 0 && ix1 < width)
        {
//            printf("a=%12.4f b=%12.4f c=%12.4f\n", a, b, c);

            u = (a / c);
            v = (b / c);

//            printf("x=%8.4f y=%8.4f u=%8.4f v=%8.4f\n", ix1, y, u, v);

            iu = ((long)(u * 128)) & 0x7f;
            iv = ((long)(v * 128)) & 0x7f;

            setPixel(ix1, y, texture[iv][iu]);
        }

        ix1++;

        a += ha;
        b += hb;
        c += hc;

    } while (ix1 < ix2);
}

void
edge(edgeRec *table, point *pt1, point *pt2)
{
    fp14 x, dx;
    fp14 z, dz;
    fp14 u, du;
    fp14 v, dv;
    fp14 fdy;
    int idy, iy1, iy2;

    if (pt2->y < pt1->y)
    {
        exchange(point *, pt1, pt2)
    }

    iy1 = adjust(pt1->y);
    iy2 = adjust(pt2->y);
    idy = iy2 - iy1;

    if (idy == 0)
    {
        return;
    }

    idy = max(2, idy - 1);
    fdy = int2fp(idy);

    x = pt1->x;
    dx = fpDiv((pt2->x - pt1->x), fdy); 

    z = pt1->z;
    dz = fpDiv((pt2->z - pt1->z), fdy); 

    u = pt1->u;
    du = fpDiv((pt2->u - pt1->u), fdy); 

    v = pt1->v;
    dv = fpDiv((pt2->v - pt1->v), fdy); 

    do
    {
        if (iy1 >= 0 && iy1 < height)
        {
            table[iy1].x = x;
            table[iy1].z = z;

            table[iy1].u = u;
            table[iy1].v = v;
        }

        x += dx;
        iy1++;
        z += dz;
        u += du;
        v += dv;

    } while(iy1 < iy2);
}

edgeRec table1[240];
edgeRec table2[240];

void
tpoly(int n, point *ppnts, point *tpnts)
{
    fp14 maxy, miny;
    int imaxy, iminy;
    int iy1, iy2;

    int pnt1, pnt2;
    int i;

    float px, py, pz;
    float mx, my, mz;
    float nx, ny, nz;

    float fat;

    if (n < 3)
    {
        return;
    }

    //
    // find the the basis vectors for the polygon.
    // use the first point, the second point, and 
    // the last point in the polygon definition
    // to determine the vectors.
    //
#ifdef COMMENT
    printf("sXScale=%12.4f sYScale=%12.4f\n", 
           fp2float(sXScale), fp2float(sYScale));

    printf("sXCenter=%12.4f sYCenter=%12.4f\n", 
           fp2float(sXCenter), fp2float(sYCenter));

    for (i = 0; i < n; i++)
    {
        printf("p[%d] (%8.4f %8.4f %8.4f)\n", 
               i, 
               fp2float(tpnts[i].x),
               fp2float(tpnts[i].y),
               fp2float(tpnts[i].z));
    }
#endif

    px = fp2float(tpnts[0].x);
    py = fp2float(tpnts[0].y);
    pz = fp2float(tpnts[0].z);

    mx = fp2float(tpnts[1].x) - px;
    my = fp2float(tpnts[1].y) - py;
    mz = fp2float(tpnts[1].z) - pz;
#ifdef COMMENT
    nx = fp2float(tpnts[n - 1].x) - px;
    ny = fp2float(tpnts[n - 1].y) - py;
    nz = fp2float(tpnts[n - 1].z) - pz;
#else
    nx = px - fp2float(tpnts[n - 1].x);
    ny = py - fp2float(tpnts[n - 1].y);
    nz = pz - fp2float(tpnts[n - 1].z);
#endif

    fat = max(max(max(max(abs(px), abs(py)), 
                      max(abs(pz), abs(mx))),
                  max(max(abs(my), abs(mz)), 
                      max(abs(nx), abs(ny)))), 
              nz);

    px /= fat;
    py /= fat;
    pz /= fat;

    mx /= fat;
    my /= fat;
    mz /= fat;

    nx /= fat;
    ny /= fat;
    nz /= fat;

    ha = py * mz - pz * my;
    va = pz * mx - px * mz;
    oa = px * my - py * mx;

    hb = py * nz - pz * ny;
    vb = pz * nx - px * nz;
    ob = px * ny - py * nx;

    hc = ny * mz - nz * my;
    vc = nz * mx - nx * mz;
    oc = nx * my - ny * mx;

    printf("p[%12.4f,%12.4f,%12.4f]\n", 
           px, py, pz);

    printf("m[%12.4f,%12.4f,%12.4f]\n", 
           mx, my, mz);

    printf("n[%12.4f,%12.4f,%12.4f]\n", 
           nx, ny, nz);

    printf("\n");

    printf("o[%12.4f,%12.4f,%12.4f]\n", 
           oa, ob, oc);

    printf("h[%12.4f,%12.4f,%12.4f]\n", 
           ha, hb, hc);

    printf("v[%12.4f,%12.4f,%12.4f]\n", 
           va, vb, vc);

    printf("\n");


    //
    // find the point with the max y value and the
    // point with the min y value 
    //

    maxy = miny = ppnts[0].y;
    imaxy = iminy = 0;

    for (i = 1; i < n; i++)
    {
        if (ppnts[i].y > maxy)
        {
            maxy = ppnts[i].y;
            imaxy = i;
        }

        if (ppnts[i].y < miny)
        {
            miny = ppnts[i].y;
            iminy = i;
        }
    }

    //
    // get ready to walk the edge list
    // filling in the edge tables.
    //

    iy1 = adjust(miny);
    iy2 = adjust(maxy);

    if (iy1 == iy2)
    {
        return;
    }

    // 
    // walk from the min Y point to the max Y point
    //

    pnt1 = iminy;
    pnt2 = iminy + 1;
    if (pnt2 >= n)
    {
        pnt2 = 0;
    }

    do
    {
        edge(table1, &ppnts[pnt1], &ppnts[pnt2]);

        pnt1 = pnt2;
        pnt2 = pnt2 + 1;
        if (pnt2 >= n)
        {
            pnt2 = 0;
        }
    } while (pnt1 != imaxy);

    //
    // walk from the max Y point to the min Y point
    //

    pnt1 = imaxy;
    pnt2 = imaxy + 1;
    if (pnt2 >= n)
    {
        pnt2 = 0;
    }

    do
    {
        edge(table2, &ppnts[pnt1], &ppnts[pnt2]);

        pnt1 = pnt2;
        pnt2 = pnt2 + 1;
        if (pnt2 >= n)
        {
            pnt2 = 0;
        }
    } while (pnt1 != iminy);

    //
    // walk the edge table and fill in all the spans
    //

    iy1 = max(iy1, 0);
    iy2 = min(iy2, 240);
    do
    {
        tspan(iy1, &table1[iy1], &table2[iy1]);
        iy1++;
    } while (iy1 < iy2);
}

void
poly(int n, point *pnts)
{
    fp14 maxy, miny;
    int imaxy, iminy;
    int iy1, iy2;

    int pnt1, pnt2;
    int i;

    if (n < 3)
    {
        return;
    }

    //
    // find the point with the max y value and the
    // point with the min y value 
    //

    maxy = miny = pnts[0].y;
    imaxy = iminy = 0;

    for (i = 1; i < n; i++)
    {
        if (pnts[i].y > maxy)
        {
            maxy = pnts[i].y;
            imaxy = i;
        }

        if (pnts[i].y < miny)
        {
            miny = pnts[i].y;
            iminy = i;
        }
    }

    //
    // get ready to walk the edge list
    // filling in the edge tables.
    //

    iy1 = adjust(miny);
    iy2 = adjust(maxy);

    if (iy1 == iy2)
    {
        return;
    }

    // 
    // walk from the min Y point to the max Y point
    //

    pnt1 = iminy;
    pnt2 = iminy + 1;
    if (pnt2 >= n)
    {
        pnt2 = 0;
    }

    do
    {
        edge(table1, &pnts[pnt1], &pnts[pnt2]);

        pnt1 = pnt2;
        pnt2 = pnt2 + 1;
        if (pnt2 >= n)
        {
            pnt2 = 0;
        }
    } while (pnt1 != imaxy);

    //
    // walk from the max Y point to the min Y point
    //

    pnt1 = imaxy;
    pnt2 = imaxy + 1;
    if (pnt2 >= n)
    {
        pnt2 = 0;
    }

    do
    {
        edge(table2, &pnts[pnt1], &pnts[pnt2]);

        pnt1 = pnt2;
        pnt2 = pnt2 + 1;
        if (pnt2 >= n)
        {
            pnt2 = 0;
        }
    } while (pnt1 != iminy);

    //
    // walk the edge table and fill in all the spans
    //

    iy1 = max(iy1, 0);
    iy2 = min(iy2, 240);
    do
    {
        span(iy1, &table1[iy1], &table2[iy1]);
        iy1++;
    } while (iy1 < iy2);
}

void
quadTest()
{
    matrix4x3 mat;
    point quad[4], tquad[4], pquad[4];
    int red, green, blue;
    int i, j;
    int key = -1;
    int page;
    int xa = 0, xda = 0;
    int ya = 0, yda = 0;
    int za = 0, zda = 0;

    clock_t start_time;
    clock_t end_time;
    float total_time;
    int swaps = 0;

    tgInit();
    mode(t320x240);

    makeTexture(1);

    quad[0].x = int2fp(0);
    quad[0].y = int2fp(0);
    quad[0].z = int2fp(0);
    quad[0].u = int2fp(0);
    quad[0].v = int2fp(0);

    quad[1].x = int2fp(0);
    quad[1].y = int2fp(1);
    quad[1].z = int2fp(0);
    quad[1].u = int2fp(0);
    quad[1].v = int2fp(127);

    quad[2].x = int2fp(1);
    quad[2].y = int2fp(1);
    quad[2].z = int2fp(0);
    quad[2].u = int2fp(127);
    quad[2].v = int2fp(127);

    quad[3].x = int2fp(1);
    quad[3].y = int2fp(0);
    quad[3].z = int2fp(0);
    quad[3].u = int2fp(127);
    quad[3].v = int2fp(0);

    red = 1;
    setColor(red, 0xff, 0, 0);

    green = 2;
    setColor(green, 0, 0xff, 0);

    blue = 3;
    setColor(blue, 0, 0, 0xff);

    start_time = clock();

    page = 1;
    setActivePage(page);
    setVisiblePage(page ^ 1);

    while (key != 27)
    {
        switch(key)
        {
        case 'x':
            xda--;
            break;

        case 'X':
            xda++;
            break;

        case 'y':
            yda--;
            break;

        case 'Y':
            yda++;
            break;

        case 'z':
            zda--;
            break;

        case 'Z':
            zda++;
            break;

        case 's':
            xda = yda = zda = 0;
            break;

        case 'S':
            xda = yda = zda = 0;
            xa = ya = za = 0;
            break;

        }

        identity(&mat);
        translate(&mat, -fpHalf, -fpHalf, fpZero);

        xa = 0xff & (xa + xda);
        ya = 0xff & (ya + yda);
        za = 0xff & (za + zda);

        rotatex(&mat, xa);
        rotatey(&mat, ya);
        rotatez(&mat, za);

        view(&mat, 
             int2fp(width), int2fp(height), 
             float2fp(2), float2fp(-2), 
             float2fp(-1.5), float2fp(1.5),
             int2fp(1));

        for (j = 0; j < 4; j++)
        {
            tquad[j].u = quad[j].u;
            tquad[j].v = quad[j].v;

            transform(mat, tquad[j], quad[j]);

            pquad[j].u = tquad[j].u;
            pquad[j].v = tquad[j].v;

            project(pquad[j], tquad[j]);
        }

        clear(0);
//        poly(4, &pquad);

        tpoly(4, &pquad, &tquad);

        setActivePage(page);
        setVisiblePage(page ^ 1);
        page ^= 1;
        swaps++;

//#define PAUSE
#ifdef PAUSE
        key = -1;
        while (key == -1)
        {
            if (kbhit())
            {
                key = getch();
            }
        }
#else
        key = -1;
        if (kbhit())
        {
            key = getch();
        }
#endif
    }

    end_time = clock();
    total_time = (float)(end_time - start_time) / (float)CLOCKS_PER_SEC;

    tgFinit();

    printf("time=%f frames=%d frames/sec=%f\n",
            total_time,
            swaps,
            swaps / total_time);
}

void
main(int argc, char *argv[])
{
    quadTest();
}
