#ifndef _PCX_H_
#define _PCX_H_

#include "tg.h"

typedef struct {
    uint8 zSoftFlag;
    uint8 version;
    uint8 encoding;
    uint8 bitsPerPixel;
    int16  xMin;
    int16  yMin;
    int16  xMax;
    int16  yMax;
    int16  resX;
    int16  resY;
    uint8 hdrPalette[48];
    uint8 zsoftReserved;
    uint8 planes;
    int16  bytesPerLine;
    int16  hdrPaletteInterp;
    int16  screenSizeX;
    int16  screenSizeY;
    uint8 unused[54];
} tPCXHdr;

extern boolean
loadPcx(char *file, 
        int32 *imgWidth, 
        int32 *imgHeight, 
        color *palette, 
        uint8 **image);
#endif
