//
// Written by: Robert C. Pendleton
// 
// Placed in the public domain by the author.
//

#ifndef _TG_H_
#define _TG_H_

#include "ptypes.h"

#define t296x220 (0)
#define t320x200 (1)
#define t320x240 (2)

typedef struct
{
    uint16 red;
    uint16 green;
    uint16 blue;
} color;

typedef enum
{
    none,                       // no errors
    notVgaDisplay,              // it isn't a vga compatible display
    modeNotSupported,           // requested mode is not supported
    badPage,                    // invalid page requested
} tgErrors;

extern int32 error;                // the last error 

extern int32 maxx;                 // maximum x coord
extern int32 maxy;                 // maximum y coord

extern int32 width;                // the width in pixels
extern int32 height;               // the height in pixels

extern int32 pages;                // the number of graphic pages

extern char *modeName;             // printable name of the tweaked mode

extern uint8 *activeOffset;        // address of the active page

extern int32 lineSize;             // offset to next scan line
extern int32 pageSize;             // offset to a page

extern tgInit();                       // constructor
extern tgFinit();                      // destructor

extern void mode(int32 newMode);   // select a mode
extern void resetMode();           // go back to orignal mode

extern void clear(uint8 color);

extern void setActivePage(int32 page);
extern void setVisiblePage(int32 page);

extern void setPixel(int32 x, int32 y, uint8 color);
extern int32 getPixel(int32 x, int32 y);

extern void line(int32 x1, int32 y1, int32 x2, int32 y2, uint8 color);
extern void fillRect(int32 x, int32 y, int32 width, int32 height, uint8 color);
extern void drawChar(int32 x, int32 y, uint8 color, char c);
extern void drawText(int32 x, int32 y, uint8 color, char *string);

extern void setColor(int32 index, uint32 r, uint32 g, uint32 b);
extern void setPalette(int32 start, int32 count, color *p);

#endif
