// compiled with Borland C++ 3.1 large model
// Copyright (c) 1996 David Bollinger
#define RUBBERA_C

#include <bios.h>
#include <conio.h>   //  for getch()
#include <dos.h>     //  for MK_FP()
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

typedef unsigned char uchar;
typedef unsigned int uint;

#include "texture.h"
#include "palette.h"

int Initialize(void);
void Terminate(char *msg);
void SetMode(int mode);
void SetPalette(uchar *palette);
void Demo(void);
void RubberSheeting(void);

float a,b,c,d,e,f,g,h,i,j,k,l;    // the intercepts & coefficients
char *vram;                       // pointer to video ram

//============================================================================
void main(void)
   {
   if (Initialize())
      Demo();
   Terminate("RUBBERA.  Copyright (c) 1996 David Bollinger.");
   }

//============================================================================
// starting up and shutting down
//----------------------------------------------------------------------------
int Initialize(void)
   {
   SetMode(19);
   SetPalette(palette);
   vram = (uchar *)MK_FP(0xa000,0);
   return 1;
   }

void Terminate(char *msg)
   {
   SetMode(3);
   if (msg) puts(msg);
   exit(0);
   }

//============================================================================
// graphics stuff
//----------------------------------------------------------------------------
void SetMode(int mode)
   {
   asm   xor   ah, ah
   asm   mov   al, byte ptr mode
   asm   int   10h
   }

void SetPalette(uchar *palette)
   {
   asm   les   dx, dword ptr palette
   asm   mov   bx, 0
   asm   mov   cx, 256
   asm   mov   ax, 0x1012
   asm   int   0x10
   }

//============================================================================
// an animation example
//----------------------------------------------------------------------------
void Demo(void)
   {
   float einc, kinc;

   // here are the values we'll "use"
   b=d=e=h=k=0;       // optimize these out of the equation
   a=64.0;            // hardcode this
   c=128.0/320.0;     // hardcode this
   e=0.001;           // ah, a variable
   g=64.0;            // hardcode
   h=128.0/320.0;     // hardcode
   k=0.001;           // ah, a variable

   einc = 0.0002;
   kinc = -0.0003;

   do {
      RubberSheeting();

      e += einc;
      if ((e>0.002) || (e<0.0001)) einc = -einc;
      k += kinc;
      if ((k>0.002) || (k<0.0001)) kinc = -kinc;

      } while (!bioskey(1));
   bioskey(0);
   }

//============================================================================
// here's the fun stuff
// since many of the coefficients = 0 we can optimize
// this is still the same equation as before, but unused terms have been
//   eliminated, constants added, and things shuffled a bit
// to make it faster: try fixed point, forward differencing, etc.
//----------------------------------------------------------------------------
void RubberSheeting(void)
   {
   long x, y;
   uint u, v;
   uchar *vptr = vram;
   float y2, abydy2, ghyjy2, yx, x2, ey, ky;

   for (y=-100; y<100; y++)
      {
      ghyjy2 = 64.0 + (128.0/200.0)*y;
      ey = e*y;
      ky = k*y;
      for (x=-160; x<160; x++)
         {
         u = 64.0 + ((128.0/320.0) + ey)*x;
         u &= 0x7f;
         v = ghyjy2 + ky*x;
         v &= 0x7f;
         *vptr++ = texture[(v<<7)+u];
         }
      }
   }

//============================================================================
