/*
 *	File:		AniSpri.h
 *	Created:	January 1997
 *	Modified:	January 1997
 *	Author: 	Cor J. Veenman
 *	Company:	CompuPhase, Bussum, Holland
 *	Purpose:	AniSprite sprite library
 */

#ifndef _ANISPRI_H
#define _ANISPRI_H

#include <windows.h>

#if !defined(_ASMAKE_DLL)

    typedef struct {
	int dummy;
    }	ASBOARD_INST, _FAR *ASBOARD;

    typedef struct {
	int dummy;
    }	ASPRITE_INST, _FAR *ASPRITE;

#   if defined(__WIN32__) || defined(WIN32) || defined(_WIN32)
#	define ASAPI	 __declspec(dllimport) __stdcall
#   else
#	define ASAPI	 WINAPI
#   endif
#endif

typedef enum {
    AS_MASK_NONE,
    AS_MASK_CUTOUT,
    AS_MASK_SHINE,
    AS_MASK_ALPHA,
    AS_MASK_CODES,
}   AS_MASK_CODE;

typedef enum {
    AS_VALUEPTR_ALPHA_LEVEL,
    AS_VALUEPTR_BITMAPINFO,
    AS_VALUEPTR_BOARD,
    AS_VALUEPTR_BOX,
    AS_VALUEPTR_BRIGHTNESS_LEVEL,
    AS_VALUEPTR_IMAGEBITS,
    AS_VALUEPTR_MASKBITS,
    AS_VALUEPTR_SPRITE,

    AS_VALUE_HEIGHT = 10,
    AS_VALUE_LAYER,             // 11
    AS_VALUE_MASKCODE,          // 12
    AS_VALUE_MASKED,            // 13
    AS_VALUE_MASKSUPPORT,       // 14
    AS_VALUE_NUMSPRITES,        // 15
    AS_VALUE_PALCOLORS,         // 16
    AS_VALUE_VISIBLE,           // 17
    AS_VALUE_WIDTH,             // 18
    AS_VALUE_XPOS,              // 19
    AS_VALUE_YPOS,              // 20
    AS_VALUES,
}   AS_VALUE_TYPE;

typedef enum {
    AS_ERROR_NONE,
    AS_ERROR_ASSIGNED,          // 1
    AS_ERROR_BOARDMISMATCH,     // 2
    AS_ERROR_INVALIDCODE,       // 3
    AS_ERROR_INVALIDINDEX,      // 4
    AS_ERROR_INVALIDPOINTER,    // 5
    AS_ERROR_NOTEMPTY,          // 6
    AS_ERROR_OPAQUE,            // 7
    AS_ERROR_OUTOFMEMORY,       // 8
    AS_ERROR_UNASSIGNED,        // 9
    AS_ERROR_UNSUPPORTED,       // 10
    AS_ERRORS,
}   AS_ERROR_TYPE;


#define AS_MODE_PAL_COLORS          (0x01)
#define AS_MODE_BACKSHINING         (0x02)
#define AS_MODE_ALPHABLENDING       (0x04)

typedef ASBOARD _FAR *LPASBOARD;
typedef ASPRITE _FAR *LPASPRITE;

/* Board functions */

BOOL ASAPI as_CreateBoard(LPASBOARD lpBoard,
			  LPBITMAPINFO lpBitsInfo, LPVOID lpBits,
			  LPRECT lpVisRect, int Code);

BOOL ASAPI as_DeleteBoard(LPASBOARD lpBoard);

BOOL ASAPI as_SetBoardValuePtr(ASBOARD Board, int Code, int Index, LPVOID Value);

LPVOID ASAPI as_GetBoardValuePtr(ASBOARD Board, int Code, int Index);

int ASAPI as_GetBoardValue(ASBOARD Board, int Code, int Index);

BOOL ASAPI as_PtInBoard(ASBOARD Board, int X, int Y);

BOOL ASAPI as_PaintBoard(HDC hDC, ASBOARD Board, int X, int Y, BOOL PaintAll);

BOOL ASAPI as_ReplaceBoard(ASBOARD Board, int Width, int Height, LPVOID lpBits,
			   LPRECT lpVisRect, LPRECT lpInvalidRect);

/* Sprite functions */

BOOL ASAPI as_Animate(ASPRITE Sprite, int Width, int Height,
		      LPVOID lpMask, int MaskCode,
		      LPVOID lpImage, BOOL ImageMasked,
		      LPRECT lpInvalidRect);

BOOL ASAPI as_Assign(ASBOARD Board, int Layer, ASPRITE Sprite);

BOOL ASAPI as_Collide(ASPRITE Sprite1, ASPRITE Sprite2);

BOOL ASAPI as_CollideBox(ASPRITE Sprite, LPRECT lpBox);

BOOL ASAPI as_Create(LPASPRITE lpSprite, int Width, int Height,
		     LPVOID lpMask, int MaskCode,
		     LPVOID lpImage, BOOL ImageMasked);

LPVOID ASAPI as_CreateAlphaLevel(LPRGBQUAD lpPal, double InterFactor);

LPVOID ASAPI as_CreateMask(LPBITMAPINFO lpBitsInfo, LPVOID lpBits,
			   BOOL MaskImage,
			   COLORREF _FAR *crTransColor, int Colors);

LPVOID ASAPI as_CreateBrightnessLevel(LPRGBQUAD lpPal, double Brightness);


LPVOID ASAPI as_SmoothMask(int Width, int Height, LPVOID lpMask, int Order);

ASPRITE ASAPI as_SpriteAtPos(ASBOARD Board, int X, int Y);

BOOL ASAPI as_LevelInMask(int Width, int Height, LPVOID lpMask, int Level);

BOOL ASAPI as_Delete(LPASPRITE lpSprite);

LPVOID ASAPI as_DeleteResource(LPVOID Resource);

LPVOID ASAPI as_GetValuePtr(ASPRITE Sprite, int Code);

int ASAPI as_GetValue(ASPRITE Sprite, int Code);

BOOL ASAPI as_InBox(ASPRITE Sprite, LPRECT lpBox);

LPVOID ASAPI as_MonoToColorMask(int Width, int Height, LPVOID lpMonoBits);

BOOL ASAPI as_Move(ASPRITE Sprite, int X, int Y);

BOOL ASAPI as_PtInSprite(ASPRITE Sprite, int X, int Y);

BOOL ASAPI as_Show(ASPRITE Sprite, BOOL Show);

int ASAPI as_LastError(void);

#endif
