/*
 *      File:           Generic.c
 *      Created:        April 1997
 *	Author: 	Cor J. Veenman
 *	Company:	CompuPhase, Bussum, Holland
 *      Purpose:        Generic AniSprite application
 */

#include <windows.h>
#include <stdlib.h>
#include <malloc.h>
#include <stdio.h>
#include <time.h>
#include <assert.h>
#include <string.h>

#include "anispri.h"

#if defined(__WIN32__) || defined(WIN32) || defined(_WIN32)
    #define MALLOC(n)	malloc(n)
    #define FREE(b)	free(b)
#else
    #define MALLOC(n)	_fmalloc(n)
    #define FREE(b)	_ffree(b)
#endif

#define SPRITES	(2)

static LPVOID LoadBitmapBits(LPSTR lpName, LPBITMAPINFO lpBitsInfo)
{
    int file;
    LPVOID lpBits;
    long LineSize, BitmapSize;

    if ((file = _lopen(lpName, OF_READ | OF_SHARE_DENY_WRITE)) < 0) {
        return(NULL);
    } /* endif */

    _llseek(file, 14, SEEK_SET);
    _lread(file, &lpBitsInfo->bmiHeader, sizeof(BITMAPINFOHEADER));
    _lread(file, lpBitsInfo->bmiColors, 256 * sizeof(RGBQUAD));
    assert(lpBitsInfo->bmiHeader.biBitCount == 8);
    LineSize = (int) (((lpBitsInfo->bmiHeader.biWidth * 8 + 31) & ~31u) >> 3u);
    BitmapSize = lpBitsInfo->bmiHeader.biHeight * LineSize;

    if ((lpBits = MALLOC(BitmapSize)) != NULL) {
    	_hread(file, lpBits, BitmapSize);
    } /* endif */
    _lclose(file);
    return(lpBits);
}

static HPALETTE MakeDIBPalette (LPBITMAPINFO lpBitsInfo)
{
    NPLOGPALETTE npPal;
    RGBQUAD far *lpRGB;
    HPALETTE hLogPal;
    WORD i;

    assert(lpBitsInfo->bmiHeader.biBitCount == 8);

    npPal = (NPLOGPALETTE) LocalAlloc(LMEM_FIXED, sizeof(LOGPALETTE) +
                                      256 * sizeof(PALETTEENTRY));
    if (!npPal)
       return (NULL);

    npPal->palVersion = 0x300;
    npPal->palNumEntries = 256;

    /* get pointer to the color table */
    lpRGB = lpBitsInfo->bmiColors;

    /* copy colors from the color table to the LogPalette structure */
    for (i = 0; i < 256; i++, lpRGB++) {
        npPal->palPalEntry[i].peRed = lpRGB->rgbRed;
        npPal->palPalEntry[i].peGreen = lpRGB->rgbGreen;
        npPal->palPalEntry[i].peBlue = lpRGB->rgbBlue;
        npPal->palPalEntry[i].peFlags = 0;
    } /* endfor */

    hLogPal = CreatePalette((LPLOGPALETTE)npPal);
    LocalFree((HANDLE)npPal);
    return(hLogPal);
}

long FAR PASCAL MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
static LPSTR SpriteName[SPRITES] = {
     "zonya.bmp",
     "nthila.bmp"
};

static LPVOID BoardBits;
static HPALETTE hPalette, hOldPal;
static ASBOARD Board;
static ASPRITE DragSprite;
static int dx[SPRITES];
static int dy[SPRITES];
static int OffsetX, OffsetY;
static COLORREF crTransColor[] = {PALETTEINDEX(246)};

    PAINTSTRUCT ps;
    HDC hDC;
    int i;
    RECT rc;
    LPVOID lpBits, lpMask;
    ASPRITE Sprite;
    LPBITMAPINFO lpBitsInfo;
    int x, y;

    switch (message) {
    case WM_CREATE:

        BoardBits = NULL;

        for (i = 0; i < SPRITES; i++)
            dx[i] = dy[i] = 5;

        lpBitsInfo = MALLOC(sizeof(BITMAPINFO) + 256 * sizeof(RGBQUAD));

        if ((BoardBits = LoadBitmapBits("backgr.bmp", lpBitsInfo)) != NULL) {
            hPalette = MakeDIBPalette(lpBitsInfo);

            as_CreateBoard(&Board, lpBitsInfo, BoardBits, NULL,
                           AS_MODE_PAL_COLORS);

            for (i = 0; i < SPRITES; i++) {
            	lpBits = LoadBitmapBits(SpriteName[i], lpBitsInfo);
            	lpMask = as_CreateMask(lpBitsInfo, lpBits, TRUE, crTransColor, 1);

            	as_Create(&Sprite,
			  (int) lpBitsInfo->bmiHeader.biWidth,
                          (int) lpBitsInfo->bmiHeader.biHeight,
            	          lpMask, AS_MASK_CUTOUT, lpBits, TRUE);

	    	as_Assign(Board, 0, Sprite);
            	as_Move(Sprite, (i + 1) * 100, 100);
            } /* endfor */

        } /* endif */

        FREE(lpBitsInfo);

        DragSprite = NULL;
        SetTimer(hWnd, 0, 10, NULL);
        break;

    case WM_TIMER:
        for (i = 0; i < SPRITES; i++) {
            Sprite = as_GetBoardValuePtr(Board, AS_VALUEPTR_SPRITE, i);

            /* If this sprite is dragged, then don't animate it */
            if (Sprite == DragSprite) {
                continue;
            } /* endif */

            /* Hide the sprite to optimise for trial moves */
            as_Show(Sprite, FALSE);

            GetClientRect(hWnd, &rc);

            x = as_GetValue(Sprite, AS_VALUE_XPOS);
            y = as_GetValue(Sprite, AS_VALUE_YPOS);

            if ((rand() & 0x1f) == 0)
                dx[i]++;
            if ((rand() & 0x1f) == 0)
                dy[i]++;

            as_Move(Sprite, x + dx[i], y + dy[i]);
            if (!as_InBox(Sprite, &rc)) {
                dx[i] = -dx[i];
                as_Move(Sprite, x + dx[i], y + dy[i]);
                if (!as_InBox(Sprite, &rc)) {
                    dx[i] = -dx[i];
                    dy[i] = -dy[i];
                    as_Move(Sprite, x + dx[i], y + dy[i]);
                    if (!as_InBox(Sprite, &rc)) {
                        dx[i] = -dx[i];
                        as_Move(Sprite, x + dx[i], y + dy[i]);
                        if (!as_InBox(Sprite, &rc)) {
                            as_Move(Sprite, 80 * (i % 6), 200 * (i / 6));
                        } /* endif */
                    } /* endif */
                } /* endif */
#ifdef COLLISION_DETECT
            } else {
            	ASPRITE Sprite1;
                int j;

                for (j = 0; j < SPRITES; j++) {
                    if (i == j)
                        continue;
                    if ((Sprite1 = as_GetBoardValuePtr(Board, AS_VALUEPTR_SPRITE, j)) != NULL
                      && as_Collide(Sprite, Sprite1)) {
                        dx[i] = -dx[i];
                        as_Move(Sprite, x + dx[i], y + dy[i]);
                        if (as_Collide(Sprite, Sprite1)) {
                            dx[i] = -dx[i];
                            dy[i] = -dy[i];
                            as_Move(Sprite, x + dx[i], y + dy[i]);
                        } /* endif */
                        if (as_Collide(Sprite, Sprite1)) {
                            dx[i] = -dx[i];
                            as_Move(Sprite, x + dx[i], y + dy[i]);
                            if (as_Collide(Sprite, Sprite1)) {
                                dx[i] = -dx[i];
                                dy[i] = -dy[i];
                                as_Move(Sprite, x + dx[i], y + dy[i]);
                            } /* endif */
                        } /* endif */
                    } /* endif */
                } /* endfor */
#endif
            } /* endif */

            as_Show(Sprite, TRUE);

        } /* endfor */

	hDC = GetDC(hWnd);
        hOldPal = SelectPalette(hDC, hPalette, FALSE);
        RealizePalette(hDC);
        as_PaintBoard(hDC, Board, 0, 0, FALSE);
        SelectPalette(hDC, hOldPal, TRUE);
        RealizePalette(hDC);
	ReleaseDC(hWnd, hDC);
	break;

    case WM_LBUTTONDOWN:
        if ((DragSprite = as_SpriteAtPos(Board, LOWORD(lParam), HIWORD(lParam))) != NULL) {
            rc = *(LPRECT) as_GetValuePtr(DragSprite, AS_VALUEPTR_BOX);
            OffsetX = LOWORD(lParam) - rc.left;
            OffsetY = HIWORD(lParam) - rc.top;
        } /* endif */
        break;

    case WM_LBUTTONUP:
        DragSprite  = NULL;
	break;

    case WM_MOUSEMOVE:
        if (DragSprite) {
            as_Move(DragSprite, LOWORD(lParam) - OffsetX, HIWORD(lParam) - OffsetY);
	    hDC = GetDC(hWnd);
	    hOldPal = SelectPalette(hDC, hPalette, FALSE);
	    RealizePalette(hDC);
            as_PaintBoard(hDC, Board, 0, 0, FALSE);
	    SelectPalette(hDC, hOldPal, TRUE);
	    RealizePalette(hDC);
	    ReleaseDC(hWnd, hDC);
	} /* endif */
	break;

    case WM_PAINT:
    	hDC = BeginPaint(hWnd, &ps);
	hOldPal = SelectPalette(hDC, hPalette, FALSE);
	RealizePalette(hDC);
        as_PaintBoard(hDC, Board, 0, 0, TRUE);
        SelectPalette(hDC, hOldPal, TRUE);
	RealizePalette(hDC);
	EndPaint(hWnd, &ps);
	break;
    case WM_DESTROY:	      /* message: window being destroyed */
	KillTimer(hWnd, 0);

        while ((Sprite = as_GetBoardValuePtr(Board, AS_VALUEPTR_SPRITE, 0)) != NULL) {
            as_Assign(Board, -1, Sprite);
            lpBits = as_GetValuePtr(Sprite, AS_VALUEPTR_IMAGEBITS);
            lpMask = as_GetValuePtr(Sprite, AS_VALUEPTR_MASKBITS);
            as_Delete(&Sprite);
            FREE(lpBits);
            if (lpMask)
                as_DeleteResource(lpMask);
        } /* endif */

	if (Board) {
	    as_DeleteBoard(&Board);
	} /* endif */
        if (BoardBits) {
            FREE(BoardBits);
	} /* endif */
	PostQuitMessage(0);
	break;
    case WM_QUERYNEWPALETTE:
	hDC = GetDC(hWnd);
	hOldPal = SelectPalette(hDC, hPalette, FALSE);
	RealizePalette(hDC);
	SelectPalette(hDC, hOldPal, TRUE);
	RealizePalette(hDC);
	ReleaseDC(hWnd, hDC);
	InvalidateRect(hWnd, NULL, FALSE);
	return(TRUE);
    case WM_PALETTECHANGED:
	if ((HWND) wParam != hWnd) {
	    hDC = GetDC(hWnd);
	    hOldPal = SelectPalette(hDC, hPalette, FALSE);
	    if (RealizePalette(hDC)) {
                InvalidateRect(hWnd, NULL, FALSE);
	    } /* endif */
	    SelectPalette(hDC, hOldPal, TRUE);
	    RealizePalette(hDC);
	    ReleaseDC(hWnd, hDC);
	} /* endif */
	break;
    case WM_ERASEBKGND:

    default:		  /* Passes it on if unproccessed    */
	return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (NULL);
}


static BOOL InitApplication(HANDLE hInstance)
{
    WNDCLASS  wc;

    /* Fill in window class structure with parameters that describe the       */
    /* main window.							      */

    wc.style = NULL;			/* Class style(s).		      */
    wc.lpfnWndProc = MainWndProc;	/* Function to retrieve messages for  */
					/* windows of this class.	      */
    wc.cbClsExtra = 0;			/* No per-class extra data.	      */
    wc.cbWndExtra = 0;			/* No per-window extra data.	      */
    wc.hInstance = hInstance;		/* Application that owns the class.   */
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH) COLOR_BACKGROUND;
    wc.lpszMenuName =  NULL;
    wc.lpszClassName = "GenericAniSprite"; /* Name used in call to CreateWindow. */

    /* Register the window class and return success/failure code. */

    return (RegisterClass(&wc));
}

#pragma argsused
static BOOL InitInstance(HANDLE hInstance, int nCmdShow)
{
    HWND hWnd;


    hWnd = CreateWindow("GenericAniSprite",                /* See RegisterClass() call.          */
                        "Generic AniSprite Application",   /* Text for window title bar.         */
                        WS_VISIBLE | WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
                        CW_USEDEFAULT,                  /* Default horizontal position.       */
                        CW_USEDEFAULT,                  /* Default vertical position.         */
                        640, 480,                       /* Default dimensions                 */
                        NULL,                           /* Overlapped windows have no parent. */
                        NULL,                           /* Use the window class menu.         */
                        hInstance,                      /* This instance owns this window.    */
                        NULL);

    return (hWnd != NULL);
}

#pragma argsused
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                   LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;			 /* message		 */

    if (!hPrevInstance)                  /* Other instances of app running? */
        if (!InitApplication(hInstance)) /* Initialize shared things */
            return (FALSE);              /* Exits if unable to initialize */

    if (!InitInstance(hInstance, nCmdShow))
	return (FALSE);

    /* Acquire and dispatch messages until a WM_QUIT message is received. */

    while (GetMessage(&msg, NULL, NULL, NULL)) {
	TranslateMessage(&msg);    /* Translates virtual key codes	 */
	DispatchMessage(&msg);	   /* Dispatches message to window	 */
    } /* endwhile */

    return (msg.wParam);       /* Returns the value from PostQuitMessage */
}

