/*
**	$id: ssvcid bitmaps.h 1.3 08/03/92 10:01 am$
**		This file contains the function prototypes, global variable defines,
**	and constant defines used by the Bitmap and Icon deom program.
**
**	(C) 1991-3 Larry Widing
*/
#ifndef	__BITMAPS_H__
#define	__BITMAPS_H__	1

/*
**	Menu Item Defines
*/
#define	IDM_FILE_OPEN			101
#define	IDM_FILE_SAVE			104
#define	IDM_FILE_PRINT			105
#define	IDM_FILE_PRSETUP		106
#define	IDM_FILE_EXIT			107
#define	IDM_FILE_ABOUT			108
#define	IDM_FILE_FMT_DIB		111
#define	IDM_FILE_FMT_RLE		112
#define	IDM_FILE_FMT_OS2		113
#define	IDM_EDIT_COPY			121
#define	IDM_EDIT_PASTE			122
#define	IDM_INFO_ABOUT			131
#define	IDM_CONVERT_LOGICAL	141
#define	IDM_CONVERT_DIB		142
#define	IDM_CONVERT_RLE		143
#define	IDM_CONVERT_OS2		144
#define	IDM_CONVERT_COLORMAP	145

/*
**	Dialog Item IDs
*/
#define	IDD_FILENAME			101
#define	IDD_FILELIST			102
#define	IDD_DIRECTORY			103

/*
**	String table resource IDs
*/
#define	IDS_MAIN_TITLE			1
#define	IDS_ERROR_TITLE		2
#define	IDS_ERROR_OPENWNDW	3
#define	IDS_ERROR_REGWNDW		4
#define	IDS_OPEN_FILTER		20
#define	IDS_SAVEAS_FILTER		21

#ifndef	RC_INVOKED
/*
**	Macros
*/
#define	NULLWND	((HWND)NULL)

/*
**	Types
*/
typedef	HANDLE	HDIB;		/* Handle to a DIB */

#if	!defined(__TSC__)
#define	EXPORT	_export
#else
#define	EXPORT
#endif

/*
**	Function prototypes
*/
extern void ClearHandles(void);
extern void ErrorBox(char *msg);

/*
**	Global Variables
*/
extern HWND			MainWindow;			/* Handle to the application's main window */
extern HANDLE		AppInstance;		/* Handle to application's instance */
extern char			FileName[256];		/* Name of file returned by open file dialog */
extern HBITMAP		BitmapHandle;		/* Handle of currently loaded bitmap */
extern HICON		IconHandle;			/* Handle of currently loaded icon */
extern HDIB			DIBitmapHandle;	/* Handle of packed DI Bitmap */
extern HPALETTE	DibPalette;			/* Handle to palette for DI Bitmap */
extern HBRUSH		DialogBrush;		/* background brush for dialogs */
extern HBRUSH		GrayBrush;			/* gray brush for control backgrounds */

#ifndef	HUGE
#define	HUGE	huge
#endif
#endif

#endif	/* !defined(__BITMAPS_H__) */

/*
**	Modification History
**	--------------------
**	$lgb$
** 10/15/91     Larry Widing   Initial version for Win Tech Journal Article.
** 11/12/91     Larry Widing   Added defines for print menu options and
**                             conversion menu.
** 02/10/92     Larry Widing   Added hooks to alter the colormap.  Added HDIB
**                             typdef.  Added hooks for reading compressed RIX
**                             images.
** 08/03/92     Larry Widing   
**	$lge$
*/
