/*
**	$id: ssvcid print.c 1.1 08/03/92 10:01 am$
**		This file contains the functions needed to use the printer setup and print common dialogs.
**
**	(C) 1991-3	Larry Widing
*/
#include	<windows.h>
#include	<commdlg.h>
#include	<drivinit.h>
#include	<bwcc.h>
#include	<string.h>
#include	<malloc.h>
#include	"bitmaps.h"
#include	"bmmanip.h"
#include	"print.h"

/*
**	Local variables
*/
static HBITMAP	helpBitmaps[3];
static HBITMAP	setupBitmaps[3];
static HBITMAP	optionBitmaps[3];
static UINT		scale = 100;
static UINT		scaleMode = 0;
static HGLOBAL	DevMode;
static HGLOBAL	DevNames;

/*
**
*/
void
PrintCleanup(void)
{
	if (DevMode != (HGLOBAL)NULL)
	{
		GlobalFree(DevMode);
	}

	if (DevNames != (HGLOBAL)NULL)
	{
   	GlobalFree(DevNames);
   }
}

/*
**	UINT CALLBACK EXPORT			FALSE if common dialog handler should process message
**	PrintHook(
**	  HWND dlg,						Handle of diaog window
**	  UINT message,				Window's message being passed
**	  WPARAM wParam,				Word parameter
**	  LPARAM lParam);				Long parameter
**
**    Filter the messages being sent to the common print dialog to support the following
**	extended functions:
**			Bitmapped buttons
**			Gray coloring
**
** Modification History:
** 07/22/92  LCW  Created
*/
UINT CALLBACK EXPORT
PrintHook(HWND dlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	BOOL	rc = FALSE;
   int	i;

	switch (message)
	{
		case WM_COMMAND:
			switch (wParam)
			{
				case 2000:
				case 2001:
				case 2002:
					EnableWindow(GetDlgItem(dlg, 2003), (wParam == 2002) ? TRUE : FALSE);
               scaleMode = wParam - 2000;
					rc = TRUE;
					break;

				case IDOK:
					scale = GetDlgItemInt(dlg, 2003, &rc, FALSE);
					if (!rc)
						scale = 100;
					rc = FALSE;
					break;
			}
			break;

		case WM_CTLCOLOR:
			switch (HIWORD(lParam))
			{
				case CTLCOLOR_BTN:
				case CTLCOLOR_SCROLLBAR:
				case CTLCOLOR_LISTBOX:
					break;

				case CTLCOLOR_DLG:
				case CTLCOLOR_EDIT:
				case CTLCOLOR_MSGBOX:
            case CTLCOLOR_STATIC:
					SetBkColor((HDC)wParam, RGB(192,192,192));
               SetTextColor((HDC)wParam, RGB(0,0,0));
            	return (BOOL)(HIWORD(lParam) == CTLCOLOR_DLG ? DialogBrush : GrayBrush);
			}
			break;

		case WM_INITDIALOG:
		{
			helpBitmaps[0] = LoadBitmap(AppInstance, MAKEINTRESOURCE(100));
			helpBitmaps[1] = LoadBitmap(AppInstance, MAKEINTRESOURCE(101));
			helpBitmaps[2] = LoadBitmap(AppInstance, MAKEINTRESOURCE(102));
			SendDlgItemMessage(dlg, 1038, BBM_SETBITS, 0,
				(LONG)(LPSTR)helpBitmaps);
			SetDlgItemText(dlg, 1038, "");

			setupBitmaps[0] = LoadBitmap(AppInstance, MAKEINTRESOURCE(103));
			setupBitmaps[1] = LoadBitmap(AppInstance, MAKEINTRESOURCE(104));
			setupBitmaps[2] = LoadBitmap(AppInstance, MAKEINTRESOURCE(105));
			SendDlgItemMessage(dlg, 1024, BBM_SETBITS, 0,
				(LONG)(LPSTR)setupBitmaps);
			SetDlgItemText(dlg, 1024, "");

			CheckDlgButton(dlg, 2000, TRUE);
         EnableWindow(GetDlgItem(dlg, 2003), FALSE);
			break;
      }

		case WM_DESTROY:
			for (i = 0 ; i < 3 ; ++i)
         {
				if (helpBitmaps[i] != (HBITMAP)NULL)
				{
					DeleteObject(helpBitmaps[i]);
               helpBitmaps[i] = (HBITMAP)NULL;
				}
				if (setupBitmaps[i] != (HBITMAP)NULL)
				{
					DeleteObject(setupBitmaps[i]);
               setupBitmaps[i] = (HBITMAP)NULL;
            }
         }
         break;
   }

	return rc;
}

/*
**	UINT CALLBACK EXPORT			FALSE if common dialog handler should process message
**	PrintSetupHook(
**	  HWND dlg,						Handle of diaog window
**	  UINT message,				Window's message being passed
**	  WPARAM wParam,				Word parameter
**	  LPARAM lParam);				Long parameter
**
**    Filter the messages being sent to the common printer setup dialog to support the following
**	extended functions:
**			Bitmapped buttons
**			Gray coloring
**
** Modification History:
** 07/22/92  LCW  Created
*/
UINT CALLBACK EXPORT
PrintSetupHook(HWND dlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	BOOL	rc = FALSE;
   int	i;

	switch (message)
	{
		case WM_CTLCOLOR:
			switch (HIWORD(lParam))
			{
				case CTLCOLOR_BTN:
				case CTLCOLOR_SCROLLBAR:
				case CTLCOLOR_LISTBOX:
					break;

				case CTLCOLOR_DLG:
				case CTLCOLOR_EDIT:
				case CTLCOLOR_MSGBOX:
            case CTLCOLOR_STATIC:
					SetBkColor((HDC)wParam, RGB(192,192,192));
               SetTextColor((HDC)wParam, RGB(0,0,0));
            	return (BOOL)(HIWORD(lParam) == CTLCOLOR_DLG ? DialogBrush : GrayBrush);
			}
			break;

		case WM_INITDIALOG:
		{
			if (helpBitmaps[0] == (HBITMAP)NULL)
         {
				helpBitmaps[0] = LoadBitmap(AppInstance, MAKEINTRESOURCE(100));
				helpBitmaps[1] = LoadBitmap(AppInstance, MAKEINTRESOURCE(101));
				helpBitmaps[2] = LoadBitmap(AppInstance, MAKEINTRESOURCE(102));
         }
			SendDlgItemMessage(dlg, 1038, BBM_SETBITS, 0,
				(LONG)(LPSTR)helpBitmaps);
			SetDlgItemText(dlg, 1038, "");

			optionBitmaps[0] = LoadBitmap(AppInstance, MAKEINTRESOURCE(106));
			optionBitmaps[1] = LoadBitmap(AppInstance, MAKEINTRESOURCE(107));
			optionBitmaps[2] = LoadBitmap(AppInstance, MAKEINTRESOURCE(108));
			SendDlgItemMessage(dlg, 1024, BBM_SETBITS, 0,
				(LONG)(LPSTR)optionBitmaps);
			SetDlgItemText(dlg, 1024, "");
			break;
      }

		case WM_DESTROY:
			for (i = 0 ; i < 3 ; ++i)
         {
				if (helpBitmaps[i] != (HBITMAP)NULL && setupBitmaps[0] == (HBITMAP)NULL)
				{
					DeleteObject(helpBitmaps[i]);
               helpBitmaps[i] = (HBITMAP)NULL;
				}
				if (optionBitmaps[i] != (HBITMAP)NULL)
				{
					DeleteObject(optionBitmaps[i]);
					optionBitmaps[i] = (HBITMAP)NULL;
            }
         }
         break;
   }

	return rc;
}

/*
** void
** PrintImage(
**   HWND wnd,				Handle of parent window
**   int setupOnly);		TRUE if only the printer setup should be displayed
**
**    Print the current image, or display the printer setup to the user.
**
** Modification History:
** 07/24/92  LCW  Created
*/
void
PrintImage(HWND wnd, int setupOnly)
{
	PRINTDLG		prdata;

	/*
	**	Initialize the prdata structure
	*/
	memset(&prdata, 0, sizeof(prdata));
	prdata.lStructSize = sizeof(prdata);
	prdata.hwndOwner = wnd;
	prdata.hInstance = AppInstance;
	prdata.lpPrintTemplateName = MAKEINTRESOURCE(1538);
	prdata.lpfnPrintHook = PrintHook;
	prdata.lpSetupTemplateName = MAKEINTRESOURCE(1539);
	prdata.lpfnSetupHook = PrintSetupHook;

	if (setupOnly)
   {
		prdata.Flags = PD_PRINTSETUP | PD_SHOWHELP;
	}
	else
	{
		prdata.Flags = PD_RETURNDC | PD_ENABLEPRINTTEMPLATE | PD_ENABLEPRINTHOOK
			| PD_NOPAGENUMS | PD_NOSELECTION;
	}
	prdata.Flags |= PD_ENABLESETUPTEMPLATE | PD_ENABLESETUPHOOK;

	/*
	**	Display the printing dialogs
	*/	
	if (PrintDlg(&prdata))
	{
		if (!setupOnly)
		{
			HDIB		handle = DIBitmapHandle;
			HPALETTE palette = DibPalette;

			if (handle == (HDIB)NULL)
			{
				/*
   	      **	Create a DIB to print
				*/
				extern int	FileSaveMode;

				handle = BitmapToDIB(BitmapHandle, FileSaveMode);
      	   palette = CreateDibPalette(handle);
			}

			Escape(prdata.hDC, STARTDOC, 8, "Bitmaps", NULL);

			switch (scaleMode)
			{
         	case 0:
					DrawDIBitmap(prdata.hDC, 0, 0, handle, palette);
					break;

				case 1:
					StretchDIBitmap(prdata.hDC, 0, 0,
						GetDeviceCaps(prdata.hDC, HORZRES),
						GetDeviceCaps(prdata.hDC, VERTRES),
						handle, palette);
					break;

				case 2:
					StretchDIBitmap(prdata.hDC, 0, 0, 0, scale,
						handle, palette);
               break;
			}

			Escape(prdata.hDC, NEWFRAME, 0, NULL, NULL);
			Escape(prdata.hDC, ENDDOC, 0, NULL, NULL);

			DeleteDC(prdata.hDC);
			if (handle != DIBitmapHandle)
			{
      		GlobalFree(handle);
			}
			if (palette != DibPalette)
			{
   	   	DeleteObject(palette);
			}
		} 
		if (prdata.hDevMode != NULL)
      {
			GlobalFree(prdata.hDevMode);
      }
		if (prdata.hDevNames != NULL)
      {
			GlobalFree(prdata.hDevNames);
      }
	}
}

/*
**	Modification History
**	====================
**
**	$lgb$
** 02/10/92     Larry Widing   Initial Version.
** 08/03/92     Larry Widing   Second upload to CompuServe.
**	$lge$
*/
